Purpose: Webcallback is a sample to demo the creation of callback and chat functionality.

Prerequisite:
1. The GMS application should be up and running
2. Chat server should be up and running
3. Nodejs to be installed
4. Install http-server using the command
   cmd in windows: npm install --global http-server

Note Prerequisite step 3 and 4 are needed only to deploy and launch the Webcallback application in a server. The users can choose different ways of deployment as well.

In webcallback\src\service_config.txt file enter the list of service names for which the callback is to be created.

In command prompt cd to webcallback folder and enter the command: http-server
The http-server will be launched at http://192.168.10.98:8080

In the browser navigate to http://192.168.10.98:8080. The GMS sample page will be displayed. Select Settings tab at the bottom end of the sample page. 

In Settings page specify the url of the GMS application. Ensure that the list of services configured in service_config.txt is listed in services field.  

Select the service and move to the GMS page by selecting the GMS tab. Enter the first name, last name, password and the scenario to be demoed and click on Connect button. 

Navigate to the the callback page in GMS application to verify that the callback is created.

In case if the callback is queued the details like the position of the callback in the queue, eta can be got from the queue tab in the sample demo application

To test the chat functionality, select service name, user can also opt notification via cometd by enabling comet notifications in settings page, navigate to GMS tab select REQUEST-CHAT scenario and the click on Connect button. The sample application automatically navigates to the Chat tab.

In case if the sample application is not able to connect to the gms application ensure that cors is configured in the gms server.

Notification via cometd cors configuration :
If cometd connection is restricted due to CORS. Ensure the following is configured in gms launcher.xml 

```xml

 <parameter name="cometdSameSite" displayName="Cometd Browser Ccookie SameSite"  mandatory="true" hidden="true" readOnly="true">
	<description><[Add the SameSite attribute to the cookie. Default is None.]></description>
	<valid-description>< ></valid-description>
	<effective-description/>
	<format type="string" default="-Dcometd.browser.cookie.SameSite=lax" />
	<validation></validation>
  </parameter>
  <parameter name="cometdSecure" displayName="Cometd Browser Cookie Secure"  mandatory="true" hidden="true" readOnly="true">
	<description><Add the Secure attribute to the cookie. Default is false.></description>
	<valid-description><></valid-description>
	<effective-description/>
	<format type="string" default="-Dcometd.browser.cookie.Secure=false" />
	<validation></validation>
  </parameter>
  <parameter name="cometdHttpOnly" displayName="Cometd Browser Cookie HTTP Only"  mandatory="true" hidden="true" readOnly="true">
	<description><Add the HttpOnly attribute to the cookie. Default is true.></description>
	<valid-description><]></valid-description>
	<effective-description/>
	<format type="string" default="-Dcometd.browser.cookie.HttpOnly=false" />
	<validation></validation>
  </parameter>
 ```
 
  Also in nginx configuration configure the following and restart nginx
  
  ```
  location /genesys/cometd {
    include websockets.conf;
    
    add_header Access-Control-Allow-Origin  "http://demosrv.genesyslab.com:8080";
    add_header Access-Control-Allow-Methods "GET,POST,OPTIONS,DELETE,PUT,HEAD"; 
    add_header Access-Control-Allow-Headers "origin, content-type, accept, authorization,Access-Control-Request-Method, gms_user,GMS-User"; 
    add_header Access-Control-Allow-Credentials true;
    add_header Access-Control-Max-Age 1728000;

    proxy_pass http://http_gme_cluster/genesys/cometd;
	}
```
