/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.openmedia.protocol;

import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.collections.processor.KeyValuePrinter;
import com.genesyslab.platform.commons.connection.configuration.ConnectionConfiguration;
import com.genesyslab.platform.commons.protocol.ClientChannel;
import com.genesyslab.platform.commons.protocol.DuplexChannel;
import com.genesyslab.platform.commons.protocol.Endpoint;
import com.genesyslab.platform.commons.protocol.IntReferenceBuilder;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.ProtocolDescription;
import com.genesyslab.platform.commons.protocol.ProtocolFactory;
import com.genesyslab.platform.commons.protocol.ReferenceBuilder;
import com.genesyslab.platform.commons.protocol.runtime.codec.TKVCodec;
import com.genesyslab.platform.openmedia.protocol.externalservice.ExternalServiceProtocolFactory;
import com.genesyslab.platform.openmedia.protocol.externalservice.RequestorInfo;
import com.genesyslab.platform.openmedia.protocol.externalservice.RequestorInfoSupport;
import com.genesyslab.platform.openmedia.protocol.externalservice.runtime.ExternalServiceInternalProtocolFactory;

@ProtocolDescription.Tag(sdkName="OpenMedia", protocolName="ExternalService")
public class ExternalServiceProtocol
extends ClientChannel
implements RequestorInfoSupport {
    public static final ProtocolDescription PROTOCOL_DESCRIPTION = ExternalServiceProtocolFactory.PROTOCOL_DESCRIPTION;
    private ESProtoData protocolData;
    private RequestorInfo requestorInfo;
    protected static final String USE_UTF_FOR_REQUESTS = "UTF_STRING";

    public ExternalServiceProtocol() {
        this(null);
    }

    public ExternalServiceProtocol(Endpoint endpoint) {
        this(endpoint, null);
    }

    public ExternalServiceProtocol(Endpoint endpoint, ReferenceBuilder refBuilder) {
        super(endpoint, (ProtocolFactory)new ExternalServiceInternalProtocolFactory(), (ReferenceBuilder)(refBuilder != null ? refBuilder : new IntReferenceBuilder()));
    }

    public void setTKVPrinter(KeyValuePrinter printer) {
        if (this.protocolData == null) {
            this.protocolData = new ESProtoData();
        }
        this.protocolData.setPrinter(printer);
        this.setProtocolData(this.protocolData);
    }

    public KeyValuePrinter getTKVPrinter() {
        if (this.protocolData == null) {
            return null;
        }
        return this.protocolData.getPrinter();
    }

    @Override
    public RequestorInfo getRequestorInfo() {
        return this.requestorInfo;
    }

    @Override
    public void setRequestorInfo(RequestorInfo requestorInfo) {
        this.requestorInfo = requestorInfo;
    }

    private static boolean useUftForRequests(DuplexChannel protocol) {
        ConnectionConfiguration config;
        Endpoint endpoint;
        boolean useUtfFor = true;
        if (protocol != null && (endpoint = protocol.getEndpoint()) != null && (config = endpoint.getConfiguration()) != null) {
            useUtfFor = config.getBoolean(USE_UTF_FOR_REQUESTS, true);
        }
        return useUtfFor;
    }

    protected static void toEspRequestorInfo(Message message, DuplexChannel protocol, KeyValueCollection kvList) {
        if (kvList == null) {
            return;
        }
        RequestorInfo requestorInfo = null;
        if (message instanceof RequestorInfoSupport) {
            requestorInfo = ((RequestorInfoSupport)message).getRequestorInfo();
        }
        if (requestorInfo == null && protocol instanceof RequestorInfoSupport) {
            requestorInfo = ((RequestorInfoSupport)protocol).getRequestorInfo();
        }
        if (requestorInfo != null) {
            kvList.addList("RequestorInfo", requestorInfo.toKeyValueCollection(ExternalServiceProtocol.useUftForRequests(protocol)));
        }
    }

    protected static void fromEspRequestorInfo(KeyValueCollection kvList, Message message) {
        if (kvList == null) {
            return;
        }
        KeyValueCollection requestor = kvList.getList("RequestorInfo");
        if (requestor != null && message instanceof RequestorInfoSupport) {
            RequestorInfo info = RequestorInfo.create(requestor);
            ((RequestorInfoSupport)message).setRequestorInfo(info);
        }
    }

    private static class ESProtoData
    implements TKVCodec.PrinterStorage {
        private KeyValuePrinter printer;

        private ESProtoData() {
        }

        public KeyValuePrinter getPrinter() {
            return this.printer;
        }

        public void setPrinter(KeyValuePrinter kvPrinter) {
            this.printer = kvPrinter;
        }
    }
}

