/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.openmedia.protocol;

import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.connection.ConnectionClosedEvent;
import com.genesyslab.platform.commons.protocol.ClientChannel;
import com.genesyslab.platform.commons.protocol.Endpoint;
import com.genesyslab.platform.commons.protocol.IntReferenceBuilder;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.ProtocolDescription;
import com.genesyslab.platform.commons.protocol.ProtocolException;
import com.genesyslab.platform.commons.protocol.ProtocolFactory;
import com.genesyslab.platform.commons.protocol.ReferenceBuilder;
import com.genesyslab.platform.commons.protocol.RegistrationException;
import com.genesyslab.platform.openmedia.protocol.InteractionServerContext;
import com.genesyslab.platform.openmedia.protocol.InteractionServerProtocolHandshakeOptions;
import com.genesyslab.platform.openmedia.protocol.interactionserver.InteractionClient;
import com.genesyslab.platform.openmedia.protocol.interactionserver.InteractionServerProtocolFactory;
import com.genesyslab.platform.openmedia.protocol.interactionserver.events.EventAck;
import com.genesyslab.platform.openmedia.protocol.interactionserver.events.EventError;
import com.genesyslab.platform.openmedia.protocol.interactionserver.requests.RequestRegisterClient;
import com.genesyslab.platform.openmedia.protocol.interactionserver.runtime.InteractionServerInternalProtocolFactory;

@ProtocolDescription.Tag(sdkName="OpenMedia", protocolName="InteractionServer")
public class InteractionServerProtocol
extends ClientChannel
implements InteractionServerProtocolHandshakeOptions {
    public static final ProtocolDescription PROTOCOL_DESCRIPTION = InteractionServerProtocolFactory.PROTOCOL_DESCRIPTION;
    private InteractionClient clientType = InteractionClient.Unknown;
    private Integer proxyId;
    private String clientName = "";
    private String mediaType = "";
    private KeyValueCollection registrationExtensions;

    public InteractionServerProtocol(Endpoint endpoint, long timeout) {
        super(endpoint, (ProtocolFactory)new InteractionServerInternalProtocolFactory(), (ReferenceBuilder)new IntReferenceBuilder(), timeout);
        this.connectionContext().setAttribute("protocol-server-type", (Object)"InteractionServer");
    }

    public InteractionServerProtocol(Endpoint endpoint) {
        this(endpoint, 30000L);
    }

    public InteractionServerProtocol() {
        this(null, 30000L);
    }

    public Integer createReference() {
        return (Integer)this.getReferenceBuilder().createReference();
    }

    @Override
    public InteractionClient getClientType() {
        return this.clientType;
    }

    @Override
    public void setClientType(InteractionClient typeOfClient) {
        this.clientType = typeOfClient;
    }

    @Override
    public String getClientName() {
        return this.clientName;
    }

    @Override
    public void setClientName(String nameOfClient) {
        this.clientName = nameOfClient;
    }

    @Override
    public String getMediaType() {
        return this.mediaType;
    }

    @Override
    public void setMediaType(String value) {
        this.mediaType = value;
    }

    @Override
    public Integer getProxyId() {
        return this.proxyId;
    }

    @Override
    public void setProxyId(Integer idOfProxy) {
        this.proxyId = idOfProxy;
    }

    @Override
    public KeyValueCollection getRegistrationExtensions() {
        return this.registrationExtensions;
    }

    @Override
    public void setRegistrationExtensions(KeyValueCollection registrationExt) {
        this.registrationExtensions = registrationExt;
    }

    public InteractionServerContext getServerContext() {
        return (InteractionServerContext)super.getServerContext();
    }

    protected void onOpen() throws ProtocolException {
        this.setHandshakePhase((ClientChannel.ClientHandshakeStep)new InteractionServerHandshakeStep());
        super.onOpen();
    }

    protected void onClose(ConnectionClosedEvent event) {
        this.setServerContext(null);
        super.onClose(event);
    }

    private class InteractionServerHandshakeStep
    extends ClientChannel.BasicClientHandshakeStep {
        private InteractionServerHandshakeStep() {
            super((ClientChannel)InteractionServerProtocol.this);
        }

        public Message getRegistrationRequest() {
            RequestRegisterClient requestMessage = RequestRegisterClient.create(InteractionServerProtocol.this.clientType, InteractionServerProtocol.this.clientName);
            if (InteractionServerProtocol.this.clientType == InteractionClient.Proxy) {
                requestMessage.setProxyClientId(InteractionServerProtocol.this.proxyId);
            } else if (InteractionServerProtocol.this.clientType == InteractionClient.MediaServer) {
                requestMessage.setMediaType(InteractionServerProtocol.this.mediaType);
            }
            if (InteractionServerProtocol.this.registrationExtensions != null) {
                requestMessage.setExtension(InteractionServerProtocol.this.registrationExtensions);
            }
            return requestMessage;
        }

        public ClientChannel.ClientHandshakeStep handleMessage(Message event) throws ProtocolException {
            if (!this.checkReferenceId(event)) {
                return this.passEventThrough(event);
            }
            if (event.messageId() == 125) {
                EventAck ack = (EventAck)event;
                Integer proxyClientId = ack.getProxyClientId();
                KeyValueCollection registrationExt = ack.getExtension();
                InteractionServerProtocol.this.setServerContext(new InteractionServerContext(proxyClientId, registrationExt));
                if (this.log.isDebug()) {
                    this.log.debugFormat("Channel {0} is registered, proxy id = {1}", (Object)new Object[]{InteractionServerProtocol.this, proxyClientId});
                }
                return this.gotoNextStep();
            }
            if (event.messageId() == 126) {
                EventError err = (EventError)event;
                throw new RegistrationException(InteractionServerProtocol.this.getEnpointPrefixInfo() + "Error registering. Code: " + err.getErrorCode() + "; " + err.getErrorDescription(), (Message)err);
            }
            throw new RegistrationException("Unexpected message registering client", event);
        }
    }
}

