/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.openmedia.protocol.externalservice;

import com.genesyslab.platform.commons.PsdkCustomization;
import com.genesyslab.platform.commons.protocol.AbstractProtocolFactory;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.ProtocolDescription;
import com.genesyslab.platform.commons.protocol.runtime.AttributeDescription;
import com.genesyslab.platform.commons.protocol.runtime.MetaData;
import com.genesyslab.platform.commons.protocol.runtime.ProtocolUnknownMessage;
import com.genesyslab.platform.openmedia.protocol.externalservice.ExternalServiceMessage;
import com.genesyslab.platform.openmedia.protocol.externalservice.event.Event3rdServerFault;
import com.genesyslab.platform.openmedia.protocol.externalservice.event.Event3rdServerResponse;
import com.genesyslab.platform.openmedia.protocol.externalservice.request.Request3rdServer;
import java.util.HashMap;

public class ExternalServiceProtocolFactory
extends AbstractProtocolFactory {
    public static final ProtocolDescription PROTOCOL_DESCRIPTION = new ProtocolDescription("OpenMedia", "ExternalService");
    private static String referenceAttributeName = null;
    private static final MetaData defaultMessageAttributesInfo;
    public boolean enableProtocolUnknownMessageDelivery = PsdkCustomization.getBoolOption((PsdkCustomization.PsdkOption)PsdkCustomization.PsdkOption.DisableUnknownProtocolMessageDelivery, (String)PROTOCOL_DESCRIPTION.toString(), (Boolean)Boolean.FALSE) == false;
    private static final HashMap<String, Class<? extends Message>> CLASSES;

    public ProtocolDescription getProtocolDescription() {
        return PROTOCOL_DESCRIPTION;
    }

    public String getProtocolVersion() {
        return "7.6.000";
    }

    protected Message createRequest(int id) {
        switch (id) {
            case 500: {
                return Request3rdServer.create();
            }
        }
        return null;
    }

    protected Message createEvent(int id) {
        switch (id) {
            case 501: {
                return Event3rdServerResponse.create();
            }
            case 502: {
                return Event3rdServerFault.create();
            }
        }
        return null;
    }

    protected String getEventMessageName(int id) {
        switch (id) {
            case 501: {
                return "Event3rdServerResponse";
            }
            case 502: {
                return "Event3rdServerFault";
            }
        }
        return "";
    }

    protected String getRequestMessageName(int id) {
        switch (id) {
            case 500: {
                return "Request3rdServer";
            }
        }
        return "";
    }

    public Class<? extends Message> getMessageClass(String messageName) {
        return CLASSES.get(messageName);
    }

    public String getMessageName(int id) {
        String name = this.getEventMessageName(id);
        if (name != null && name.length() > 0) {
            return name;
        }
        name = this.getRequestMessageName(id);
        if (name == null || name.length() == 0) {
            if (this.enableProtocolUnknownMessageDelivery) {
                return "ProtocolUnknownMessage";
            }
            throw new IllegalArgumentException("Protocol doesn't support message #" + id);
        }
        return name;
    }

    public Message createMessage(int id) {
        Message message = this.createEvent(id);
        if (message != null) {
            return message;
        }
        message = this.createRequest(id);
        if (message != null) {
            return message;
        }
        return this.unknownProtocolMessage(id);
    }

    public Message createMessage(int id, String name) {
        if (name == null || name.length() == 0) {
            return this.createMessage(id);
        }
        Message message = name.startsWith("Event") ? this.createEvent(id) : this.createRequest(id);
        if (message != null) {
            return message;
        }
        return this.unknownProtocolMessage(id);
    }

    public Message unknownProtocolMessage(int messageId) {
        if (this.enableProtocolUnknownMessageDelivery) {
            return new ProtocolUnknownMessageAccessor.ExternalServiceUnknownMessage(messageId);
        }
        throw new IllegalArgumentException("Protocol doesn't support message #" + messageId);
    }

    public String getReferenceAttributeName() {
        return referenceAttributeName;
    }

    static {
        HashMap<String, AttributeDescription> attributesInfo = new HashMap<String, AttributeDescription>();
        AttributeDescription propKey = new AttributeDescription("0", "ReferenceId", Integer.class, null, null, false, false);
        attributesInfo.put("0", propKey);
        attributesInfo.put("ReferenceId", propKey);
        referenceAttributeName = "ReferenceId";
        defaultMessageAttributesInfo = new MetaData("*", "ProtocolUnknownMessage", null, attributesInfo, null);
        CLASSES = new HashMap();
        CLASSES.put("Request3rdServer", Request3rdServer.class);
        CLASSES.put("Event3rdServerResponse", Event3rdServerResponse.class);
        CLASSES.put("Event3rdServerFault", Event3rdServerFault.class);
    }

    private static abstract class ProtocolUnknownMessageAccessor
    extends ProtocolUnknownMessage {
        private ProtocolUnknownMessageAccessor() {
        }

        static class ExternalServiceUnknownMessage
        extends ProtocolUnknownMessage.ProtocolUnknownMessageDataRef
        implements ExternalServiceMessage {
            ExternalServiceUnknownMessage(int messageId) {
                super(PROTOCOL_DESCRIPTION, messageId, defaultMessageAttributesInfo, referenceAttributeName);
            }
        }
    }
}

