/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.openmedia.protocol.openmediaattributes;

import com.genesyslab.platform.commons.DateTimeParseException;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public final class Converter {
    private static ILogger log = Log.getLogger(Converter.class);
    private static final Integer ZERO = new Integer(0);
    private static final Integer ONE = new Integer(1);
    private static final String DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final TimeZone UTC_TIMEZONE = TimeZone.getTimeZone("UTC");
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    private Converter() {
    }

    public static Boolean toBoolean(Integer intBool) {
        if (intBool == null) {
            return null;
        }
        if (ONE.equals(intBool)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Integer toInteger(Boolean bool) {
        if (bool == null) {
            return null;
        }
        if (Boolean.TRUE.equals(bool)) {
            return ONE;
        }
        return ZERO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date toDate(String dateStr) {
        if (dateStr == null) {
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = DATE_FORMAT;
            synchronized (simpleDateFormat) {
                return DATE_FORMAT.parse(dateStr);
            }
        }
        catch (ParseException e) {
            throw new DateTimeParseException("Exception parsing DateTime field", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Date date) {
        if (date != null) {
            SimpleDateFormat simpleDateFormat = DATE_FORMAT;
            synchronized (simpleDateFormat) {
                return DATE_FORMAT.format(date);
            }
        }
        return null;
    }

    static {
        DATE_FORMAT.setTimeZone(UTC_TIMEZONE);
    }
}

