/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection;

import com.genesyslab.platform.commons.connection.configuration.ConnectionContext;
import java.util.HashMap;
import java.util.Map;

public class AttributeSubscriptionList {
    public static final String SUBSCRIPTION_LIST_KEY = "attribute_subscription_list";
    private Map<Integer, Map<String, AttributeSubscriptionType>> subscriptions = new HashMap<Integer, Map<String, AttributeSubscriptionType>>();

    public void applyToContext(ConnectionContext ctx) {
        ctx.setAttribute(SUBSCRIPTION_LIST_KEY, this);
    }

    @Deprecated
    public boolean contains(int messageId, String attrId) {
        return this.subscriptions.containsKey(messageId) && this.subscriptions.get(messageId).containsKey(attrId);
    }

    public Map<String, AttributeSubscriptionType> getMessageSubscriptions(int messageId) {
        return this.subscriptions.get(messageId);
    }

    public void addAttribute(int messageId, String attributeId) {
        this.addAttribute(messageId, attributeId, AttributeSubscriptionType.Unpacked);
    }

    public void addAttribute(int messageId, String attributeId, AttributeSubscriptionType type) {
        Map<String, AttributeSubscriptionType> messageSubscriptions = this.subscriptions.get(messageId);
        if (messageSubscriptions == null) {
            messageSubscriptions = new HashMap<String, AttributeSubscriptionType>();
            this.subscriptions.put(messageId, messageSubscriptions);
        }
        if (type != null) {
            messageSubscriptions.put(attributeId, type);
        } else {
            messageSubscriptions.remove(attributeId);
        }
    }

    public boolean removeAttribute(int messageId, String attrId) {
        Map<String, AttributeSubscriptionType> messageSubscriptions = this.subscriptions.get(messageId);
        if (messageSubscriptions != null) {
            AttributeSubscriptionType prev = messageSubscriptions.remove(attrId);
            if (messageSubscriptions.isEmpty()) {
                this.subscriptions.remove(messageId);
            }
            return prev != null;
        }
        return false;
    }

    public boolean removeWholeMessage(int messageId) {
        return this.subscriptions.remove(messageId) != null;
    }

    @Deprecated
    public static boolean attributeSubscribed(ConnectionContext context, int msgId, String attrId) {
        Object subscriptions = context.getAttribute(SUBSCRIPTION_LIST_KEY);
        return subscriptions instanceof AttributeSubscriptionList && ((AttributeSubscriptionList)subscriptions).contains(msgId, attrId);
    }

    public static enum AttributeSubscriptionType {
        Raw,
        Unpacked;

    }
}

