/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection;

import com.genesyslab.platform.commons.connection.Connection;
import java.util.EventObject;

public class ConnectionClosedEvent
extends EventObject {
    private Throwable cause;
    private long unsentBytes;

    public ConnectionClosedEvent(Object source, Throwable cause) {
        super(source);
        this.cause = cause;
        if (source instanceof Connection) {
            this.unsentBytes = ((Connection)source).getUnsetBytes();
        }
    }

    public ConnectionClosedEvent(ConnectionClosedEvent event, Throwable cause) {
        super(event.getSource());
        this.cause = cause;
        this.unsentBytes = event.getUnsentBytes();
    }

    public ConnectionClosedEvent(Object source, Throwable cause, Connection con) {
        super(source);
        this.cause = cause;
        if (con != null) {
            this.unsentBytes = con.getUnsetBytes();
        }
    }

    public Throwable getCause() {
        return this.cause;
    }

    public boolean hasUnsentBytes() {
        return this.unsentBytes > 0L;
    }

    public long getUnsentBytes() {
        return this.unsentBytes;
    }

    @Override
    public String toString() {
        return super.toString() + (this.getCause() != null ? "; cause: " + this.getCause() : "");
    }
}

