/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.configuration;

import com.genesyslab.platform.commons.connection.configuration.ClientADDPOptions;
import com.genesyslab.platform.commons.connection.configuration.ClientConnectionOptions;
import com.genesyslab.platform.commons.connection.configuration.ConnectionConfiguration;

public abstract class AbstractConnectionConfiguration
implements ClientConnectionOptions,
ConnectionConfiguration {
    @Override
    public String getOption(String name) {
        return this.getOption(name, null);
    }

    @Override
    public boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    @Override
    public boolean getBoolean(String name, boolean defaultValue) {
        String val = this.getOption(name);
        if (val != null) {
            if ("true".equalsIgnoreCase(val) || "yes".equalsIgnoreCase(val) || "on".equalsIgnoreCase(val) || "1".equalsIgnoreCase(val)) {
                return true;
            }
            if ("false".equalsIgnoreCase(val) || "no".equalsIgnoreCase(val) || "off".equalsIgnoreCase(val) || "0".equalsIgnoreCase(val)) {
                return false;
            }
        }
        return defaultValue;
    }

    @Override
    public Integer getInteger(String name) {
        return this.getInteger(name, null);
    }

    @Override
    public Integer getInteger(String name, Integer defaultValue) {
        String val = this.getOption(name);
        if (val != null) {
            try {
                return new Integer(val);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Override
    public void setBoolean(String name, boolean value) {
        this.setOption(name, String.valueOf(value));
    }

    @Override
    public void setInteger(String name, Integer value) {
        this.setOption(name, String.valueOf(value));
    }

    @Override
    public ConnectionConfiguration clone() throws CloneNotSupportedException {
        return (ConnectionConfiguration)super.clone();
    }

    @Override
    public void setStringsEncoding(String stringsEncoding) {
        this.setOption("string-attributes-encoding", stringsEncoding);
    }

    @Override
    public String getStringsEncoding() {
        return this.getOption("string-attributes-encoding");
    }

    @Override
    public void setLocalBindingHost(String localBindingHost) {
        if (localBindingHost != null && localBindingHost.length() > 0) {
            this.setOption("transport-address", localBindingHost);
        } else {
            this.setOption("transport-address", null);
        }
    }

    @Override
    public String getLocalBindingHost() {
        return this.getOption("transport-address");
    }

    @Override
    public void setLocalBindingPort(Integer localBindingPort) {
        if (localBindingPort != null) {
            if (localBindingPort < 0 || localBindingPort > 65535) {
                throw new IllegalArgumentException("LocalBindingPort is out of range (0..65535)");
            }
            this.setInteger("transport-port", localBindingPort);
        } else {
            this.setOption("transport-port", null);
        }
    }

    @Override
    public Integer getLocalBindingPort() {
        return this.getInteger("transport-port");
    }

    @Override
    public void setIPv6Enabled(boolean enableIPv6) {
        this.setBoolean("enable-ipv6", enableIPv6);
    }

    @Override
    public boolean isIPv6Enabled() {
        return this.getBoolean("enable-ipv6");
    }

    @Override
    public void setIPVersion(String ipVersion) {
        if (ipVersion != null && !ipVersion.equals("4,6") && !ipVersion.equals("6,4")) {
            throw new IllegalArgumentException("Valid values for IPVersion are: '4,6' or '6,4'");
        }
        this.setOption("ip-version", ipVersion);
    }

    @Override
    public String getIPVersion() {
        return this.getOption("ip-version");
    }

    @Override
    public void setUseAddp(boolean useAddp) {
        this.setOption("protocol", useAddp ? "addp" : null);
    }

    @Override
    public boolean isUseAddp() {
        String protoName = this.getOption("protocol");
        return protoName != null && protoName.equalsIgnoreCase("addp");
    }

    @Override
    public void setAddpClientTimeout(Integer timeout) {
        String addpClientTimeout = null;
        if (timeout != null) {
            addpClientTimeout = String.valueOf(timeout);
        }
        this.setOption("addp-timeout", addpClientTimeout);
    }

    @Override
    public Integer getAddpClientTimeout() {
        return this.getInteger("addp-timeout");
    }

    @Override
    public void setAddpServerTimeout(Integer timeout) {
        String addpServerTimeout = null;
        if (timeout != null) {
            addpServerTimeout = String.valueOf(timeout);
        }
        this.setOption("addp-remote-timeout", addpServerTimeout);
    }

    @Override
    public Integer getAddpServerTimeout() {
        return this.getInteger("addp-remote-timeout");
    }

    @Override
    @Deprecated
    public void setAddpTrace(String traceMode) {
        this.setOption("addp-trace", traceMode);
    }

    @Override
    @Deprecated
    public String getAddpTrace() {
        return this.getOption("addp-trace");
    }

    @Override
    public void setAddpTraceMode(ClientADDPOptions.AddpTraceMode traceMode) {
        this.setOption("addp-trace", traceMode != null ? traceMode.toString() : null);
    }

    @Override
    public ClientADDPOptions.AddpTraceMode getAddpTraceMode() {
        String strTrace = this.getOption("addp-trace");
        if (strTrace != null) {
            return ClientADDPOptions.AddpTraceMode.parse(strTrace);
        }
        return null;
    }

    @Override
    public void setTLSEnabled(boolean enabled) {
        this.setBoolean("tls", enabled);
    }

    @Override
    public boolean isTLSEnabled() {
        return this.getBoolean("tls", false);
    }

    @Deprecated
    public String getTLSVersion() {
        return this.getOption("tls-version");
    }

    @Deprecated
    public void setTLSVersion(String tlsVersion) {
        this.setOption("tls-version", tlsVersion);
    }

    public Integer getBacklog() {
        return this.getInteger("backlog");
    }

    public void setBacklog(Integer backlog) {
        this.setInteger("backlog", backlog);
    }
}

