/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.configuration;

import com.genesyslab.platform.commons.connection.configuration.AbstractConnectionConfiguration;
import com.genesyslab.platform.commons.connection.configuration.ConnectionConfiguration;
import com.genesyslab.platform.commons.connection.configuration.PropertyConfiguration;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.NullLoggerImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public final class ManagedConfiguration
extends AbstractConnectionConfiguration {
    private static ILogger logger = NullLoggerImpl.SINGLETON;
    private ConnectionConfiguration configuration;
    private final HashMap<String, PropertyChangeHandlers> propertyChangeHandlers = new HashMap();

    public ManagedConfiguration(ConnectionConfiguration configuration) {
        this.setConfiguration(configuration);
    }

    public ConnectionConfiguration getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfiguration(ConnectionConfiguration configuration) {
        HashMap<String, PropertyChangeHandlers> hashMap = this.propertyChangeHandlers;
        synchronized (hashMap) {
            ConnectionConfiguration cfgOld = this.configuration;
            if (cfgOld == configuration) {
                return;
            }
            if (configuration instanceof ManagedConfiguration) {
                configuration = ((ManagedConfiguration)configuration).getConfiguration();
            }
            if (configuration != null) {
                ConnectionConfiguration cfgNew;
                try {
                    this.configuration = cfgNew = configuration.clone();
                }
                catch (CloneNotSupportedException e) {
                    this.configuration = cfgNew = configuration;
                }
                for (Map.Entry<String, PropertyChangeHandlers> e : this.propertyChangeHandlers.entrySet()) {
                    String valueNew;
                    String valueOld;
                    String key = e.getKey();
                    ChangeEvent changeEvent = ChangeEvent.createIfChanged(key, valueOld = cfgOld != null ? cfgOld.getOption(key) : null, valueNew = cfgNew != null ? cfgNew.getOption(key) : null);
                    if (changeEvent == null) continue;
                    if (!this.IsAcceptedChange(changeEvent)) {
                        if (cfgNew == null) continue;
                        cfgNew.setOption(key, valueOld);
                        continue;
                    }
                    this.notifyAfterPropertyChanged(changeEvent);
                }
            } else {
                this.configuration = new PropertyConfiguration();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBeforePropertyChangeHandler(String propertyKey, Handler handler) {
        HashMap<String, PropertyChangeHandlers> hashMap = this.propertyChangeHandlers;
        synchronized (hashMap) {
            Handlers handlers;
            PropertyChangeHandlers keyHandlers = this.propertyChangeHandlers.get(propertyKey);
            if (keyHandlers == null) {
                keyHandlers = new PropertyChangeHandlers();
                this.propertyChangeHandlers.put(propertyKey, keyHandlers);
            }
            if ((handlers = keyHandlers.beforePropertyChangeHandlers) == null) {
                handlers = new Handlers();
                keyHandlers.beforePropertyChangeHandlers = handlers;
            }
            handlers.addListener(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBeforePropertyChangeHandler(String propertyKey, Handler handler) {
        HashMap<String, PropertyChangeHandlers> hashMap = this.propertyChangeHandlers;
        synchronized (hashMap) {
            Handlers handlers;
            PropertyChangeHandlers keyHandlers = this.propertyChangeHandlers.get(propertyKey);
            if (keyHandlers != null && (handlers = keyHandlers.beforePropertyChangeHandlers) != null) {
                handlers.removeListener(handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAfterPropertyChangeHandler(String propertyKey, Handler handler) {
        HashMap<String, PropertyChangeHandlers> hashMap = this.propertyChangeHandlers;
        synchronized (hashMap) {
            Handlers handlers;
            PropertyChangeHandlers keyHandlers = this.propertyChangeHandlers.get(propertyKey);
            if (keyHandlers == null) {
                keyHandlers = new PropertyChangeHandlers();
                this.propertyChangeHandlers.put(propertyKey, keyHandlers);
            }
            if ((handlers = keyHandlers.afterPropertyChangeHandlers) == null) {
                handlers = new Handlers();
                keyHandlers.afterPropertyChangeHandlers = handlers;
            }
            handlers.addListener(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAfterPropertyChangeHandler(String propertyKey, Handler handler) {
        HashMap<String, PropertyChangeHandlers> hashMap = this.propertyChangeHandlers;
        synchronized (hashMap) {
            Handlers handlers;
            PropertyChangeHandlers keyHandlers = this.propertyChangeHandlers.get(propertyKey);
            if (keyHandlers != null && (handlers = keyHandlers.afterPropertyChangeHandlers) != null) {
                handlers.removeListener(handler);
            }
        }
    }

    @Override
    public String getOption(String name, String defaultValue) {
        return this.configuration.getOption(name, defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOption(String name, String value) {
        HashMap<String, PropertyChangeHandlers> hashMap = this.propertyChangeHandlers;
        synchronized (hashMap) {
            ChangeEvent changeEvent = ChangeEvent.createIfChanged(name, this.configuration.getOption(name), value);
            if (changeEvent != null && this.IsAcceptedChange(changeEvent)) {
                this.configuration.setOption(name, value);
                this.notifyAfterPropertyChanged(changeEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean IsAcceptedChange(ChangeEvent changeEvent) {
        PropertyChangeHandlers keyHandlers;
        if (changeEvent == null) {
            return false;
        }
        HashMap<String, PropertyChangeHandlers> hashMap = this.propertyChangeHandlers;
        synchronized (hashMap) {
            keyHandlers = this.propertyChangeHandlers.get(changeEvent.getKey());
            if (keyHandlers == null) {
                keyHandlers = this.propertyChangeHandlers.get(null);
            }
        }
        if (keyHandlers == null) {
            return true;
        }
        Handlers handlers = keyHandlers.beforePropertyChangeHandlers;
        if (handlers == null) {
            return true;
        }
        handlers.invokeAll(this, changeEvent);
        return changeEvent.isAccepted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAfterPropertyChanged(ChangeEvent changeEvent) {
        PropertyChangeHandlers keyHandlers;
        if (changeEvent == null) {
            return;
        }
        HashMap<String, PropertyChangeHandlers> hashMap = this.propertyChangeHandlers;
        synchronized (hashMap) {
            keyHandlers = this.propertyChangeHandlers.get(changeEvent.getKey());
            if (keyHandlers == null) {
                keyHandlers = this.propertyChangeHandlers.get(null);
            }
        }
        if (keyHandlers == null) {
            return;
        }
        Handlers handlers = keyHandlers.afterPropertyChangeHandlers;
        if (handlers == null) {
            return;
        }
        handlers.invokeAll(this, changeEvent);
    }

    @Override
    public ConnectionConfiguration clone() throws CloneNotSupportedException {
        ManagedConfiguration cfg = (ManagedConfiguration)super.clone();
        cfg.configuration = this.configuration.clone();
        return cfg;
    }

    public static void enableLogging(ILogger logger) {
        ManagedConfiguration.logger = logger != null ? logger : NullLoggerImpl.SINGLETON;
    }

    public static ILogger getLogger() {
        return logger;
    }

    public int hashCode() {
        ConnectionConfiguration configuration = this.configuration;
        return configuration != null ? configuration.hashCode() : super.hashCode();
    }

    public boolean equals(Object obj) {
        ConnectionConfiguration configuration = this.configuration;
        return configuration != null ? configuration.equals(obj) : super.equals(obj);
    }

    public String toString() {
        ConnectionConfiguration configuration = this.configuration;
        return configuration != null ? configuration.toString() : super.toString();
    }

    private static class Handlers {
        private Vector<Handler> handlers = new Vector();

        private Handlers() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void invokeAll(ManagedConfiguration sender, ChangeEvent change) {
            Vector<Handler> vector = this.handlers;
            synchronized (vector) {
                for (Handler handler : this.handlers) {
                    try {
                        handler.onPropertyChanged(sender, change);
                    }
                    catch (Throwable e) {
                        ManagedConfiguration.getLogger().errorFormat("ManagedConfiguration.Handler (Key=[{0}], OldValue=[{1}], NewValue=[{2}]) raised an exception", (Object)new Object[]{change.getKey(), change.getOldValue(), change.getNewValue(), e});
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addListener(Handler handler) {
            Vector<Handler> vector = this.handlers;
            synchronized (vector) {
                if (this.handlers.contains(handler)) {
                    return;
                }
                this.handlers.add(handler);
            }
        }

        void removeListener(Handler listener) {
            this.handlers.remove(listener);
        }
    }

    public static class ChangeEvent {
        private String Key;
        private String OldValue;
        private String NewValue;
        private boolean Accepted;

        private ChangeEvent(String key, String oldValue, String newValue) {
            this.Key = key;
            this.OldValue = oldValue;
            this.NewValue = newValue;
            this.Accepted = true;
        }

        public String getKey() {
            return this.Key;
        }

        public String getOldValue() {
            return this.OldValue;
        }

        public String getNewValue() {
            return this.NewValue;
        }

        public boolean isAccepted() {
            return this.Accepted;
        }

        public void decline() {
            this.Accepted = false;
        }

        public static ChangeEvent createIfChanged(String key, String oldValue, String newValue) {
            if (null == oldValue && null == newValue || oldValue != null && oldValue.equals(newValue)) {
                return null;
            }
            return new ChangeEvent(key, oldValue, newValue);
        }

        public String toString() {
            return "ChangeEvent[Key=" + this.Key + ";NewValue=" + this.NewValue + ";OldVlaue=" + this.OldValue + ";Accepted=" + this.Accepted + "]";
        }
    }

    public static interface Handler {
        public void onPropertyChanged(Object var1, ChangeEvent var2);
    }

    private static final class PropertyChangeHandlers {
        private Handlers beforePropertyChangeHandlers;
        private Handlers afterPropertyChangeHandlers;

        private PropertyChangeHandlers() {
        }
    }
}

