/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.configuration;

import com.genesyslab.platform.commons.connection.configuration.AbstractConnectionConfiguration;
import java.util.Properties;

public class PropertyConfiguration
extends AbstractConnectionConfiguration {
    private Properties props;

    public PropertyConfiguration() {
        this.props = new Properties();
    }

    public PropertyConfiguration(Properties props) {
        this.props = props != null ? (Properties)props.clone() : new Properties();
    }

    public PropertyConfiguration(String uriQueryString) {
        String[] pairs;
        if (null == uriQueryString) {
            throw new IllegalArgumentException("uriQueryString must not be null");
        }
        if (0 == uriQueryString.length()) {
            return;
        }
        this.props = new Properties();
        for (String pair : pairs = uriQueryString.split("&")) {
            int ind = pair.indexOf(61);
            if (ind >= 0) {
                String key = pair.substring(0, ind);
                String value = pair.substring(ind + 1);
                this.props.setProperty(key, value);
                continue;
            }
            this.props.setProperty(pair, "");
        }
    }

    @Override
    public void setOption(String name, String value) {
        if (value != null) {
            this.props.setProperty(name, value);
        } else {
            this.props.remove(name);
        }
    }

    @Override
    public String getOption(String name, String defaultValue) {
        return this.props.getProperty(name, defaultValue);
    }

    public boolean isEmpty() {
        return this.props.isEmpty();
    }

    @Override
    public PropertyConfiguration clone() {
        return new PropertyConfiguration(this.props);
    }

    public String toString() {
        return this.props.toString();
    }
}

