/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.impl;

import com.genesyslab.platform.commons.PlatformException;
import com.genesyslab.platform.commons.connection.MessageStructureHandler;
import com.genesyslab.platform.commons.connection.MessageTransport;
import com.genesyslab.platform.commons.connection.PsdkConnectionException;
import com.genesyslab.platform.commons.connection.impl.BinaryStreamListening;
import com.genesyslab.platform.commons.connection.impl.CommonMessageProducerFactory;
import com.genesyslab.platform.commons.connection.impl.ConnectionImpl;
import com.genesyslab.platform.commons.connection.impl.EncodingSupport;
import com.genesyslab.platform.commons.connection.impl.InvalidPacketException;
import com.genesyslab.platform.commons.connection.impl.OutcomingBinaryMessageListener;
import com.genesyslab.platform.commons.connection.impl.PackedMessage;
import com.genesyslab.platform.commons.connection.impl.StreamParser;
import com.genesyslab.platform.commons.connection.impl.WritePipe;
import com.genesyslab.platform.commons.connection.impl.WritePoint;
import java.io.IOException;

public class CommonMessageTransportImpl
implements MessageTransport {
    private ConnectionImpl connImpl;
    private StreamParser streamParser;
    protected BinaryStreamListening binaryStreamListening;

    @Override
    public void setConnection(ConnectionImpl connection) {
        this.connImpl = connection;
        this.streamParser = new StreamParser(connection, new CommonMessageProducerFactory(this.connImpl));
        this.binaryStreamListening = connection instanceof BinaryStreamListening ? (BinaryStreamListening)((Object)connection) : null;
    }

    @Override
    public void processData(byte[] b, int offset, int len) throws InvalidPacketException {
        if (this.streamParser == null) {
            throw new PsdkConnectionException("No connection in message transport");
        }
        this.streamParser.processBytes(b, offset, len);
    }

    @Override
    public Object onNewMessage(Object state, int messageId) {
        return new PackedMessage(messageId, this.getStringAttributesEncoding());
    }

    protected String getStringAttributesEncoding() {
        return this.connImpl != null ? this.connImpl.getStringAttributesEncoding() : EncodingSupport.DEFAULT_ENCODING;
    }

    @Override
    public Object onAttribute(Object state, String id, String value) throws PlatformException {
        PackedMessage message = (PackedMessage)state;
        this.packString(message, id, value);
        return message;
    }

    private void packSecureString(PackedMessage message, String id, MessageStructureHandler.StringBytes value) throws PlatformException {
        int mId = this.asIntId(id);
        message.addSecureStringAttrib(message, mId, value);
    }

    protected void packString(PackedMessage message, String id, String value) throws PlatformException {
        int mId = this.asIntId(id);
        message.addStringAttrib(mId, value);
    }

    @Override
    public Object onAttribute(Object state, String id, int value) throws PlatformException {
        PackedMessage message = (PackedMessage)state;
        this.packInt(message, id, value);
        return message;
    }

    protected void packInt(PackedMessage message, String id, int value) throws PlatformException {
        int mId = this.asIntId(id);
        message.addIntAttrib(mId, value);
    }

    @Override
    public Object onAttribute(Object state, String id, byte[] value) throws PlatformException {
        PackedMessage message = (PackedMessage)state;
        this.packBinary(message, id, value);
        return message;
    }

    @Override
    public Object onRawAttribute(Object state, String id, Object value) throws PlatformException {
        PackedMessage message = (PackedMessage)state;
        if (value instanceof byte[]) {
            this.packBinary(message, id, (byte[])value);
        } else if (value instanceof Integer) {
            this.packInt(message, id, (Integer)value);
        } else if (value instanceof Long) {
            this.packLong(message, id, (Long)value);
        } else if (value instanceof String) {
            this.packString(message, id, (String)value);
        } else if (value instanceof MessageStructureHandler.StringBytes) {
            this.packSecureString(message, id, (MessageStructureHandler.StringBytes)value);
        } else {
            throw new PlatformException("Unsupported raw attribute type: " + value.getClass());
        }
        return message;
    }

    protected void packBinary(PackedMessage message, String id, byte[] value) throws PlatformException {
        int mId = this.asIntId(id);
        if (value.length > 65533) {
            message.addBinaryAttrib(mId, value);
        } else {
            message.addBStringAttrib(mId, value);
        }
    }

    @Override
    public Object onAttribute(Object state, String id, long value) throws PlatformException {
        PackedMessage message = (PackedMessage)state;
        this.packLong(message, id, value);
        return message;
    }

    protected void packLong(PackedMessage message, String id, long value) throws PlatformException {
        int mId = this.asIntId(id);
        message.addLongAttrib(mId, value);
    }

    @Override
    public Object onMessageEnd(Object state) throws PlatformException {
        PackedMessage message = (PackedMessage)state;
        try {
            WritePoint writePoint;
            WritePipe pipe = this.connImpl.getWritePipe();
            if (pipe != null) {
                OutcomingBinaryMessageListener listener;
                writePoint = pipe.createWritePoint();
                message.writeTo(writePoint);
                BinaryStreamListening binaryStreamListening = this.binaryStreamListening;
                if (binaryStreamListening != null && (listener = binaryStreamListening.getOutcomingBinaryMessageListener()) != null) {
                    listener.onOutcomingBinaryMessage(message.getBuffer(), 4, message.getLen() - 4);
                }
            } else {
                throw new PsdkConnectionException("No WritePipe in connection");
            }
            pipe.write(writePoint);
        }
        catch (IOException e) {
            throw new PlatformException("io exception writing message", (Throwable)e);
        }
        return message;
    }

    protected ConnectionImpl getConnection() {
        return this.connImpl;
    }

    protected int asIntId(String id) throws PlatformException {
        try {
            return Integer.parseInt(id);
        }
        catch (NumberFormatException e) {
            throw new PlatformException("Common transport supports int attribute id only. id = " + id);
        }
    }
}

