/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.impl;

import com.genesyslab.platform.commons.PsdkCustomization;
import com.genesyslab.platform.commons.collections.util.Hex;
import com.genesyslab.platform.commons.connection.impl.BinaryStreamListening;
import com.genesyslab.platform.commons.connection.impl.CommonMessageProducerImpl;
import com.genesyslab.platform.commons.connection.impl.ConnectionImpl;
import com.genesyslab.platform.commons.connection.impl.Constants;
import com.genesyslab.platform.commons.connection.impl.IncomingBinaryMessageListener;
import com.genesyslab.platform.commons.connection.impl.InvalidPacketException;
import com.genesyslab.platform.commons.connection.impl.InvalidPacketSizeException;
import com.genesyslab.platform.commons.connection.impl.MessageProducer;
import com.genesyslab.platform.commons.connection.impl.MessageProducerFactory;
import com.genesyslab.platform.commons.connection.impl.ShiftByteArrayOutputStream;
import com.genesyslab.platform.commons.connection.interceptor.InterceptorImpl;
import com.genesyslab.platform.commons.connection.interceptor.NoInterceptorImpl;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import java.util.Arrays;

public class StreamParser {
    private static ILogger log = Log.getLogger(StreamParser.class);
    private static final InterceptorImpl defaultInterceptor = new NoInterceptorImpl();
    private ConnectionImpl connImpl;
    private MessageProducerFactory producerFactory;
    private InterceptorImpl interceptor;
    private ShiftByteArrayOutputStream bytes = new ShiftByteArrayOutputStream();
    private int extLength = 0;
    private ShiftByteArrayOutputStream extBytes = null;
    private final BinaryStreamListening binaryStreamListening;
    private final IncomingBinaryMessageListener incomingBinaryMessageListener;

    public StreamParser(ConnectionImpl connImpl, MessageProducerFactory producerFactory) {
        this.connImpl = connImpl;
        this.producerFactory = producerFactory;
        this.binaryStreamListening = connImpl instanceof BinaryStreamListening ? (BinaryStreamListening)((Object)connImpl) : null;
        this.incomingBinaryMessageListener = null;
    }

    public StreamParser(IncomingBinaryMessageListener listener, InterceptorImpl interceptor) {
        this.binaryStreamListening = null;
        this.incomingBinaryMessageListener = listener;
        this.interceptor = interceptor;
    }

    public void processBytes(byte[] buffer, int off, int len) throws InvalidPacketException {
        int size;
        int prevByteCount = this.bytes.size();
        this.bytes.write(buffer, off, len);
        while ((size = this.bytes.size()) > 0) {
            String optionValue;
            int packetLen = this.getPacketLen();
            if (packetLen < 0) {
                byte[] bytesArray = this.bytes.getBuffer();
                int parsedPacketLen = 0xFF000000 & bytesArray[0] << 24 | 0xFF0000 & bytesArray[1] << 16 | 0xFF00 & bytesArray[2] << 8 | 0xFF & bytesArray[3];
                throw new InvalidPacketSizeException("invalid packet : parsedLength=" + parsedPacketLen + "/0x" + Integer.toHexString(parsedPacketLen) + " remain=" + size + " prev=" + prevByteCount);
            }
            if (packetLen == 0 || packetLen > size) {
                return;
            }
            if (log.isDebug() && ((optionValue = PsdkCustomization.getOption((PsdkCustomization.PsdkOption)PsdkCustomization.PsdkOption.LogConnectionTraffic, null, (String)"")).equals("all") || optionValue.equals("in"))) {
                int cnt = packetLen;
                byte[] byteArray = this.bytes.toByteArray();
                StringBuilder sb = new StringBuilder(200 + byteArray.length * 4);
                sb.append("\n\nRECEIVED ");
                sb.append(cnt);
                sb.append(" bytes @");
                sb.append(Integer.toHexString(Arrays.hashCode(byteArray)));
                sb.append(" : ");
                sb.append(this.connImpl);
                sb.append(":\n");
                Hex.appendHexAndAscTable((StringBuilder)sb, (byte[])byteArray, (int)0, (int)packetLen, (String)"");
                sb.append("\n");
                log.debug((Object)sb.toString());
            }
            this.processPacket(packetLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPacket(int packetLen) throws InvalidPacketException {
        if (this.getInterceptor().processPacket(this.bytes, packetLen)) {
            return;
        }
        try {
            if (this.extLength > 0) {
                this.processExtendedPacket(packetLen);
            } else if (!this.checkProcessExtHeader(packetLen)) {
                byte[] b = this.bytes.getBuffer();
                IncomingBinaryMessageListener listener = this.incomingBinaryMessageListener;
                if (listener == null && this.binaryStreamListening != null) {
                    listener = this.binaryStreamListening.getIncomingBinaryMessageListener();
                }
                if (listener != null) {
                    listener.onIncomingBinaryMessage(b, 4, packetLen - 4);
                }
                if (this.producerFactory != null) {
                    MessageProducer producer = this.producerFactory.create(b, 4, packetLen - 4, this.connImpl.getConnection().getMessagePackager());
                    producer.parse();
                }
            }
        }
        finally {
            this.bytes.shiftBack(packetLen);
        }
    }

    private boolean checkProcessExtHeader(int packetLen) throws InvalidPacketException {
        byte[] buf;
        String sData;
        boolean isExtPacket = false;
        int dataLen = packetLen - 4;
        if (dataLen == Constants.EXTENDED_PACKET_TAG_LENGTH + 4 && (isExtPacket = (sData = new String(buf = this.bytes.getBuffer(), 4, dataLen - 4)).equals("$PACKET EXTENSION V1.00$"))) {
            if (this.extLength != 0) {
                throw new InvalidPacketSizeException("ExtHeader spotted while processing extended packets");
            }
            this.extLength = CommonMessageProducerImpl.getInt(buf, packetLen - 4);
            this.extBytes = new ShiftByteArrayOutputStream(this.extLength);
        }
        return isExtPacket;
    }

    private int getPacketLen() {
        byte[] currentBuf = this.bytes.getBuffer();
        int len = this.bytes.size();
        return this.getInterceptor().getPacketLength(currentBuf, 0, len);
    }

    private void processExtendedPacket(int packetLen) throws InvalidPacketException {
        int dataLen = packetLen - 4;
        byte[] bb = this.bytes.getBuffer();
        this.extBytes.write(bb, 4, dataLen);
        this.extLength -= dataLen;
        if (this.extLength < 0) {
            throw new InvalidPacketSizeException("extLen in header don't match sequence length");
        }
        if (this.extLength == 0) {
            byte[] buffer = this.extBytes.getBuffer();
            IncomingBinaryMessageListener listener = this.incomingBinaryMessageListener;
            if (listener == null && this.binaryStreamListening != null) {
                listener = this.binaryStreamListening.getIncomingBinaryMessageListener();
            }
            if (listener != null) {
                listener.onIncomingBinaryMessage(buffer, 0, this.extBytes.size());
            }
            if (this.producerFactory != null) {
                MessageProducer producer = this.producerFactory.create(buffer, 0, this.extBytes.size(), this.connImpl.getConnection().getMessagePackager());
                producer.parse();
            }
        }
    }

    private InterceptorImpl getInterceptor() {
        if (this.connImpl == null) {
            return this.interceptor;
        }
        InterceptorImpl interceptor = this.connImpl.getProtocol();
        if (interceptor == null) {
            return defaultInterceptor;
        }
        return interceptor;
    }
}

