/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.impl.netty;

import com.genesyslab.platform.commons.PsdkCustomization;
import com.genesyslab.platform.commons.connection.configuration.ConnectionContext;
import com.genesyslab.platform.commons.connection.impl.ContextUtil;
import com.genesyslab.platform.commons.connection.impl.netty.NettyConnectionImpl;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.timer.TimerAction;
import com.genesyslab.platform.commons.timer.TimerActionTicket;
import com.genesyslab.platform.commons.timer.TimerFactory;
import com.genesyslab.platform.commons.timer.impl.ImmidiateExecutionOnShutdown;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.channel.socket.oio.OioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.oio.OioServerSocketChannelFactory;

public class NettyUtil {
    private static volatile ChannelFactory defaultClientFactory;
    private static volatile int defaultClientFactoryUsers;
    private static volatile TimerActionTicket releaseDefaultClientFactoryTicket;
    private static ChannelFactory defaultServerFactory;
    private static int defaultServerFactoryUsers;
    private static volatile TimerActionTicket releaseDefaultServerFactoryTicket;
    private static final NettyTransportType transport;
    private static final int maxServerBossThreads;
    private static final int minServerBossThreads;
    private static final int maxServerWorkerThreads;
    private static final int minServerWorkerThreads;
    private static final ILogger log;
    private static final AtomicInteger bossPoolCounter;
    private static final AtomicInteger workerPoolCounter;
    private static final ConcurrentHashMap<ChannelFactory, Executor> channelFactoryExecutors;

    public static ChannelFactory clientChannelFactory(ConnectionContext<?> ctx) {
        ChannelFactory factory = ContextUtil.getTypedAttribute(ctx, "com.genesyslab.platform.commons.connection.impl.netty.ChannelFactory", ChannelFactory.class);
        if (factory == null) {
            factory = NettyUtil.defaultClientChannelFactory();
        }
        return factory;
    }

    public static ChannelFactory serverChannelFactory(ConnectionContext<?> ctx) {
        ChannelFactory factory = ContextUtil.getTypedAttribute(ctx, "com.genesyslab.platform.commons.connection.impl.netty.ChannelFactory", ChannelFactory.class);
        if (factory == null) {
            factory = NettyUtil.defaultServerChannelFactory();
        }
        return factory;
    }

    private static Executor createBossExecutor(boolean isServerChannel) {
        int corePoolSize = 0;
        int maxPoolSize = Integer.MAX_VALUE;
        if (isServerChannel) {
            corePoolSize = minServerBossThreads;
            maxPoolSize = maxServerBossThreads;
        }
        return new ThreadPoolExecutor(corePoolSize, maxPoolSize, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){
            int poolId = NettyUtil.access$000().incrementAndGet();
            final AtomicInteger threadCounter = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("Boss " + this.poolId + "-" + this.threadCounter.incrementAndGet());
                return t;
            }
        });
    }

    private static Executor createWorkerExecutor(boolean isServerChannel) {
        int corePoolSize = 0;
        int maxPoolSize = Integer.MAX_VALUE;
        if (isServerChannel) {
            corePoolSize = minServerWorkerThreads;
            maxPoolSize = maxServerWorkerThreads;
        }
        return new ThreadPoolExecutor(corePoolSize, maxPoolSize, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){
            int poolId = NettyUtil.access$100().incrementAndGet();
            final AtomicInteger threadCounter = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("Worker " + this.poolId + "-" + this.threadCounter.incrementAndGet());
                return t;
            }
        });
    }

    public static Executor getFactoryExecutor(ChannelFactory factory) {
        return channelFactoryExecutors.get(factory);
    }

    public static void setFactoryExecutor(ChannelFactory factory, Executor executor) {
        if (executor != null) {
            channelFactoryExecutors.put(factory, executor);
        } else {
            channelFactoryExecutors.remove(factory);
        }
    }

    private static synchronized ChannelFactory defaultClientChannelFactory() {
        if (defaultClientFactory == null) {
            Log.getLogger(NettyUtil.class).debug((Object)"Creating default client channel factory");
            Executor executor = null;
            switch (transport) {
                case OioTransport: {
                    executor = NettyUtil.createWorkerExecutor(false);
                    defaultClientFactory = new OioClientSocketChannelFactory(executor);
                    break;
                }
                default: {
                    executor = NettyUtil.createWorkerExecutor(false);
                    defaultClientFactory = new NioClientSocketChannelFactory(NettyUtil.createBossExecutor(false), executor);
                }
            }
            NettyUtil.setFactoryExecutor(defaultClientFactory, executor);
            defaultClientFactoryUsers = 0;
        } else if (releaseDefaultClientFactoryTicket != null) {
            releaseDefaultClientFactoryTicket.cancel();
            releaseDefaultClientFactoryTicket = null;
            --defaultClientFactoryUsers;
        }
        if (defaultClientFactory != null) {
            ++defaultClientFactoryUsers;
        }
        return defaultClientFactory;
    }

    private static synchronized ChannelFactory defaultServerChannelFactory() {
        if (defaultServerFactory == null) {
            Log.getLogger(NettyUtil.class).debug((Object)"Creating default server channel factory");
            switch (transport) {
                case OioTransport: {
                    defaultServerFactory = new OioServerSocketChannelFactory(NettyUtil.createBossExecutor(true), NettyUtil.createWorkerExecutor(true));
                    break;
                }
                default: {
                    defaultServerFactory = new NioServerSocketChannelFactory(NettyUtil.createBossExecutor(true), NettyUtil.createWorkerExecutor(true));
                }
            }
        }
        ++defaultServerFactoryUsers;
        return defaultServerFactory;
    }

    static synchronized ChannelFactory useServerChannelFactory(ChannelFactory factory) {
        if (defaultServerFactory != null && factory == defaultServerFactory) {
            ++defaultServerFactoryUsers;
        }
        return factory;
    }

    public static synchronized void releaseClientChannelFactory(ChannelFactory factory) {
        if (factory != null && factory == defaultClientFactory) {
            if (defaultClientFactoryUsers > 1) {
                --defaultClientFactoryUsers;
            } else if (releaseDefaultClientFactoryTicket == null) {
                releaseDefaultClientFactoryTicket = TimerFactory.getTimer().schedule(500L, (TimerAction)new ReleaseDefaultClientFactoryTask());
            }
        }
    }

    private static synchronized void doReleaseDefaultClientChannelFactory() {
        if (releaseDefaultClientFactoryTicket != null) {
            releaseDefaultClientFactoryTicket.cancel();
            releaseDefaultClientFactoryTicket = null;
            if (--defaultClientFactoryUsers <= 0) {
                Log.getLogger(NettyUtil.class).debug((Object)"Shutting default client channel factory down");
                NettyUtil.setFactoryExecutor(defaultClientFactory, null);
                defaultClientFactory.releaseExternalResources();
                defaultClientFactory = null;
                defaultClientFactoryUsers = 0;
            }
        }
    }

    public static synchronized void releaseServerChannelFactory(ChannelFactory factory) {
        if (factory != null && factory == defaultServerFactory) {
            if (defaultServerFactoryUsers > 1) {
                --defaultServerFactoryUsers;
            } else if (releaseDefaultServerFactoryTicket == null) {
                releaseDefaultServerFactoryTicket = TimerFactory.getTimer().schedule(100L, (TimerAction)new ReleaseDefaultServerFactoryTask());
            }
        }
    }

    private static synchronized void doReleaseDefaultServerChannelFactory() {
        if (releaseDefaultServerFactoryTicket != null) {
            releaseDefaultServerFactoryTicket.cancel();
            releaseDefaultServerFactoryTicket = null;
            if (--defaultServerFactoryUsers <= 0) {
                Log.getLogger(NettyUtil.class).debug((Object)"Shutting default server channel factory down");
                defaultServerFactory.releaseExternalResources();
                defaultServerFactory = null;
                defaultServerFactoryUsers = 0;
            }
        }
    }

    static /* synthetic */ AtomicInteger access$000() {
        return bossPoolCounter;
    }

    static /* synthetic */ AtomicInteger access$100() {
        return workerPoolCounter;
    }

    static {
        defaultClientFactoryUsers = 0;
        releaseDefaultClientFactoryTicket = null;
        defaultServerFactoryUsers = 0;
        releaseDefaultServerFactoryTicket = null;
        log = Log.getLogger(NettyConnectionImpl.class);
        String sType = PsdkCustomization.getOption((PsdkCustomization.PsdkOption)PsdkCustomization.PsdkOption.NettyTransportType);
        if ("OIO".equalsIgnoreCase(sType)) {
            transport = NettyTransportType.OioTransport;
        } else if ("NIO".equalsIgnoreCase(sType)) {
            transport = NettyTransportType.NioTransport;
        } else {
            if (sType != null && sType.length() > 0) {
                log.warnFormat("Invalid Netty transport type specified (''{0}''). Possible values are ''nio'' or ''oio''.", (Object)sType);
            }
            transport = NettyTransportType.NioTransport;
        }
        log.infoFormat("Using Netty with ''{0}''.", (Object)transport);
        minServerBossThreads = PsdkCustomization.getIntOption((PsdkCustomization.PsdkOption)PsdkCustomization.PsdkOption.NettyMinServerBossThreads, (Integer)0);
        maxServerBossThreads = PsdkCustomization.getIntOption((PsdkCustomization.PsdkOption)PsdkCustomization.PsdkOption.NettyMaxServerBossThreads, (Integer)Integer.MAX_VALUE);
        minServerWorkerThreads = PsdkCustomization.getIntOption((PsdkCustomization.PsdkOption)PsdkCustomization.PsdkOption.NettyMinServerWorkerThreads, (Integer)0);
        maxServerWorkerThreads = PsdkCustomization.getIntOption((PsdkCustomization.PsdkOption)PsdkCustomization.PsdkOption.NettyMaxServerWorkerThreads, (Integer)Integer.MAX_VALUE);
        bossPoolCounter = new AtomicInteger();
        workerPoolCounter = new AtomicInteger();
        channelFactoryExecutors = new ConcurrentHashMap();
    }

    private static class ReleaseDefaultServerFactoryTask
    implements TimerAction,
    ImmidiateExecutionOnShutdown {
        private ReleaseDefaultServerFactoryTask() {
        }

        public void onTimer() {
            NettyUtil.doReleaseDefaultServerChannelFactory();
        }

        public String toString() {
            return "ReleaseDefaultServerFactoryTask";
        }
    }

    private static class ReleaseDefaultClientFactoryTask
    implements TimerAction,
    ImmidiateExecutionOnShutdown {
        private ReleaseDefaultClientFactoryTask() {
        }

        public void onTimer() {
            NettyUtil.doReleaseDefaultClientChannelFactory();
        }

        public String toString() {
            return "ReleaseDefaultClientFactoryTask";
        }
    }

    private static enum NettyTransportType {
        NioTransport,
        OioTransport;

    }
}

