/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.impl.xml;

import com.genesyslab.platform.commons.connection.MessagePackager;
import com.genesyslab.platform.commons.connection.impl.xml.ProtocolDialect;
import java.util.HashMap;
import java.util.Map;

public class ProtocolDialectResolver {
    private final Map<String, ProtocolDialect> dialectsMap = new HashMap<String, ProtocolDialect>();
    private final Map<Class<?>, ProtocolDialect> dialectsBases = new HashMap();
    private final Map<String, MessagePackager> packagersMap = new HashMap<String, MessagePackager>();

    public ProtocolDialectResolver register(ProtocolDialect dialect, Class<?> baseClass, MessagePackager packager) {
        this.dialectsMap.put(dialect.getProtocolId(), dialect);
        this.dialectsBases.put(baseClass, dialect);
        this.packagersMap.put(dialect.getProtocolId(), packager);
        return this;
    }

    public ProtocolDialect resolveDialect(String protocolId) {
        if (protocolId != null) {
            return this.dialectsMap.get(protocolId);
        }
        return null;
    }

    public ProtocolDialect resolveMessageDialect(Object message) {
        for (Map.Entry<Class<?>, ProtocolDialect> entry : this.dialectsBases.entrySet()) {
            if (!entry.getKey().isAssignableFrom(message.getClass())) continue;
            return entry.getValue();
        }
        return null;
    }

    public MessagePackager resolvePackager(String protocolId) {
        if (protocolId != null) {
            return this.packagersMap.get(protocolId);
        }
        return null;
    }
}

