/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.impl.xml;

import com.genesyslab.platform.commons.PlatformException;
import com.genesyslab.platform.commons.connection.PsdkConnectionException;
import com.genesyslab.platform.commons.connection.impl.WritePoint;
import com.genesyslab.platform.commons.connection.impl.xml.ProtocolDialect;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.xml.XmlUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlMessage {
    private static ILogger log = Log.getLogger(XmlMessage.class);
    private Document doc;
    private Element currentElement;
    private String stringAttributesEncoding;
    private String targetXmlVersion = null;
    private boolean replaceIllegalUnicodeChars = false;
    private String illegalUnicodeCharsReplacement = null;
    private static final String TEXT = "text";
    private boolean formattingDisabled;

    public XmlMessage(ProtocolDialect dialect, int messageId, String xmlVersion, String stringAttributesEncoding, boolean replaceIllegalChars, String illegalCharsReplacement) throws PlatformException {
        this.targetXmlVersion = xmlVersion;
        this.stringAttributesEncoding = stringAttributesEncoding;
        if (this.stringAttributesEncoding == null) {
            this.stringAttributesEncoding = "UTF-16";
        }
        this.replaceIllegalUnicodeChars = replaceIllegalChars;
        this.illegalUnicodeCharsReplacement = illegalCharsReplacement;
        try {
            this.doc = XmlUtil.createDocument();
            Element envelopeElement = this.doc.createElement("envelope");
            this.doc.appendChild(envelopeElement);
            Element header = dialect.createHeader(this.doc);
            envelopeElement.appendChild(header);
            Element bodyElement = this.doc.createElement("body");
            envelopeElement.appendChild(bodyElement);
            Element messageElement = this.doc.createElement(dialect.getMessageName(messageId));
            bodyElement.appendChild(messageElement);
            this.currentElement = messageElement;
        }
        catch (ParserConfigurationException e) {
            throw new PlatformException("cant create new document, panic!", (Throwable)e);
        }
    }

    public void appendAttribute(String id, String value) {
        this.setNodeValue(this.currentElement, id, value);
    }

    public void createComplex(String name) {
        Element complex = this.doc.createElement(name);
        this.currentElement.appendChild(complex);
        this.currentElement = complex;
    }

    public void closeComplex(String name) {
        String currentName = this.currentElement.getNodeName();
        if (!currentName.equals(name)) {
            throw new PsdkConnectionException("Closing wrong complex. Current: " + currentName + ". Closing: " + name);
        }
        this.currentElement = (Element)this.currentElement.getParentNode();
    }

    private void setNodeValue(Element element, String attrName, String value) {
        if (TEXT.equals(attrName)) {
            String newVal = value;
            if (this.replaceIllegalUnicodeChars) {
                boolean changed = false;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < value.length(); ++i) {
                    char c = value.charAt(i);
                    if (c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || c >= '\u10000' && c <= '\u10ffff') {
                        sb.append(c);
                        continue;
                    }
                    if (this.illegalUnicodeCharsReplacement != null) {
                        sb.append(this.illegalUnicodeCharsReplacement);
                    }
                    changed = true;
                }
                if (changed) {
                    newVal = sb.toString();
                }
            }
            XmlUtil.appendText((Element)element, (String)newVal);
        } else {
            element.setAttribute(attrName, value);
        }
    }

    public void writeTo(WritePoint endpoint) throws IOException, PlatformException {
        int len;
        byte[] b = this.asByteArray();
        if (log.isDebug()) {
            log.debug((Object)("sending xml message: " + new String(b, this.stringAttributesEncoding)));
        }
        if ((len = b.length - 2) <= 0) {
            return;
        }
        if (len <= 16384) {
            byte[] lenBytes = new byte[4];
            XmlMessage.setLength(lenBytes, 0, len + 2);
            endpoint.write(lenBytes, 0, 4);
            endpoint.write(b, 2, len);
            endpoint.write(new byte[]{0, 0});
            return;
        }
        System.arraycopy(b, 2, b, 0, len);
        b[len + 1] = 0;
        b[len] = 0;
        this.writeExtHeader(endpoint, b.length);
        int donelen = b.length;
        int offset = 0;
        while (donelen > 0) {
            int scraplen = donelen > 16380 ? 16380 : donelen;
            byte[] lengthData = new byte[4];
            XmlMessage.setLength(lengthData, 0, scraplen);
            endpoint.write(lengthData, 0, 4);
            endpoint.write(b, offset, scraplen);
            donelen -= scraplen;
            offset += scraplen;
        }
    }

    private void writeExtHeader(WritePoint endpoint, int len) {
        byte[] extPackTag = "$PACKET EXTENSION V1.00$".getBytes();
        byte[] extHeader = new byte[extPackTag.length + 8];
        System.arraycopy(extPackTag, 0, extHeader, 4, extPackTag.length);
        XmlMessage.setLength(extHeader, extPackTag.length + 4, len);
        XmlMessage.setLength(extHeader, 0, extPackTag.length + 4);
        endpoint.write(extHeader, 0, extHeader.length);
    }

    private static void setLength(byte[] buffer, int offset, int length) {
        buffer[offset] = (byte)(length >>> 24);
        buffer[offset + 1] = (byte)(length >>> 16);
        buffer[offset + 2] = (byte)(length >>> 8);
        buffer[offset + 3] = (byte)length;
    }

    private byte[] asByteArray() throws PlatformException {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            DOMSource source = new DOMSource(this.doc);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(stream);
            if (this.targetXmlVersion != null) {
                transformer.setOutputProperty("version", this.targetXmlVersion);
            }
            transformer.setOutputProperty("encoding", this.stringAttributesEncoding);
            if (!this.formattingDisabled) {
                transformer.setOutputProperty("indent", "yes");
            }
            transformer.transform(source, result);
            return stream.toByteArray();
        }
        catch (TransformerConfigurationException e) {
            throw new PlatformException("xml configuration problems", (Throwable)e);
        }
        catch (TransformerException e) {
            throw new PlatformException("xml transformation problems", (Throwable)e);
        }
    }

    public void setFormattingDisabled(boolean formattingDisabled) {
        this.formattingDisabled = formattingDisabled;
    }

    public boolean isFormattingDisabled() {
        return this.formattingDisabled;
    }
}

