/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.interceptor;

import com.genesyslab.platform.commons.connection.Connection;
import com.genesyslab.platform.commons.connection.ConnectionException;
import com.genesyslab.platform.commons.connection.ConnectionState;
import com.genesyslab.platform.commons.connection.configuration.ClientADDPOptions;
import com.genesyslab.platform.commons.connection.configuration.ConnectionConfiguration;
import com.genesyslab.platform.commons.connection.impl.AbstractConnectionImpl;
import com.genesyslab.platform.commons.connection.impl.ConnectionImpl;
import com.genesyslab.platform.commons.connection.impl.ShiftByteArrayOutputStream;
import com.genesyslab.platform.commons.connection.impl.WritePipe;
import com.genesyslab.platform.commons.connection.impl.WritePoint;
import com.genesyslab.platform.commons.connection.interceptor.Interceptor;
import com.genesyslab.platform.commons.connection.interceptor.InterceptorImpl;
import com.genesyslab.platform.commons.connection.interceptor.NoInterceptorImpl;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.timer.Scheduler;
import com.genesyslab.platform.commons.timer.TimerAction;
import com.genesyslab.platform.commons.timer.TimerActionTicket;
import com.genesyslab.platform.commons.timer.TimerFactory;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class AddpInterceptor
extends NoInterceptorImpl
implements InterceptorImpl {
    public static final String NAME = "addp";
    public static final int ADDP_VERSION = 512;
    public static final String TIMEOUT_KEY = "addp-timeout";
    public static final String REMOTE_TIMEOUT_KEY = "addp-remote-timeout";
    public static final String TRACE_KEY = "addp-trace";
    public static final String ACTIVE_KEY = "x-addp-active";
    private static final ILogger addpLog = Log.getLogger((String)"com.genesyslab.platform.ADDP");
    private static final int PACKET_SIZE = 6;
    private static final byte ADDP_SIGNATURE_0 = 112;
    private static final byte ADDP_SIGNATURE_1 = 50;
    private static final int ADDP_TRACE_FLAG = 0x800000;
    private final Object syncState = new Object();
    private TimerActionTicket timerTicket;
    private ConnectionImpl conn;
    private NoInterceptorImpl noProtocol = new NoInterceptorImpl();
    private volatile long timeout;
    private long remoteTimeout;
    private boolean remoteTrace = false;
    private boolean started = false;
    private boolean addpEnabled;
    private volatile boolean active = true;
    private final TimerAction pollAction = new PollAction();
    private int pollId = 0;
    private final Scheduler timer = TimerFactory.getTimer();
    private volatile boolean suppressed;
    private volatile boolean localTrace = false;
    private int remoteVersion = 0;
    private volatile boolean disconecting = false;
    private volatile long lastReceivingTime;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSSS");
    private String conId;

    public AddpInterceptor(ConnectionImpl conn) {
        this.conn = conn;
    }

    public int getRemoteVersion() {
        return this.remoteVersion;
    }

    @Override
    public void executeCommand(Interceptor.Command command) {
        if (!(command instanceof AddpCommand)) {
            throw new IllegalArgumentException("Not an addp command");
        }
        AddpCommand addpCommand = (AddpCommand)command;
        addpCommand.setInterceptor(this);
        addpCommand.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(ConnectionConfiguration config) {
        boolean changedLocalConfiguration = false;
        boolean changedRemoteConfiguration = false;
        Object object = this.syncState;
        synchronized (object) {
            boolean newActive;
            ClientADDPOptions.AddpTraceMode traceMode;
            boolean newRemoteTrace;
            boolean addp;
            String protoName = null;
            if (config != null) {
                protoName = config.getOption("protocol");
            }
            changedRemoteConfiguration |= this.started != (addp = NAME.equals(protoName));
            long newTimeout = this.getTimeout(config, TIMEOUT_KEY, this.timeout, true);
            boolean changeLocalTimeout = this.timeout != newTimeout;
            changedLocalConfiguration |= changeLocalTimeout;
            long newRemoteTimeout = this.getTimeout(config, REMOTE_TIMEOUT_KEY, this.remoteTimeout, false);
            changedRemoteConfiguration |= this.remoteTimeout != newRemoteTimeout;
            String strTraceMode = null;
            if (config != null) {
                strTraceMode = config.getOption(TRACE_KEY);
            }
            changedRemoteConfiguration |= this.remoteTrace != (newRemoteTrace = (traceMode = ClientADDPOptions.AddpTraceMode.parse(strTraceMode)).traceRemote());
            boolean newLocalTrace = traceMode.traceLocal();
            changedLocalConfiguration |= this.localTrace != newLocalTrace;
            String activeOption = null;
            if (config != null) {
                activeOption = config.getOption(ACTIVE_KEY);
            }
            if ((changedLocalConfiguration |= this.active != (newActive = !"false".equals(activeOption))) || changedRemoteConfiguration) {
                this.timeout = newTimeout;
                this.remoteTimeout = newRemoteTimeout;
                this.remoteTrace = newRemoteTrace;
                this.localTrace = newLocalTrace;
                this.active = newActive;
                if (this.started) {
                    this.logConfigure(config, traceMode);
                }
            }
            this.addpEnabled = addp;
            if (!this.started) {
                if (addp) {
                    Connection con;
                    this.logConfigure(config, traceMode);
                    ConnectionImpl conn = this.conn;
                    if (conn != null && (con = conn.getConnection()) != null) {
                        ConnectionState state = con.getConnectionState();
                        if (this.localTrace && addpLog.isInfo() || addpLog.isDebug()) {
                            this.addpLogFormat("(addp-init) client side ADDP timeout={0}", Long.toString(newTimeout));
                        }
                        if (state == ConnectionState.OPENED) {
                            this.start();
                        }
                    }
                }
            } else {
                if (changedRemoteConfiguration) {
                    this.sendReconfigPacket();
                }
                if (!addp) {
                    this.stop();
                } else if (changeLocalTimeout) {
                    this.restartTimer();
                }
            }
        }
    }

    private void logConfigure(ConnectionConfiguration config, ClientADDPOptions.AddpTraceMode traceMode) {
        if (addpLog.isInfo()) {
            addpLog.infoFormat("(addp_mode) active={3}\n(addp_configure) local {0} msec, remote {1} msec, trace={2};", (Object)new Object[]{Long.toString(this.timeout), Long.toString(this.remoteTimeout), traceMode.ordinal(), this.active});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.syncState;
        synchronized (object) {
            if (!this.started) {
                int n;
                this.started = true;
                try {
                    n = this.conn.getConnection().getLocalEndPoint().getPort();
                }
                catch (Throwable e) {
                    n = 0;
                }
                String string = this.conId = n != 0 ? "" + n : "0" + this.conn.hashCode();
                if (this.active) {
                    this.sendInitPacket();
                    this.restartTimer();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.syncState;
        synchronized (object) {
            this.stopTimer();
            if (this.started) {
                this.started = false;
            }
        }
    }

    @Override
    public void dispose() {
        this.stopTimer();
    }

    public boolean isSuppressed() {
        return this.suppressed;
    }

    public void setSuppressed(boolean suppressed) {
        if (this.suppressed != suppressed && addpLog.isDebug()) {
            if (suppressed) {
                addpLog.debugFormat("[ADDP] is now suppressed for connection {0}", (Object)this.conn);
            } else {
                addpLog.debugFormat("ADDP suppression is now removed for connection {0}", (Object)this.conn);
            }
        }
        this.suppressed = suppressed;
    }

    @Override
    public int getPacketLength(byte[] buffer, int offset, int len) {
        this.disconecting = false;
        this.lastReceivingTime = System.currentTimeMillis();
        if (len < 4) {
            return 0;
        }
        if (this.isAddpPacket(buffer, offset)) {
            if (len < 6) {
                return 0;
            }
            return 6;
        }
        return this.noProtocol.getPacketLength(buffer, offset, len);
    }

    private boolean isAddpPacket(byte[] src, int offset) {
        return src[offset] == 112 && src[offset + 1] == 50;
    }

    @Override
    public boolean processPacket(ShiftByteArrayOutputStream stream, int packetLen) {
        byte[] bytes = stream.getBuffer();
        if (this.isAddpPacket(bytes, 0)) {
            this.processAddpPacket(bytes);
            stream.shiftBack(packetLen);
            return true;
        }
        return this.noProtocol.processPacket(stream, packetLen);
    }

    private void processAddpPacket(byte[] bytes) {
        char packetType = (char)bytes[2];
        int packetData = AddpInterceptor.getPacketData(bytes);
        switch (packetType) {
            case 'p': {
                if ((!this.localTrace || !addpLog.isInfo()) && !addpLog.isDebug()) break;
                this.addpLogFormat("\n-Ap[{0}]-<-{1} @{2}", packetData);
                break;
            }
            case 'P': {
                this.sendPacket('p', packetData);
                if ((!this.localTrace || !addpLog.isInfo()) && !addpLog.isDebug()) break;
                this.addpLogFormat("\n-AP[{0}]-<-{1} @{2}\n-Ap[{0}]->-{1}", packetData);
                break;
            }
            case 'X': {
                if (packetData != 0) {
                    this.suspendAddp(packetData);
                } else {
                    this.resumeAddp();
                }
                if ((!this.localTrace || !addpLog.isInfo()) && !addpLog.isDebug()) break;
                String flag = packetData > 0 ? "on" : "off";
                this.addpLogFormat("\n-AX[" + flag + "][{0}]-<-{1} @{2}", packetData);
                break;
            }
            case 'R': {
                this.sendPacket('r', (int)this.timeout);
                this.active = true;
                long oldTimeout = this.timeout;
                long newTimeout = this.unpackAddpData(packetData);
                if (oldTimeout == 0L && newTimeout != 0L) {
                    this.restartTimer();
                } else if (oldTimeout != 0L && newTimeout == 0L) {
                    this.cancelTimerTicket();
                }
                if ((!this.localTrace || !addpLog.isInfo()) && !addpLog.isDebug()) break;
                this.addpLogFormat("\n-AR[t/o:{0},trace]-<-{1} @{2}", packetData);
                break;
            }
            case 'r': {
                if ((!this.localTrace || !addpLog.isInfo()) && !addpLog.isDebug()) break;
                this.addpLogFormat("\n-Ar[{0}]-<-{1} @{2}", packetData);
                break;
            }
            case 'I': {
                int data = this.conn.hashCode();
                this.sendPacket('i', data);
                this.active = true;
                this.unpackAddpData(packetData);
                if (this.localTrace && addpLog.isInfo() || addpLog.isDebug()) {
                    this.addpLogFormat("\n-AI[t/o:{0},trace]-<-{1} @{2}\n-Ai[" + data + "]->-{1}", this.timeout);
                }
                this.restartTimer();
                break;
            }
            case 'i': {
                if ((!this.localTrace || !addpLog.isInfo()) && !addpLog.isDebug()) break;
                this.addpLogFormat("\n-Ai[{0}]-<-{1} @{2}", packetData);
                break;
            }
            case 'V': {
                this.sendPacket('v', 512);
                this.remoteVersion = packetData;
                break;
            }
            default: {
                if (!addpLog.isWarn()) break;
                addpLog.warn((Object)("[ADDP] Strange packet. Type: " + packetType + " from " + this.conn));
            }
        }
    }

    protected void addpLogFormat(String format, long packetData) {
        this.addpLogFormat(format, this.addpLogArgs(packetData));
    }

    protected void addpLogFormat(String format, Object args) {
        if (this.localTrace) {
            addpLog.infoFormat(format, args);
        } else {
            addpLog.debugFormat(format, args);
        }
    }

    private Object[] addpLogArgs(long packetData) {
        return new Object[]{Long.toString(packetData), this.conId, this.dateFormat.format(Calendar.getInstance().getTime())};
    }

    private long unpackAddpData(int packetData) {
        this.localTrace = (packetData & 0x800000) != 0;
        long newTimeout = packetData;
        if (this.localTrace) {
            newTimeout &= 0xFFFFFFFFFF7FFFFFL;
        }
        this.timeout = newTimeout;
        if (addpLog.isDebug()) {
            addpLog.debugFormat("[ADDP] New timeout: {0}; trace: {1}", (Object)new Object[]{Long.toString(this.timeout), this.localTrace});
        }
        return newTimeout;
    }

    private static int getPacketData(byte[] bytes) {
        return (0xFF0000 & bytes[3] << 16) + (0xFF00 & bytes[4] << 8) + (0xFF & bytes[5]);
    }

    private long getTimeout(ConnectionConfiguration config, String name, long defaultTimeout, boolean localTimeout) {
        String str = null;
        if (config != null) {
            str = config.getOption(name);
        }
        if (str == null) {
            return defaultTimeout;
        }
        try {
            float f = Float.parseFloat(str);
            long t = (long)(f * 1000.0f);
            if (t > 0L && t < 1000L) {
                if (addpLog.isDebug()) {
                    addpLog.debugFormat("[ADDP] {1} timeout [{0}] is very low. Default timeout 1000 msec will be used.", (Object)new Object[]{Long.toString(t), localTimeout ? "local" : "remote"});
                }
                t = 1000L;
            }
            return t;
        }
        catch (NumberFormatException ignore) {
            return -1L;
        }
    }

    private void sendInitPacket() {
        if (this.localTrace && addpLog.isInfo() || addpLog.isDebug()) {
            ConnectionImpl c = this.conn;
            String additionalInfo = c instanceof AbstractConnectionImpl && ((AbstractConnectionImpl)c).isServerConnection() ? "\n(addp-init) client side ADDP timeout={" + this.timeout + "}" : "";
            this.addpLogFormat(additionalInfo + "\n-AI[t/o:{0},trace]->-{1} @{2}", this.remoteTimeout);
        }
        int data = (int)this.remoteTimeout;
        if (this.remoteTrace) {
            data |= 0x800000;
        }
        this.sendPacket('I', data);
    }

    private void sendReconfigPacket() {
        int data;
        if (this.localTrace && addpLog.isInfo() || addpLog.isDebug()) {
            this.addpLogFormat("\n-AR[t/o:{0},trace]->-{1} @{2}", this.remoteTimeout);
        }
        int n = data = this.addpEnabled ? (int)this.remoteTimeout : 0;
        if (this.remoteTrace) {
            data |= 0x800000;
        }
        this.sendPacket('R', data);
    }

    private void sendPacket(char packetType, int data) {
        ConnectionState connectionState = this.conn.getConnection().getConnectionState();
        if (connectionState == ConnectionState.CLOSING || connectionState == ConnectionState.CLOSED) {
            return;
        }
        byte[] packetBuffer = new byte[]{112, 50, (byte)packetType, (byte)((data & 0xFFFFFF) >> 16 & 0xFF), (byte)((data & 0xFFFFFF) >> 8 & 0xFF), (byte)(data & 0xFF)};
        WritePipe writePipe = this.conn.getWritePipe();
        WritePoint writePoint = writePipe instanceof WritePipe.TechnicalTrafficSupport ? ((WritePipe.TechnicalTrafficSupport)((Object)writePipe)).createTechnicalTrafficWritePoint() : writePipe.createWritePoint();
        writePoint.write(packetBuffer);
        writePipe.write(writePoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restartTimer() {
        Object object = this.syncState;
        synchronized (object) {
            this.disconecting = false;
            this.lastReceivingTime = System.currentTimeMillis();
            this.rescheduleTimer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleDisconect() {
        Object object = this.syncState;
        synchronized (object) {
            this.lastReceivingTime = System.currentTimeMillis();
            this.rescheduleTimer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rescheduleTimer() {
        Object object = this.syncState;
        synchronized (object) {
            long timeoutCurrent;
            this.cancelTimerTicket();
            if (this.started && (timeoutCurrent = this.timeout) > 0L) {
                long t = timeoutCurrent - (System.currentTimeMillis() - this.getLastActivity());
                if (t <= 0L) {
                    t = 1L;
                }
                this.timerTicket = this.timer.schedule(t, this.pollAction);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelTimerTicket() {
        Object object = this.syncState;
        synchronized (object) {
            if (this.timerTicket != null) {
                if (addpLog.isDebug()) {
                    addpLog.debug((Object)"[ADDP] cancel timer task");
                }
                this.timerTicket.cancel();
                this.timerTicket = null;
            }
        }
    }

    private void stopTimer() {
        this.cancelTimerTicket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void suspendAddp(long timeout) {
        Object object = this.syncState;
        synchronized (object) {
            this.cancelTimerTicket();
            if (addpLog.isDebug()) {
                addpLog.debugFormat("[ADDP] schedule suspend timer task in {0} msec", (Object)Long.toString(timeout));
            }
            this.timerTicket = this.timer.schedule(timeout, (TimerAction)new SuspendAction());
        }
    }

    private void sendXoffPacket(long timeout) {
        if (timeout < 0L) {
            timeout = 3600L;
        }
        if (timeout > 3600L) {
            timeout = 3600L;
        }
        if (this.localTrace && addpLog.isInfo() || addpLog.isDebug()) {
            String flag = timeout >= 0L ? "on" : "off";
            this.addpLogFormat("\n-AX" + flag + "[{0}]->-{1} @{2}", timeout);
        }
        this.sendPacket('X', (int)timeout);
    }

    private void sendXonPacket() {
        if (this.localTrace && addpLog.isInfo() || addpLog.isDebug()) {
            this.addpLogFormat("\n-AXon[{0}]->-{1} @{2}", this.timeout);
        }
        this.sendPacket('X', 0);
    }

    private void resumeAddp() {
        this.restartTimer();
    }

    private void pollConnection() {
        if (this.localTrace && addpLog.isInfo() || addpLog.isDebug()) {
            this.addpLogFormat("\n-AP[{0}]->-{1} @{2}", this.pollId);
        }
        this.sendPacket('P', this.pollId++);
    }

    private long getLastActivity() {
        return Math.max(this.lastReceivingTime, this.conn.getWritePipe().getLastSendingTime());
    }

    private class SuspendAction
    implements TimerAction {
        private SuspendAction() {
        }

        public void onTimer() {
            AddpInterceptor.this.resumeAddp();
        }

        public String toString() {
            return "SuspendtAction for '" + AddpInterceptor.this.conn;
        }
    }

    private class PollAction
    implements TimerAction {
        private PollAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onTimer() {
            if (!ConnectionState.OPENED.equals((Object)AddpInterceptor.this.conn.getConnection().getConnectionState())) {
                return;
            }
            Object object = AddpInterceptor.this.syncState;
            synchronized (object) {
                if (!AddpInterceptor.this.active) {
                    return;
                }
                if (AddpInterceptor.this.suppressed) {
                    addpLog.debugFormat("[ADDP] polling is suppressed for connection {0}", (Object)AddpInterceptor.this.conn);
                    AddpInterceptor.this.restartTimer();
                    return;
                }
                long timeout = AddpInterceptor.this.timeout;
                if (timeout <= 0L) {
                    return;
                }
                long lastActivityTime = AddpInterceptor.this.getLastActivity();
                long idleTime = System.currentTimeMillis() - lastActivityTime;
                if (addpLog.isDebug()) {
                    addpLog.debugFormat("[ADDP] on timer task. idle={0} timeout={1}", (Object)new Object[]{Long.toString(idleTime), Long.toString(timeout)});
                }
                if (idleTime >= timeout) {
                    if (AddpInterceptor.this.disconecting) {
                        this.tryDisconnect();
                    } else {
                        AddpInterceptor.this.disconecting = true;
                        AddpInterceptor.this.pollConnection();
                        AddpInterceptor.this.scheduleDisconect();
                    }
                } else {
                    AddpInterceptor.this.rescheduleTimer();
                }
            }
        }

        public void tryDisconnect() {
            Connection connection = AddpInterceptor.this.conn.getConnection();
            ConnectionState connState = connection.getConnectionState();
            if (ConnectionState.OPENED == connState) {
                if (AddpInterceptor.this.localTrace && addpLog.isInfo() || addpLog.isDebug()) {
                    AddpInterceptor.this.addpLogFormat("Closing idle connection tcp://{2}\nADDP: closing {0} - timed out ({1} msec), remote socket [tcp:/{2}]", new Object[]{AddpInterceptor.this.conId, Long.toString(AddpInterceptor.this.timeout), connection.getRemoteEndPoint()});
                }
                AddpInterceptor.this.conn.close((Throwable)((Object)new ConnectionException("connection is unresponsive")));
            }
        }

        public String toString() {
            return "PollAction for '" + AddpInterceptor.this.conn;
        }
    }

    public static class ResumeCommand
    extends AddpCommand {
        @Override
        public void execute() {
            if (this.interceptor != null) {
                this.interceptor.sendXonPacket();
            }
        }
    }

    public static class SuspendCommand
    extends AddpCommand {
        private long suspendInterval;

        public SuspendCommand(long suspendInterval) {
            this.suspendInterval = suspendInterval;
        }

        @Override
        public void execute() {
            if (this.interceptor != null) {
                this.interceptor.sendXoffPacket(this.suspendInterval);
            }
        }
    }

    private static abstract class AddpCommand
    implements Interceptor.Command {
        protected AddpInterceptor interceptor;

        private AddpCommand() {
        }

        @Override
        public void setInterceptor(Interceptor interceptor) {
            if (interceptor instanceof AddpInterceptor) {
                this.interceptor = (AddpInterceptor)interceptor;
            }
        }

        public abstract void execute();
    }
}

