/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.tls;

import com.genesyslab.platform.commons.collections.util.Base64;
import com.genesyslab.platform.commons.connection.impl.asn1.Attribute;
import com.genesyslab.platform.commons.connection.impl.asn1.AttributeParser;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.util.Collection;
import java.util.List;

public class CertificateLoader {
    private static final ILogger log = Log.getLogger(CertificateLoader.class);
    private static final String TAG_BEGIN_PKCS8_PRIVATE_KEY = "-----BEGIN PRIVATE KEY-----";
    private static final String TAG_END_PKCS8_PRIVATE_KEY = "-----END PRIVATE KEY-----";
    private static final String TAG_BEGIN_X509_PRIVATE_KEY = "-----BEGIN RSA PRIVATE KEY-----";
    private static final String TAG_END_X509_PRIVATE_KEY = "-----END RSA PRIVATE KEY-----";

    public static Certificate[] loadCertificatesFromX509PEM(InputStream inputStream) throws GeneralSecurityException, IOException {
        CertificateFactory f = CertificateFactory.getInstance("X.509");
        Collection<? extends Certificate> certChain = f.generateCertificates(inputStream);
        return certChain.toArray(new Certificate[certChain.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Certificate[] loadCertificatesFromX509PEM(String path) throws GeneralSecurityException, IOException {
        log.debugFormat("Loading X.509 PEM certificate chain from file {0}...", (Object)path);
        FileInputStream inputStream = new FileInputStream(path);
        try {
            Certificate[] certificateArray = CertificateLoader.loadCertificatesFromX509PEM(inputStream);
            return certificateArray;
        }
        finally {
            ((InputStream)inputStream).close();
        }
    }

    public static Certificate loadCertificateFromX509PEM(InputStream inputStream) throws GeneralSecurityException, IOException {
        CertificateFactory f = CertificateFactory.getInstance("X.509");
        return f.generateCertificate(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Certificate loadCertificateFromX509PEM(String path) throws GeneralSecurityException, IOException {
        log.debugFormat("Loading X.509 PEM certificate from file {0}...", (Object)path);
        FileInputStream inputStream = new FileInputStream(path);
        try {
            Certificate certificate = CertificateLoader.loadCertificateFromX509PEM(inputStream);
            return certificate;
        }
        finally {
            ((InputStream)inputStream).close();
        }
    }

    public static PrivateKey loadKeyFromX509PEM(InputStream inputStream) throws GeneralSecurityException, IOException {
        byte[] keyBytes = CertificateLoader.readX509PrivatKeyStream(inputStream);
        return CertificateLoader.createKeyFromX509Bytes(keyBytes);
    }

    public static PrivateKey loadKeyFromPKCS8PEM(InputStream inputStream) throws GeneralSecurityException, IOException {
        byte[] keyBytes = CertificateLoader.readPKCS8PrivatKeyStream(inputStream);
        return CertificateLoader.createKeyFromPKCS8Bytes(keyBytes);
    }

    private static byte[] readPKCS8PrivatKeyStream(InputStream inputStream) throws IOException, GeneralSecurityException {
        return CertificateLoader.readPEMStream(inputStream, TAG_BEGIN_PKCS8_PRIVATE_KEY, TAG_END_PKCS8_PRIVATE_KEY);
    }

    private static byte[] readX509PrivatKeyStream(InputStream inputStream) throws IOException, GeneralSecurityException {
        return CertificateLoader.readPEMStream(inputStream, TAG_BEGIN_X509_PRIVATE_KEY, TAG_END_X509_PRIVATE_KEY);
    }

    private static byte[] readPEMStream(InputStream inputStream, String beginTag, String endTag) throws IOException, GeneralSecurityException {
        byte[] rawBytes = CertificateLoader.readFully(inputStream);
        String rawText = new String(rawBytes);
        int beginIndex = rawText.indexOf(beginTag);
        if (beginIndex < 0) {
            throw new GeneralSecurityException("Could not find private key beginning tag");
        }
        int endIndex = rawText.indexOf(endTag, beginIndex += beginTag.length());
        if (endIndex < 0) {
            throw new GeneralSecurityException("Could not find private key ending tag");
        }
        byte[] keyBytes = CertificateLoader.decodeBase64Bytes(rawText.substring(beginIndex, endIndex));
        return keyBytes;
    }

    private static byte[] decodeBase64Bytes(String base64Text) throws GeneralSecurityException {
        byte[] base64Bytes = base64Text.getBytes();
        if (!Base64.isArrayByteBase64((byte[])base64Bytes)) {
            throw new GeneralSecurityException("Could not decode key text: unrecognizable Base64 encoding");
        }
        byte[] keyBytes = Base64.decodeBase64((byte[])base64Bytes);
        return keyBytes;
    }

    public static PrivateKey loadKeyFromPEM(InputStream inputStream) throws GeneralSecurityException, IOException {
        byte[] rawBytes = CertificateLoader.readFully(inputStream);
        String rawText = new String(rawBytes);
        boolean flagX509 = false;
        boolean flagPKCS8 = false;
        int indexPKCS8 = rawText.indexOf(TAG_BEGIN_PKCS8_PRIVATE_KEY);
        int indexX509 = rawText.indexOf(TAG_BEGIN_X509_PRIVATE_KEY);
        if (indexPKCS8 >= 0 && indexX509 >= 0) {
            if (indexPKCS8 < indexX509) {
                flagPKCS8 = true;
            } else {
                flagX509 = true;
            }
        } else if (indexPKCS8 >= 0) {
            flagPKCS8 = true;
            indexPKCS8 += TAG_BEGIN_PKCS8_PRIVATE_KEY.length();
        } else if (indexX509 >= 0) {
            flagX509 = true;
            indexX509 += TAG_BEGIN_X509_PRIVATE_KEY.length();
        }
        if (flagPKCS8) {
            int endIndex = rawText.indexOf(TAG_END_PKCS8_PRIVATE_KEY, indexPKCS8);
            if (endIndex < 0) {
                throw new GeneralSecurityException("Could not find PKCS#8 private key ending tag");
            }
            byte[] bytes = CertificateLoader.decodeBase64Bytes(rawText.substring(indexPKCS8, endIndex));
            return CertificateLoader.createKeyFromPKCS8Bytes(bytes);
        }
        if (flagX509) {
            int endIndex = rawText.indexOf(TAG_END_X509_PRIVATE_KEY, indexX509);
            if (endIndex < 0) {
                throw new GeneralSecurityException("Could not find X.509 private key ending tag");
            }
            byte[] bytes = CertificateLoader.decodeBase64Bytes(rawText.substring(indexX509, endIndex));
            return CertificateLoader.createKeyFromX509Bytes(bytes);
        }
        throw new GeneralSecurityException("Could not find nor X.509 nor PKCS#8 private key begin tag");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrivateKey loadKeyFromPEM(String path) throws GeneralSecurityException, IOException {
        log.debugFormat("Loading PKCS#8/X.509 PEM private key from file {0}...", (Object)path);
        FileInputStream inputStream = new FileInputStream(path);
        try {
            PrivateKey privateKey = CertificateLoader.loadKeyFromPEM(inputStream);
            return privateKey;
        }
        finally {
            ((InputStream)inputStream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrivateKey loadKeyFromX509PEM(String path) throws GeneralSecurityException, IOException {
        log.debugFormat("Loading X.509 PEM private key from file {0}...", (Object)path);
        FileInputStream inputStream = new FileInputStream(path);
        try {
            PrivateKey privateKey = CertificateLoader.loadKeyFromX509PEM(inputStream);
            return privateKey;
        }
        finally {
            ((InputStream)inputStream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrivateKey loadKeyFromPKCS8PEM(String path) throws GeneralSecurityException, IOException {
        log.debugFormat("Loading PKCS#8 PEM private key from file {0}...", (Object)path);
        FileInputStream inputStream = new FileInputStream(path);
        try {
            PrivateKey privateKey = CertificateLoader.loadKeyFromPKCS8PEM(inputStream);
            return privateKey;
        }
        finally {
            ((InputStream)inputStream).close();
        }
    }

    public static PrivateKey loadKeyFromX509DER(InputStream inputStream) throws GeneralSecurityException, IOException {
        byte[] encodedKey = CertificateLoader.readFully(inputStream);
        return CertificateLoader.createKeyFromX509Bytes(encodedKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrivateKey loadKeyFromX509DER(String path) throws GeneralSecurityException, IOException {
        log.debugFormat("Loading X.509 DER private key from file {0}...", (Object)path);
        FileInputStream inputStream = new FileInputStream(path);
        try {
            PrivateKey privateKey = CertificateLoader.loadKeyFromX509DER(inputStream);
            return privateKey;
        }
        finally {
            ((InputStream)inputStream).close();
        }
    }

    public static PrivateKey loadKeyFromPKCS8DER(InputStream inputStream) throws GeneralSecurityException, IOException {
        byte[] encodedKey = CertificateLoader.readFully(inputStream);
        return CertificateLoader.createKeyFromPKCS8Bytes(encodedKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrivateKey loadKeyFromPKCS8DER(String path) throws GeneralSecurityException, IOException {
        log.debugFormat("Loading PKCS#8 DER private key from file {0}...", (Object)path);
        FileInputStream inputStream = new FileInputStream(path);
        try {
            PrivateKey privateKey = CertificateLoader.loadKeyFromPKCS8DER(inputStream);
            return privateKey;
        }
        finally {
            ((InputStream)inputStream).close();
        }
    }

    public static PrivateKey createKeyFromPKCS8Bytes(byte[] encodedKey) throws GeneralSecurityException {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encodedKey);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePrivate(keySpec);
    }

    public static PrivateKey createKeyFromX509Bytes(byte[] encodedKey) throws GeneralSecurityException {
        try {
            Attribute aRoot = AttributeParser.parse(encodedKey);
            if (aRoot == null) {
                throw new GeneralSecurityException("Invalid RSA private key format (no root).");
            }
            List<Attribute> children = aRoot.getChildren();
            if (children == null) {
                throw new GeneralSecurityException("Invalid RSA private key format (no children).");
            }
            BigInteger v = AttributeParser.getBigint(children.get(0));
            if (v == null) {
                throw new GeneralSecurityException("No version for RSA private key");
            }
            int version = v.intValue();
            if (version != 0 && version != 1) {
                throw new GeneralSecurityException("Wrong version for RSA private key");
            }
            if (children.size() <= 1) {
                throw new GeneralSecurityException("Invalid RSA private key format (no modulus).");
            }
            BigInteger modulus = AttributeParser.getBigint(children.get(1));
            if (modulus == null) {
                throw new GeneralSecurityException("Invalid RSA private key format (invalid modulus).");
            }
            if (children.size() <= 3) {
                throw new GeneralSecurityException("Invalid RSA private key format (no private exponent).");
            }
            BigInteger privateExponent = AttributeParser.getBigint(children.get(3));
            if (privateExponent == null) {
                throw new GeneralSecurityException("Invalid RSA private key format (invalid private exponent).");
            }
            RSAPrivateKeySpec spec = new RSAPrivateKeySpec(modulus, privateExponent);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return kf.generatePrivate(spec);
        }
        catch (GeneralSecurityException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new GeneralSecurityException("Parsing of RSA private key failed.", ex);
        }
    }

    public static Collection<? extends CRL> loadCRLFromPEM(InputStream inputStream) throws GeneralSecurityException, IOException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        return factory.generateCRLs(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<? extends CRL> loadCRLFromPEM(String path) throws GeneralSecurityException, IOException {
        log.debugFormat("Loading CRL PEM from file {0}...", (Object)path);
        FileInputStream inputStream = new FileInputStream(path);
        try {
            Collection<? extends CRL> collection = CertificateLoader.loadCRLFromPEM(inputStream);
            return collection;
        }
        finally {
            ((InputStream)inputStream).close();
        }
    }

    public static byte[] readFully(InputStream inputStream) throws IOException {
        int length;
        ByteArrayOutputStream bytesStream = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        while ((length = inputStream.read(buf)) >= 0) {
            bytesStream.write(buf, 0, length);
        }
        return bytesStream.toByteArray();
    }
}

