/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.tls;

import com.genesyslab.platform.commons.connection.tls.DNParser;
import com.genesyslab.platform.commons.connection.tls.IPAddressUtil;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;

@Deprecated
public class HostnameChecker {
    private static final ILogger log = Log.getLogger(HostnameChecker.class);
    private static final int ALTNAME_DNS = 2;
    private static final int ALTNAME_IP = 7;

    public static void match(String expectedName, X509Certificate cert) throws CertificateException {
        log.debugFormat("Matching certificate subject names against expected value \"{0}\"...", (Object)expectedName);
        if (HostnameChecker.isIpAddress(expectedName)) {
            log.debug((Object)"Matching IP address (exact match required)");
            HostnameChecker.matchIP(expectedName, cert);
        } else {
            log.debug((Object)"Matching domain name (wildcards allowed)");
            HostnameChecker.matchDNS(expectedName, cert);
        }
        log.debug((Object)"Match successful.");
    }

    static boolean isIpAddress(String name) {
        return IPAddressUtil.isIPv4LiteralAddress(name) || IPAddressUtil.isIPv6LiteralAddress(name);
    }

    static void matchIP(String expectedIP, X509Certificate cert) throws CertificateException {
        Collection<List<?>> subjAltNames = cert.getSubjectAlternativeNames();
        if (subjAltNames == null) {
            throw new CertificateException("No subject alternative names present");
        }
        log.debug((Object)"Matching certificate Subject Alternative Names...");
        for (List<?> next : subjAltNames) {
            if ((Integer)next.get(0) != 7) continue;
            String ipAddress = (String)next.get(1);
            log.debugFormat("Matching IP address \"{0}\"...", (Object)ipAddress);
            if (!expectedIP.equalsIgnoreCase(ipAddress)) continue;
            return;
        }
        throw new CertificateException("No subject alternative names matching IP address " + expectedIP + " found");
    }

    static void matchDNS(String expectedName, X509Certificate cert) throws CertificateException {
        String commonName;
        Collection<List<?>> subjAltNames = cert.getSubjectAlternativeNames();
        if (subjAltNames != null) {
            log.debug((Object)"Matching certificate Subject Alternative Names...");
            boolean foundDNS = false;
            for (List<?> next : subjAltNames) {
                if ((Integer)next.get(0) != 2) continue;
                foundDNS = true;
                String dnsName = (String)next.get(1);
                log.debugFormat("Matching domain name \"{0}\"...", (Object)dnsName);
                if (!HostnameChecker.isMatched(expectedName, dnsName)) continue;
                return;
            }
            if (foundDNS) {
                throw new CertificateException("No subject alternative DNS name matching " + expectedName + " found.");
            }
        }
        try {
            commonName = new DNParser(cert.getSubjectX500Principal()).findLastAttrOccurence("CN");
        }
        catch (ParseException e) {
            throw new CertificateException(e);
        }
        if (null != commonName) {
            log.debugFormat("Matching certificate Distinguished Name \"{0}\"...", (Object)commonName);
            if (HostnameChecker.isMatched(expectedName, commonName)) {
                return;
            }
        }
        throw new CertificateException("No name matching " + expectedName + " found");
    }

    static boolean isMatched(String name, String template) {
        return HostnameChecker.matchAllWildcards(name, template);
    }

    static boolean matchAllWildcards(String name, String template) {
        name = name.toLowerCase(Locale.ENGLISH);
        template = template.toLowerCase(Locale.ENGLISH);
        StringTokenizer nameSt = new StringTokenizer(name, ".");
        StringTokenizer templateSt = new StringTokenizer(template, ".");
        if (nameSt.countTokens() != templateSt.countTokens()) {
            return false;
        }
        while (nameSt.hasMoreTokens()) {
            if (HostnameChecker.matchWildcards(nameSt.nextToken(), templateSt.nextToken())) continue;
            return false;
        }
        return true;
    }

    static boolean matchWildcards(String name, String template) {
        int wildcardIdx = template.indexOf("*");
        if (wildcardIdx == -1) {
            return name.equals(template);
        }
        boolean isBeginning = true;
        String afterWildcard = template;
        while (wildcardIdx != -1) {
            String beforeWildcard = afterWildcard.substring(0, wildcardIdx);
            afterWildcard = afterWildcard.substring(wildcardIdx + 1);
            int beforeStartIdx = name.indexOf(beforeWildcard);
            if (beforeStartIdx == -1 || isBeginning && beforeStartIdx != 0) {
                return false;
            }
            isBeginning = false;
            name = name.substring(beforeStartIdx + beforeWildcard.length());
            wildcardIdx = afterWildcard.indexOf("*");
        }
        return name.endsWith(afterWildcard);
    }
}

