/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.tls;

import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import sun.security.util.HostnameChecker;

public class HostnameCheckingTrustManager
implements X509TrustManager {
    private static final ILogger log = Log.getLogger(HostnameCheckingTrustManager.class);
    private final String expectedHostname;
    private final X509TrustManager wrappedTrustManager;
    private static final HostnameChecker HOSTNAME_CHECKER = HostnameChecker.getInstance((byte)1);

    public HostnameCheckingTrustManager(String expectedHostname, X509TrustManager wrappedTrustManager) {
        if (null == expectedHostname) {
            throw new IllegalArgumentException("expectedHostname must not be null");
        }
        if (expectedHostname.trim().length() == 0) {
            throw new IllegalArgumentException("expectedHostname must not be empty");
        }
        if (null == wrappedTrustManager) {
            throw new IllegalArgumentException("wrappedTrustManager must not be null");
        }
        if (expectedHostname.lastIndexOf(46) == -1 && expectedHostname.lastIndexOf(58) == -1) {
            try {
                InetAddress a = InetAddress.getByName(expectedHostname);
                expectedHostname = a.getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                if (log.isWarn()) {
                    log.warn((Object)("no IP address for the host '" + expectedHostname + "' could be found"), (Throwable)e);
                }
            }
            catch (SecurityException e) {
                log.error((Object)("Security exception (while get a canonical host name for : " + expectedHostname + ")"), (Throwable)e);
            }
        }
        this.expectedHostname = expectedHostname;
        this.wrappedTrustManager = wrappedTrustManager;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        this.wrappedTrustManager.checkClientTrusted(x509Certificates, s);
        this.matchName(x509Certificates);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        this.wrappedTrustManager.checkServerTrusted(x509Certificates, s);
        this.matchName(x509Certificates);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.wrappedTrustManager.getAcceptedIssuers();
    }

    private void matchName(X509Certificate[] x509Certificates) throws CertificateException {
        boolean matched = false;
        if (null != x509Certificates) {
            for (X509Certificate cert : x509Certificates) {
                try {
                    HOSTNAME_CHECKER.match(this.expectedHostname, cert);
                    matched = true;
                    break;
                }
                catch (CertificateException e) {
                    log.debug((Object)"Could not match remote hostname.", (Throwable)e);
                }
            }
        }
        if (!matched) {
            throw new CertificateException("None of presented certificates matched expected host name " + this.expectedHostname);
        }
    }
}

