/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.tls;

import com.genesyslab.platform.commons.connection.tls.AliasKeyManager;
import com.genesyslab.platform.commons.connection.tls.CertificateLoader;
import com.genesyslab.platform.commons.connection.tls.EmptyX509ExtendedKeyManager;
import com.genesyslab.platform.commons.connection.tls.KeyStoreFactory;
import com.genesyslab.platform.commons.connection.tls.ThumbprintKeyManager;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.security.auth.callback.CallbackHandler;

public class KeyManagerHelper {
    public static X509ExtendedKeyManager createPEMKeyManager(InputStream certStream, InputStream keyStream) throws IOException, GeneralSecurityException {
        if (null == certStream) {
            throw new IllegalArgumentException("certStream must not be null");
        }
        if (null == keyStream) {
            throw new IllegalArgumentException("keyStream must not be empty");
        }
        Certificate[] certChain = CertificateLoader.loadCertificatesFromX509PEM(certStream);
        PrivateKey privateKey = CertificateLoader.loadKeyFromPEM(keyStream);
        KeyStore certKeyStore = KeyStoreFactory.createPEMCertKeyStore(certChain, privateKey);
        return new AliasKeyManager(certKeyStore, "DefaultCertificate", KeyStoreFactory.DEFAULT_PASSWORD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509ExtendedKeyManager createPEMKeyManager(String certFilePath, String keyFilePath) throws IOException, GeneralSecurityException {
        if (null == certFilePath || certFilePath.length() == 0) {
            throw new IllegalArgumentException("certFilePath must not be empty");
        }
        if (null == keyFilePath || keyFilePath.length() == 0) {
            throw new IllegalArgumentException("keyFilePath must not be empty");
        }
        FileInputStream certStream = new FileInputStream(certFilePath);
        try {
            X509ExtendedKeyManager x509ExtendedKeyManager;
            FileInputStream keyStream = new FileInputStream(keyFilePath);
            try {
                x509ExtendedKeyManager = KeyManagerHelper.createPEMKeyManager(certStream, keyStream);
            }
            catch (Throwable throwable) {
                ((InputStream)keyStream).close();
                throw throwable;
            }
            ((InputStream)keyStream).close();
            return x509ExtendedKeyManager;
        }
        finally {
            ((InputStream)certStream).close();
        }
    }

    public static X509ExtendedKeyManager createMSCAPIKeyManager(CallbackHandler callbackHandler, String certThumbprint) throws IOException, GeneralSecurityException {
        if (null == callbackHandler) {
            throw new IllegalArgumentException("callbackHandler must not be null");
        }
        if (null == certThumbprint || certThumbprint.length() == 0) {
            throw new IllegalArgumentException("certThumbprint must be a String containing hexadecimal digits");
        }
        KeyStore certKeyStore = KeyStoreFactory.createMSCAPIMyStore(callbackHandler);
        return new ThumbprintKeyManager(certKeyStore, certThumbprint);
    }

    public static X509ExtendedKeyManager createPKCS11KeyManager(CallbackHandler callbackHandler) throws IOException, GeneralSecurityException {
        if (null == callbackHandler) {
            throw new IllegalArgumentException("callbackHandler must not be null");
        }
        KeyStore certKeyStore = KeyStoreFactory.createPKCS11KeyStore(callbackHandler);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(certKeyStore, null);
        return KeyManagerHelper.getX509ExtendedKeyManager(kmf);
    }

    public static X509ExtendedKeyManager createJKSKeyManager(InputStream jksStream, char[] keyStorePassword, char[] entryPassword) throws IOException, GeneralSecurityException {
        if (null == jksStream) {
            throw new IllegalArgumentException("jksStream must not be null");
        }
        if (null == entryPassword) {
            throw new IllegalArgumentException("entryPassword must not be null");
        }
        KeyStore certKeyStore = KeyStoreFactory.createJKSKeyStore(jksStream, keyStorePassword);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(certKeyStore, entryPassword);
        return KeyManagerHelper.getX509ExtendedKeyManager(kmf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509ExtendedKeyManager createJKSKeyManager(String jksFilePath, char[] keyStorePassword, char[] entryPassword) throws IOException, GeneralSecurityException {
        if (null == jksFilePath || jksFilePath.length() == 0) {
            throw new IllegalArgumentException("jksFilePath must not be empty");
        }
        if (null == entryPassword) {
            throw new IllegalArgumentException("entryPassword must not be null");
        }
        FileInputStream jksStream = new FileInputStream(jksFilePath);
        try {
            X509ExtendedKeyManager x509ExtendedKeyManager = KeyManagerHelper.createJKSKeyManager(jksStream, keyStorePassword, entryPassword);
            return x509ExtendedKeyManager;
        }
        finally {
            ((InputStream)jksStream).close();
        }
    }

    public static X509ExtendedKeyManager createEmptyKeyManager() {
        return new EmptyX509ExtendedKeyManager();
    }

    static X509ExtendedKeyManager getX509ExtendedKeyManager(KeyManagerFactory factory) {
        for (KeyManager km : factory.getKeyManagers()) {
            if (!(km instanceof X509ExtendedKeyManager)) continue;
            return (X509ExtendedKeyManager)km;
        }
        return null;
    }
}

