/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.tls;

public final class SSLExtendedOptions {
    public static final String CIPHER_LIST_SEPARATOR_CHAR = " ";
    public static final String PROTOCOL_LIST_SEPARATOR_CHAR = " ";
    private boolean mutualTLS;
    private String[] enabledProtocols;
    private String[] enabledCipherSuites;

    public SSLExtendedOptions(boolean mutualTLS, String[] enabledCipherSuites, String[] enabledProtocols) {
        this.mutualTLS = mutualTLS;
        this.enabledCipherSuites = enabledCipherSuites;
        this.enabledProtocols = enabledProtocols;
    }

    public SSLExtendedOptions(boolean mutualTLS, String[] enabledCipherSuites) {
        this(mutualTLS, enabledCipherSuites, null);
    }

    public SSLExtendedOptions(boolean mutualTLS, String enabledCipherSuites, String enabledProtocols) {
        this.mutualTLS = mutualTLS;
        if (null != enabledCipherSuites) {
            this.enabledCipherSuites = enabledCipherSuites.length() == 0 ? new String[0] : enabledCipherSuites.split(" ");
        }
        if (null != enabledProtocols) {
            this.enabledProtocols = enabledProtocols.length() == 0 ? new String[0] : enabledProtocols.split(" ");
        }
    }

    public SSLExtendedOptions(boolean mutualTLS, String enabledCipherSuites) {
        this(mutualTLS, enabledCipherSuites, null);
    }

    public boolean isMutualTLS() {
        return this.mutualTLS;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }
}

