/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.tls;

import com.genesyslab.platform.commons.connection.tls.ThumbprintUtils;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;

public class ThumbprintKeyManager
extends X509ExtendedKeyManager {
    private static final ILogger log = Log.getLogger(ThumbprintKeyManager.class);
    private String certAlias;
    private X509Certificate[] certChain;
    private PrivateKey certKey;

    public ThumbprintKeyManager(KeyStore keyStore, String thumbprint) throws GeneralSecurityException {
        if (null == keyStore) {
            throw new IllegalArgumentException("keyStore is null");
        }
        if (null == thumbprint) {
            throw new IllegalArgumentException("thumbprint is null");
        }
        String trimmed = thumbprint.trim();
        if (trimmed.length() == 0) {
            throw new IllegalArgumentException("thumbprint is empty");
        }
        try {
            ThumbprintUtils.validateThumbprint(trimmed);
        }
        catch (IllegalArgumentException e) {
            throw new GeneralSecurityException("Invalid thumbprint", e);
        }
        byte[] binThumbprint = ThumbprintUtils.thumbprintToBytes(trimmed);
        MessageDigest sha1 = MessageDigest.getInstance("SHA1");
        Enumeration<String> e = keyStore.aliases();
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            Certificate cert = keyStore.getCertificate(alias);
            if (!this.checkCertificate(cert, binThumbprint, sha1)) continue;
            this.certAlias = alias;
            this.certChain = (X509Certificate[])keyStore.getCertificateChain(alias);
            this.certKey = (PrivateKey)keyStore.getKey(alias, null);
            break;
        }
        if (null == this.certAlias) {
            throw new GeneralSecurityException("Could not find certificate matching thumbprint: " + thumbprint);
        }
        log.debugFormat("KeyManager initialized. Certificate alias used: \"{0}\"", (Object)this.certAlias);
    }

    @Override
    public String[] getClientAliases(String s, Principal[] principals) {
        return new String[]{this.certAlias};
    }

    @Override
    public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
        return this.certAlias;
    }

    @Override
    public String[] getServerAliases(String s, Principal[] principals) {
        return new String[]{this.certAlias};
    }

    @Override
    public String chooseServerAlias(String s, Principal[] principals, Socket socket) {
        return this.certAlias;
    }

    @Override
    public X509Certificate[] getCertificateChain(String s) {
        return this.certChain;
    }

    @Override
    public PrivateKey getPrivateKey(String s) {
        return this.certKey;
    }

    @Override
    public String chooseEngineClientAlias(String[] strings, Principal[] principals, SSLEngine sslEngine) {
        return this.certAlias;
    }

    @Override
    public String chooseEngineServerAlias(String s, Principal[] principals, SSLEngine sslEngine) {
        return this.certAlias;
    }

    boolean checkCertificate(Certificate certificate, byte[] binThumbprint, MessageDigest sha1) {
        if (!(certificate instanceof X509Certificate)) {
            return false;
        }
        X509Certificate x509 = (X509Certificate)certificate;
        try {
            byte[] rawCert = x509.getEncoded();
            byte[] x509sha1 = sha1.digest(rawCert);
            return Arrays.equals(binThumbprint, x509sha1);
        }
        catch (CertificateEncodingException e) {
            return false;
        }
    }
}

