/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.collections.keyvaluebinding;

import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.collections.KeyValuePair;
import com.genesyslab.platform.commons.collections.Pair;
import com.genesyslab.platform.commons.collections.ValueType;
import com.genesyslab.platform.commons.collections.keyvaluebinding.Action;
import com.genesyslab.platform.commons.collections.keyvaluebinding.ActionsTable;
import com.genesyslab.platform.commons.collections.keyvaluebinding.UnmarshalContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class BindingEngine {
    private BindingEngine() {
    }

    public static UnmarshalContext unmarshal(KeyValueCollection col, ActionsTable actionsTable, UnmarshalContext ctx) {
        if (ctx == null) {
            return null;
        }
        ctx.setKvList(col);
        Iterator iter = col.iterator();
        while (iter.hasNext()) {
            boolean processed = false;
            Object obj = iter.next();
            if (obj == null || !(obj instanceof Pair)) continue;
            Pair pair = (Pair)obj;
            String key = pair.getStringKey();
            Object val = pair.getValueType() == ValueType.WIDE_STRING ? pair.getStringValue() : pair.getValue();
            ArrayList actions = actionsTable.get(key);
            if (actions != null) {
                for (Action action : actions) {
                    if (action == null || !action.checkConditions(key, val, ctx)) continue;
                    ctx = action.performAction(key, val, ctx);
                    processed = true;
                }
            }
            if (val instanceof KeyValueCollection && !ctx.getListProcessed()) {
                ctx = BindingEngine.unmarshal((KeyValueCollection)val, actionsTable, ctx);
                processed = ctx.isSomePairProcessed();
            }
            if (!processed) {
                for (Action action : actionsTable.getDefaultActions()) {
                    if (!action.checkConditions(key, val, ctx)) continue;
                    ctx = action.performAction(key, val, ctx);
                    processed = true;
                }
            }
            if (!processed) continue;
            ctx.setSomePairProcessed(true);
        }
        if (ctx.getParentContext() != null) {
            return ctx.getParentContext();
        }
        return ctx;
    }

    public static boolean marshal() {
        return true;
    }

    public static void addToDictionary(Object dictionary, String key, Object element) {
        if (dictionary instanceof KeyValueCollection) {
            KeyValueCollection kv = (KeyValueCollection)dictionary;
            kv.addObject(key, element);
        } else if (dictionary instanceof Map) {
            Map map = (Map)dictionary;
            map.put(key, element);
        } else {
            throw new IllegalStateException("Object is not a dictionary: " + dictionary.getClass());
        }
    }

    public static void marshalDictionary(KeyValueCollection kv, Object dictionary) {
        if (dictionary instanceof KeyValueCollection) {
            for (Object o : (KeyValueCollection)dictionary) {
                if (!(o instanceof KeyValuePair)) continue;
                kv.add(o);
            }
        } else if (dictionary instanceof Map) {
            for (Map.Entry entry : ((Map)kv).entrySet()) {
                kv.addObject(entry.getKey().toString(), entry.getValue());
            }
        } else {
            throw new IllegalStateException("Object is not a dictionary: " + dictionary.getClass());
        }
    }
}

