/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol;

import com.genesyslab.platform.commons.connection.ConnectionClosedEvent;
import com.genesyslab.platform.commons.connection.configuration.ConnectionConfiguration;
import com.genesyslab.platform.commons.connection.configuration.ConnectionContext;
import com.genesyslab.platform.commons.connection.configuration.ServerContext;
import com.genesyslab.platform.commons.connection.impl.BinaryStreamListening;
import com.genesyslab.platform.commons.connection.impl.IncomingBinaryMessageListener;
import com.genesyslab.platform.commons.connection.impl.OutcomingBinaryMessageListener;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.AsyncInvokerSupport;
import com.genesyslab.platform.commons.protocol.Channel;
import com.genesyslab.platform.commons.protocol.ChannelClosedEvent;
import com.genesyslab.platform.commons.protocol.ChannelClosedOnCloseException;
import com.genesyslab.platform.commons.protocol.ChannelClosedOnSendException;
import com.genesyslab.platform.commons.protocol.ChannelErrorEvent;
import com.genesyslab.platform.commons.protocol.ChannelListener;
import com.genesyslab.platform.commons.protocol.ChannelNotClosedException;
import com.genesyslab.platform.commons.protocol.ChannelNotOpenedException;
import com.genesyslab.platform.commons.protocol.ChannelOpenedEvent;
import com.genesyslab.platform.commons.protocol.ChannelState;
import com.genesyslab.platform.commons.protocol.ConfigurationSupport;
import com.genesyslab.platform.commons.protocol.ConnectionInvokerSupport;
import com.genesyslab.platform.commons.protocol.Endpoint;
import com.genesyslab.platform.commons.protocol.EndpointSupport;
import com.genesyslab.platform.commons.protocol.Listener;
import com.genesyslab.platform.commons.protocol.ListenerHelper;
import com.genesyslab.platform.commons.protocol.NoChannelEndpointException;
import com.genesyslab.platform.commons.protocol.WildcardEndpoint;
import com.genesyslab.platform.commons.protocol.runtime.AbstractContextImpl;
import com.genesyslab.platform.commons.threading.AsyncInvoker;
import com.genesyslab.platform.commons.threading.InvokerFactory;
import com.genesyslab.platform.commons.timer.TimerFactory;
import java.util.EventObject;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractChannel
implements Channel,
ConfigurationSupport,
EndpointSupport,
AsyncInvokerSupport,
ConnectionInvokerSupport {
    private static final ILogger log = Log.getLogger(AbstractChannel.class);
    private volatile ChannelState state = ChannelState.Closed;
    private volatile int stateMods;
    private volatile long timeout;
    private ListenerHelper listenerHelper = new ListenerHelper();
    private AsyncInvoker invoker;
    private static final String DEFAULT_INVOKER_NAME = "default";
    private final AtomicReference<AsyncInvoker> defInvoker = new AtomicReference();
    private Endpoint endpoint;
    private final int thisChannelId = AbstractChannel.generateChannelId();
    private final ChannelContextImpl context = new ChannelContextImpl(this);
    private final AsyncInvoker invokerRef = new AsyncInvoker(){

        public void invoke(Runnable task) {
            AsyncInvoker tmp = AbstractChannel.this.invoker;
            if (tmp == null) {
                tmp = AbstractChannel.this.getDefaultInvoker();
            }
            tmp.invoke(task);
        }

        public void dispose() {
            if (ChannelState.Closed.equals((Object)AbstractChannel.this.getState())) {
                AbstractChannel.this.releaseDefaultInvoker();
            }
        }
    };
    private BinaryStreamListening binaryStreamListening = new BinaryStreamListening(){
        private IncomingBinaryMessageListener incomingBinaryMessageListener;
        private OutcomingBinaryMessageListener outcomingBinaryMessageListener;

        public IncomingBinaryMessageListener getIncomingBinaryMessageListener() {
            return this.incomingBinaryMessageListener;
        }

        public OutcomingBinaryMessageListener getOutcomingBinaryMessageListener() {
            return this.outcomingBinaryMessageListener;
        }

        public void setIncomingBinaryMessageListener(IncomingBinaryMessageListener incomingBinaryMessageListener) {
            this.incomingBinaryMessageListener = incomingBinaryMessageListener;
        }

        public void setOutcomingBinaryMessageListener(OutcomingBinaryMessageListener outcomingBinaryMessageListener) {
            this.outcomingBinaryMessageListener = outcomingBinaryMessageListener;
        }
    };
    private static final AtomicInteger lastChannelId;

    protected AbstractChannel(long timeout, Endpoint endpoint) {
        this.timeout = timeout;
        try {
            this.endpoint = (Endpoint)(endpoint == null ? null : endpoint.clone());
        }
        catch (CloneNotSupportedException e) {
            this.endpoint = endpoint;
        }
        this.copyTLSSettings(endpoint);
    }

    protected String getEnpointPrefixInfo() {
        Endpoint endpoint = this.getEndpoint();
        if (endpoint == null) {
            return "";
        }
        String host = endpoint.getHost();
        if (endpoint instanceof WildcardEndpoint) {
            host = "[anylocal]";
        }
        return "[" + (endpoint.hasName() ? endpoint.getName() + "@" : "") + host + ":" + endpoint.getPort() + this.getLocalEndpointInfo(endpoint) + "] ";
    }

    protected String getLocalEndpointInfo(Endpoint endpoint) {
        return "";
    }

    public int getChannelId() {
        return this.thisChannelId;
    }

    public int getStateMods() {
        return this.stateMods;
    }

    @Override
    public ChannelState getState() {
        return this.state;
    }

    public ConnectionContext<? extends ServerContext> connectionContext() {
        return this.context;
    }

    public ServerContext getServerContext() {
        return this.context.serverContext();
    }

    @Override
    public void setTimeout(long timeout) {
        if (log.isDebug()) {
            log.debugFormat("Setting timeout to {0} ms.", (Object)timeout);
        }
        this.timeout = timeout;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public void addChannelListener(ChannelListener listener) {
        this.listenerHelper.addListener(listener);
    }

    @Override
    public void removeChannelListener(ChannelListener listener) {
        this.listenerHelper.removeListener(listener);
    }

    @Override
    public void setInvoker(AsyncInvoker invoker) {
        this.invoker = invoker;
        if (invoker != null) {
            this.releaseDefaultInvoker();
        }
    }

    @Override
    @Deprecated
    public void setConnectionInvoker(AsyncInvoker connectionInvoker) {
    }

    @Override
    @Deprecated
    public ConnectionConfiguration getConfiguration() {
        if (this.endpoint != null) {
            return this.endpoint.getConfiguration();
        }
        return null;
    }

    @Override
    @Deprecated
    public void configure(ConnectionConfiguration config) {
        this.setConfiguration(config);
        if (this.getState() == ChannelState.Opened) {
            this.applyConfiguration();
        }
    }

    @Override
    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    protected void onSetEndpoint(Endpoint endpoint) {
    }

    @Override
    public synchronized void setEndpoint(Endpoint endpoint) {
        this.throwNotClosed();
        this.onSetEndpoint(endpoint);
        try {
            this.endpoint = (Endpoint)(endpoint == null ? null : endpoint.clone());
        }
        catch (CloneNotSupportedException e) {
            this.endpoint = endpoint;
            log.errorFormat("Endpoint unsuport clone operation. {0}", (Object)endpoint);
        }
        this.copyTLSSettings(endpoint);
    }

    protected void copyTLSSettings(Endpoint endpoint) {
        if (null == endpoint) {
            this.context.setAttribute("com.genesyslab.platform.commons.connection.SSLContext", null);
            this.context.setAttribute("com.genesyslab.platform.commons.connection.SSLExtendedOptions", null);
        } else {
            this.context.setAttribute("com.genesyslab.platform.commons.connection.SSLContext", endpoint.getSSLContext());
            this.context.setAttribute("com.genesyslab.platform.commons.connection.SSLExtendedOptions", endpoint.getSSLOptions());
        }
    }

    protected void setState(ChannelState state) {
        this.setState(state, null);
    }

    protected synchronized void setState(ChannelState newState, ConnectionClosedEvent closedEvent) {
        if (newState == null || newState.equals((Object)this.state) || ChannelState.Closing.equals((Object)newState) && ChannelState.Closed.equals((Object)this.state)) {
            return;
        }
        if (log.isDebug()) {
            log.debug((Object)("Channel state transition[" + this.getEndpoint() + "]: " + (Object)((Object)this.state) + "->" + (Object)((Object)newState)));
        }
        if (newState == this.state) {
            return;
        }
        ChannelState prevState = this.state;
        this.state = newState;
        ++this.stateMods;
        if (newState == ChannelState.Closed) {
            Throwable cause = null;
            if (closedEvent != null) {
                cause = closedEvent.getCause();
            }
            ChannelClosedEvent event = this.createChannelClosedEvent(prevState, cause);
            if (closedEvent != null) {
                event.setUnsentBytes(closedEvent.getUnsentBytes());
            }
            this.fireClosed(event);
        } else if (newState == ChannelState.Opened) {
            this.fireOpened();
        }
    }

    protected ChannelClosedEvent createChannelClosedEvent(ChannelState prevState, Throwable cause) {
        return new ChannelClosedEvent((Channel)this, cause, prevState);
    }

    protected final void setServerContext(ServerContext serverContext) {
        this.context.setServerContext(serverContext);
    }

    public static int generateChannelId() {
        int channelId = lastChannelId.incrementAndGet();
        if (channelId != 0) {
            return channelId;
        }
        return lastChannelId.incrementAndGet();
    }

    protected void throwNull(Object o, String name) {
        if (o == null) {
            throw new IllegalArgumentException("Null pointer: '" + name);
        }
    }

    protected void throwNullEndpoint() {
        if (this.endpoint == null) {
            throw new IllegalStateException("Channel endpoint is null");
        }
    }

    protected void throwNotOpenedOnSend() throws ChannelClosedOnSendException {
        if (this.getState() != ChannelState.Opened) {
            throw new ChannelClosedOnSendException("Connection is not opened");
        }
    }

    protected void throwNotClosed() throws IllegalStateException {
        if (this.getState() != ChannelState.Closed) {
            throw new ChannelNotClosedException("Operation is not allowed on non closed channel");
        }
    }

    protected void throwNotOpened() throws IllegalStateException {
        if (this.getState() != ChannelState.Opened) {
            throw new ChannelNotOpenedException("Connection is not opened");
        }
    }

    protected void throwNotOpenedOnClose() throws IllegalStateException {
        if (this.getState() != ChannelState.Opened) {
            throw new ChannelClosedOnCloseException("Connection is not opened");
        }
    }

    private void fireOpened() {
        log.debug((Object)"Firing 'onChannelOpened'");
        ChannelOpenedEvent event = new ChannelOpenedEvent(this);
        this.getInvoker().invoke((Runnable)new ChanelOpenVisitor(event));
        this.onFireOpened(event);
    }

    private void fireClosed(ChannelClosedEvent event) {
        log.infoFormat("Channel closed: {0}", (Object)event);
        log.debug((Object)"Firing 'onChannelClosed'");
        this.getInvoker().invoke((Runnable)new ChanelClosedVisitor(event));
        this.onFireClosed(event);
        this.releaseDefaultInvoker();
    }

    protected void fireClosed(Throwable reason, ChannelState prevState) {
        if (log.isDebug()) {
            log.debug((Object)"Firing 'onChannelClosed'");
        }
        ChannelClosedEvent event = this.createChannelClosedEvent(prevState, reason);
        this.getInvoker().invoke((Runnable)new ChanelClosedVisitor(event));
        this.onFireClosed(event);
        this.releaseDefaultInvoker();
    }

    protected void onFireOpened(EventObject event) {
    }

    protected void onFireClosed(ChannelClosedEvent event) {
    }

    protected void onFireErrorEvent(ChannelErrorEvent event) {
    }

    protected ListenerHelper getListenerHelper() {
        return this.listenerHelper;
    }

    protected abstract void applyConfiguration();

    protected AsyncInvoker getInvoker() {
        return this.invokerRef;
    }

    protected AsyncInvoker getDefaultInvoker() {
        AsyncInvoker tmp = this.defInvoker.get();
        if (tmp == null && null != this.defInvoker.getAndSet(tmp = InvokerFactory.namedInvoker((String)DEFAULT_INVOKER_NAME))) {
            InvokerFactory.releaseInvoker((String)DEFAULT_INVOKER_NAME);
        }
        return tmp;
    }

    protected void releaseDefaultInvoker() {
        if (null != this.defInvoker.getAndSet(null)) {
            InvokerFactory.releaseInvoker((String)DEFAULT_INVOKER_NAME);
        }
    }

    protected void setConfiguration(ConnectionConfiguration config) {
        if (this.endpoint == null) {
            throw new NoChannelEndpointException("The Channel does not have Endpoint instance initialized");
        }
        this.endpoint.setConfiguration(config);
    }

    protected void fireErrorEvent(Throwable exception) {
        ChannelErrorEvent event = new ChannelErrorEvent(this, exception);
        this.fireErrorEvent(event);
    }

    protected void fireErrorEvent(ChannelErrorEvent event) {
        this.throwNull(event, "event");
        this.getInvoker().invoke((Runnable)new AsyncErrorNotifier(event));
        this.onFireErrorEvent(event);
    }

    protected final <T> T internal(Object internal) {
        if (internal == BinaryStreamListening.class) {
            return (T)this.binaryStreamListening;
        }
        throw new UnsupportedOperationException("unknown internal: " + internal);
    }

    static {
        TimerFactory.getTimer();
        lastChannelId = new AtomicInteger(Math.abs((int)System.currentTimeMillis()));
    }

    protected class AsyncErrorNotifier
    extends AsyncVisitor {
        private ChannelErrorEvent event;

        public AsyncErrorNotifier(ChannelErrorEvent event) {
            this.event = event;
        }

        public AsyncErrorNotifier(Throwable error) {
            this.event = new ChannelErrorEvent(AbstractChannel.this, error);
        }

        @Override
        public void visitListener(Listener listener) {
            ((ChannelListener)listener).onChannelError(this.event);
        }
    }

    private class ChanelClosedVisitor
    extends AsyncVisitor {
        private ChannelClosedEvent event;

        public ChanelClosedVisitor(ChannelClosedEvent event) {
            this.event = event;
        }

        @Override
        public void visitListener(Listener listener) {
            ChannelListener chL = (ChannelListener)listener;
            chL.onChannelClosed(this.event);
        }
    }

    private class ChanelOpenVisitor
    extends AsyncVisitor {
        private EventObject event;

        public ChanelOpenVisitor(EventObject event) {
            this.event = event;
        }

        @Override
        public void visitListener(Listener listener) {
            ChannelListener chL = (ChannelListener)listener;
            chL.onChannelOpened(this.event);
        }
    }

    private abstract class AsyncVisitor
    implements ListenerHelper.NotificationVisitor,
    Runnable {
        final Runnable notification;

        private AsyncVisitor() {
            this.notification = AbstractChannel.this.listenerHelper.createNotificationTask(this);
        }

        @Override
        public void run() {
            this.notification.run();
        }
    }

    private static class ChannelContextImpl
    extends AbstractContextImpl<ServerContext> {
        private ServerContext serverContext = null;

        public ChannelContextImpl(AbstractChannel channel) {
            super(channel);
        }

        @Override
        public ServerContext serverContext() {
            return this.serverContext;
        }

        private void setServerContext(ServerContext newServerContext) {
            this.serverContext = newServerContext;
        }
    }
}

