/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol;

import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.ChannelClosedEvent;
import com.genesyslab.platform.commons.protocol.ChannelErrorEvent;
import com.genesyslab.platform.commons.protocol.ReceiverSupport;
import com.genesyslab.platform.commons.protocol.runtime.channel.GrowingBlockingQueue;
import com.genesyslab.platform.commons.protocol.runtime.channel.QueueSupport;
import java.util.EventObject;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public abstract class AbstractQueueReceiver<T>
implements ReceiverSupport {
    private static final ILogger log = Log.getLogger(AbstractQueueReceiver.class);
    private QueueSupport<T> qSupport;
    private long enqueTimeout = 0L;

    protected AbstractQueueReceiver(int queueSize, T fake, boolean growQueue) {
        this.qSupport = new QueueSupport<T>(new GrowingBlockingQueue<T>(new LinkedBlockingQueue(queueSize)){

            @Override
            public BlockingQueue<T> createQueue(int capacity) {
                return new LinkedBlockingQueue(capacity);
            }
        }, fake);
        if (growQueue) {
            this.qSupport.setOverflowHandler(new GrowQueueHandler());
        }
    }

    protected AbstractQueueReceiver(int queueSize, T fake) {
        this(queueSize, fake, false);
    }

    protected AbstractQueueReceiver(LinkedBlockingQueue<T> queue, T fake) {
        this.qSupport = new QueueSupport<T>(queue, fake);
    }

    public long getEnqueTimeout() {
        return this.enqueTimeout;
    }

    public void setEnqueTimeout(long enqueTimeout) {
        this.enqueTimeout = enqueTimeout;
    }

    @Override
    public int getInputSize() {
        return this.qSupport.getCapacity();
    }

    @Override
    public void setInputSize(int inputSize) {
        this.qSupport.setCapacity(inputSize);
    }

    public int getMaxInputSize() {
        return this.qSupport.getMaxCapacity();
    }

    public void setMaxInputSize(int maxInputSize) {
        this.qSupport.setMaxCapacity(maxInputSize);
    }

    @Override
    public void clearInput() {
        this.qSupport.drainQueue();
    }

    @Override
    public void onChannelOpened(EventObject event) {
    }

    @Override
    public void onChannelClosed(ChannelClosedEvent event) {
        this.releaseReceivers();
    }

    @Override
    public void onChannelError(ChannelErrorEvent event) {
    }

    @Override
    public void releaseReceivers() {
        this.qSupport.releaseReceivers();
    }

    protected QueueSupport<T> getQueueSupport() {
        return this.qSupport;
    }

    public T receive() throws InterruptedException, IllegalStateException {
        return this.receive(-1L);
    }

    public T receive(long timeout) throws InterruptedException, IllegalStateException {
        QueueSupport<T> qSupport = this.getQueueSupport();
        T msg = qSupport.dequeObject(timeout);
        if (msg == this.getFake()) {
            msg = null;
        }
        return msg;
    }

    public void processMessage(T message) {
        QueueSupport<T> qSupport = this.getQueueSupport();
        qSupport.enqueObject(message, this.enqueTimeout);
    }

    protected abstract Object getFake();

    private class GrowQueueHandler
    implements QueueSupport.QueueOverflowHandler<T> {
        private GrowQueueHandler() {
        }

        @Override
        public void handleOverflow(T obj) throws InterruptedException {
            log.warn((Object)"Queue overflow, trying to increase queue size");
            AbstractQueueReceiver.this.qSupport.growQueue(obj);
        }
    }
}

