/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol;

import com.genesyslab.platform.commons.connection.ConnectionClosedEvent;
import com.genesyslab.platform.commons.connection.resolver.SocketAddressResolver;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.ChannelClosedEvent;
import com.genesyslab.platform.commons.protocol.ChannelClosedOnRequestException;
import com.genesyslab.platform.commons.protocol.ChannelClosedOnSendException;
import com.genesyslab.platform.commons.protocol.ChannelNotClosedException;
import com.genesyslab.platform.commons.protocol.ChannelNotOpenedException;
import com.genesyslab.platform.commons.protocol.ChannelOpenedEvent;
import com.genesyslab.platform.commons.protocol.ChannelState;
import com.genesyslab.platform.commons.protocol.ClientChannelManager;
import com.genesyslab.platform.commons.protocol.ConnectionOperations;
import com.genesyslab.platform.commons.protocol.DisabledMethodException;
import com.genesyslab.platform.commons.protocol.DuplexChannel;
import com.genesyslab.platform.commons.protocol.Endpoint;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.MessageCorrelator;
import com.genesyslab.platform.commons.protocol.MessageFilter;
import com.genesyslab.platform.commons.protocol.Protocol;
import com.genesyslab.platform.commons.protocol.ProtocolException;
import com.genesyslab.platform.commons.protocol.ProtocolFactory;
import com.genesyslab.platform.commons.protocol.ProtocolSecurityException;
import com.genesyslab.platform.commons.protocol.ProtocolTimeoutException;
import com.genesyslab.platform.commons.protocol.ReferenceBuilder;
import com.genesyslab.platform.commons.protocol.Referenceable;
import com.genesyslab.platform.commons.protocol.RegistrationException;
import com.genesyslab.platform.commons.protocol.RegistrationTimeoutException;
import com.genesyslab.platform.commons.protocol.RequestFuture;
import com.genesyslab.platform.commons.protocol.RequestUnReferenceableException;
import com.genesyslab.platform.commons.threading.AsyncInvoker;
import com.genesyslab.platform.commons.threading.CompletionHandler;
import com.genesyslab.platform.commons.util.CallstackUtils;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class ClientChannel
extends DuplexChannel
implements Protocol {
    private static final ILogger log = Log.getLogger(ClientChannel.class);
    private final ReferenceBuilder refBuilder;
    private MessageCorrelator correlator;
    private boolean copyResponse = false;
    private RegistrationHandler regHandler;
    private volatile ClientHandshakeStep handshakeState = null;
    private Throwable handshakeException = null;
    private volatile boolean registering = false;
    private final LinkedBlockingQueue<Object> regUnsolicitedEventsIn = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<Message> regUnsolicitedEventsOut = new LinkedBlockingQueue();
    private boolean deliverMessagesWhileHandshake = false;
    private final AtomicBoolean disableConnectionOperations = new AtomicBoolean();
    private volatile long openTimeout;
    private volatile boolean hasHandshake = false;

    public ClientChannel(Endpoint endpoint, ProtocolFactory protocolFactory, ReferenceBuilder refBuilder, long timeout) {
        super(endpoint, protocolFactory, timeout);
        this.refBuilder = refBuilder;
        this.manager = ClientChannelManager.createManager(this);
        this.manager.initialize();
    }

    public ClientChannel(Endpoint endpoint, ProtocolFactory protocolFactory, ReferenceBuilder refBuilder) {
        this(endpoint, protocolFactory, refBuilder, 30000L);
    }

    @Override
    public Message request(Message message) throws ProtocolException, IllegalStateException {
        return this.request(message, this.getTimeout());
    }

    @Override
    public Message request(Message message, long timeout) throws ProtocolException {
        this.throwNull(message, "message");
        this.throwNotOpenedOnSend();
        return this.doRequest(message, timeout);
    }

    @Override
    public RequestFuture beginRequest(Message message) throws ProtocolException {
        this.throwNotOpenedOnSend();
        this.throwOnUnReferenceableRequest(message);
        return (RequestFuture)((Object)this.doBeginRequest(message, null, null, this.getTimeout()));
    }

    @Override
    public <A> void requestAsync(Message message, A attachment, CompletionHandler<Message, ? super A> handler) throws ProtocolException {
        this.requestAsync(message, attachment, handler, this.getTimeout());
    }

    @Override
    public <A> void requestAsync(Message request, A attachment, CompletionHandler<Message, ? super A> handler, long timeout) throws ProtocolException, IllegalStateException {
        this.throwNotOpenedOnSend();
        this.throwOnUnReferenceableRequest(request);
        this.doBeginRequest(request, attachment, handler, timeout);
    }

    @Override
    public Message endRequest(RequestFuture future) throws ProtocolException {
        return this.endRequest(future, 30000L);
    }

    @Override
    public Message endRequest(RequestFuture future, long timeout) throws ProtocolException {
        if (future == null) {
            return null;
        }
        if (future instanceof MessageCorrelator.MessageEntry) {
            return this.doEndRequest((MessageCorrelator.MessageEntry)((Object)future), timeout);
        }
        throw new IllegalArgumentException("Wrong future argument, only futures from beginRequest are supported");
    }

    @Override
    protected synchronized void setState(ChannelState newState, ConnectionClosedEvent closedEvent) {
        ChannelState oldState = this.getState();
        if (newState == null || newState.equals((Object)oldState) || ChannelState.Closing.equals((Object)newState) && ChannelState.Closed.equals((Object)oldState)) {
            return;
        }
        super.setState(newState, closedEvent);
        if (newState == ChannelState.Opened) {
            if (!this.manager.isRegistered()) {
                this.manager.register();
            }
        } else if (newState == ChannelState.Closed) {
            MessageCorrelator correlator = this.correlator;
            if (correlator != null) {
                correlator.releaseWaiters(closedEvent);
                this.releaseDefaultInvoker();
            }
            if (this.registering && this.regHandler != null) {
                this.regUnsolicitedEventsIn.add(closedEvent);
            }
            this.setHandshakeFinished(closedEvent != null ? closedEvent.getCause() : null);
            this.manager.unregister();
        }
    }

    @Deprecated
    protected final MessageCorrelator.MessageEntry doBeginRequest(Message message) throws ProtocolException {
        return this.doBeginRequest(message, null, null, -1L);
    }

    protected final <A> MessageCorrelator.MessageEntry doBeginRequest(Message message, A attachment, CompletionHandler<Message, ? super A> handler, long timeout) throws ProtocolException {
        int initialStateMods = this.getStateMods();
        if (message == null) {
            throw new NullPointerException("message");
        }
        if (this.correlator == null) {
            throw new ChannelNotOpenedException("Connection is not opened (no correlator initialized)");
        }
        if (handler != null && timeout <= 0L) {
            throw new IllegalArgumentException("Request completion handler requires positive timeout value");
        }
        if (!this.isMessageAllowed(message)) {
            return null;
        }
        this.ensureReference(message);
        MessageCorrelator.MessageEntry entry = this.correlator.registerMessage(message, attachment, handler, this.getInvoker(), timeout, initialStateMods);
        try {
            int actualStateMods = this.getStateMods();
            if (initialStateMods != actualStateMods && (this.getState() != ChannelState.Opened || initialStateMods - actualStateMods != 1)) {
                throw new ChannelClosedOnSendException(this.getEnpointPrefixInfo() + "Channel state had changed before the message was sent.", null);
            }
            this.doSend(message);
        }
        catch (ProtocolException ex) {
            this.releaseCorrelationEntry(entry, (Throwable)((Object)ex));
            throw ex;
        }
        catch (RuntimeException ex) {
            this.releaseCorrelationEntry(entry, ex);
            throw ex;
        }
        catch (Error ex) {
            this.releaseCorrelationEntry(entry, ex);
            throw ex;
        }
        return entry;
    }

    private void releaseCorrelationEntry(MessageCorrelator.MessageEntry entry, Throwable ex) {
        if (entry != null) {
            this.correlator.unregisterEntry(entry, ex);
        }
        if (ChannelState.Closed.equals((Object)this.getState())) {
            this.releaseDefaultInvoker();
        }
    }

    protected Message doRequest(Message message, long timeout) throws ProtocolException {
        MessageFilter filter = this.messageFilter;
        if (log.isDebug() && (filter == null || filter.canTrace())) {
            log.debug((Object)("Requesting with " + message.messageName()));
        }
        MessageCorrelator.MessageEntry entry = this.doBeginRequest(message, null, null, -1L);
        return this.doEndRequest(entry, timeout);
    }

    private Message doEndRequest(MessageCorrelator.MessageEntry entry, long timeout) throws ProtocolException {
        int actualStateMods;
        Throwable ex;
        if (entry == null) {
            return null;
        }
        MessageFilter filter = this.messageFilter;
        if (log.isDebug() && (filter == null || filter.canTrace())) {
            log.debug((Object)("Waiting for response. " + entry.toString()));
        }
        Message response = this.correlator.waitResponse(entry, timeout);
        ChannelState chState = this.getState();
        if (response == null && ((ex = entry.getFailureReason()) != null || chState == ChannelState.Closed)) {
            throw new ChannelClosedOnRequestException(this.getEnpointPrefixInfo() + "Got no response message because channel has been closed", ex);
        }
        int expectedStateMods = entry.getInitialStateMods();
        if (expectedStateMods != (actualStateMods = this.getStateMods()) && (chState != ChannelState.Opened || expectedStateMods - actualStateMods != 1)) {
            throw new ChannelClosedOnRequestException(this.getEnpointPrefixInfo() + "Got no response message because channel state has been changed", null);
        }
        if (log.isDebug()) {
            if (response == null) {
                log.debug((Object)"Response is null, channel is closing?");
            } else if (log.isDebug() && (filter == null || filter.canTrace())) {
                log.debug((Object)("Got response, id: " + response.messageId()));
            }
        }
        return response;
    }

    @Override
    public boolean getCopyResponse() {
        return this.copyResponse;
    }

    @Override
    public void setCopyResponse(boolean copyResponse) {
        this.copyResponse = copyResponse;
    }

    @Deprecated
    public void setHandshakeUnsolicitedEventsPassLimit(int maxNum) {
    }

    protected void onUnexpectedHandshakeMessage(Message request, Message response, Queue<Message> msgsBuffer) throws ProtocolException {
        if (!this.deliverMessagesWhileHandshake) {
            log.debug((Object)"Protocol has got too many unaccepted unsolicited messages during handshake procedure");
            throw new RegistrationException(this.getEnpointPrefixInfo() + "Received unsolicited message", response);
        }
        super.onReceiveMessage(response);
    }

    @Override
    public ReferenceBuilder getReferenceBuilder() {
        return this.refBuilder;
    }

    protected void throwOnUnReferenceableRequest(Message request) {
        if (request == null) {
            throw new IllegalArgumentException("Request message is null");
        }
        if (!(request instanceof Referenceable)) {
            throw new RequestUnReferenceableException("Request message is not Referenceable");
        }
    }

    @Override
    public synchronized void setEndpoint(Endpoint endpoint) {
        this.checkDisabledConnectionOperations();
        this.doSetEndpoint(endpoint);
    }

    private void doSetEndpoint(Endpoint endpoint) {
        super.setEndpoint(endpoint);
    }

    public void setAddressResolver(SocketAddressResolver resolver) throws ChannelNotClosedException {
        this.throwNotClosed();
        this.connectionContext().setAttribute("dns-resolver", (Object)resolver);
    }

    public void setAddressResolverParams(String parameters) throws ProtocolSecurityException, IllegalArgumentException {
        if (parameters == null) {
            throw new IllegalArgumentException("Null custom address resolver parameters");
        }
        String params = parameters.replaceAll("\n", "").replaceAll("\r", "").trim();
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        if (!params.isEmpty()) {
            for (String opt : params.split(";")) {
                int pos = opt.indexOf(61);
                if (pos <= 0) {
                    throw new IllegalArgumentException("Invalid Custom DNS Resolver param declaration: '" + opt + "'");
                }
                String optName = opt.substring(0, pos).trim();
                paramsMap.put(optName, opt.substring(pos + 1).trim());
            }
        }
        this.setAddressResolverParams(paramsMap);
    }

    public void setAddressResolverParams(Map<String, Object> parameters) throws ChannelNotClosedException, ProtocolSecurityException, IllegalArgumentException {
        this.throwNotClosed();
        if (parameters == null) {
            throw new IllegalArgumentException("Null Custom DNS Resolver parameters");
        }
        Object param = parameters.get("dns-resolver");
        if (param == null && (param = parameters.get("dns-resolver-class")) != null) {
            if (!(param instanceof String)) {
                throw new IllegalArgumentException("Custom DNS parameters contain wrong type of 'dns-resolver-class'");
            }
            if (!((String)param).isEmpty()) {
                Class<?> clazz;
                try {
                    clazz = Class.forName((String)param);
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Failed to get Custom DNS resolver class " + param, ex);
                }
                try {
                    param = clazz.newInstance();
                }
                catch (Exception ex) {
                    throw new ProtocolSecurityException("Failed to initialize external DNS resolver " + param, ex);
                }
            }
            param = null;
        }
        if (param instanceof SocketAddressResolver) {
            if (this.connectionContext().getAttribute("dns-resolver") != null) {
                log.warnFormat("Overriding AddressResolver instance to {0}", (Object)param.getClass().getName());
            }
            this.connectionContext().setAttribute("dns-resolver", param);
        } else if (param != null) {
            throw new IllegalArgumentException("Wrong DNS resolver FQCN provided: " + param.getClass().getName() + " (must implement SocketAddressResolver interface)");
        }
        this.connectionContext().setAttribute("dns-resolver-params", new HashMap<String, Object>(parameters));
    }

    @Override
    public synchronized void open(long timeout) throws RegistrationException, ProtocolException, ChannelNotClosedException, InterruptedException {
        this.checkDisabledConnectionOperations();
        this.doOpen(timeout);
    }

    private void doOpen(long timeout) throws ProtocolException, InterruptedException {
        this.openTimeout = timeout;
        super.open(timeout);
        if (this.registering) {
            while (this.registering) {
                this.wait();
            }
            if (this.handshakeException != null) {
                if (this.handshakeException instanceof ProtocolException) {
                    CallstackUtils.upgradeCallstack((Throwable)this.handshakeException);
                    throw (ProtocolException)((Object)this.handshakeException);
                }
                if (this.handshakeException instanceof Error) {
                    CallstackUtils.upgradeCallstack((Throwable)this.handshakeException);
                    throw (Error)this.handshakeException;
                }
                RegistrationException ex = new RegistrationException(this.getEnpointPrefixInfo() + "Exception while handshake", this.handshakeException);
                log.error((Object)"Channel open failed", (Throwable)((Object)ex));
                throw ex;
            }
        }
    }

    @Override
    public synchronized void beginOpen() throws ProtocolException {
        this.checkDisabledConnectionOperations();
        this.doOpenAsync(this.getTimeout());
    }

    @Override
    public synchronized Future<ChannelOpenedEvent> openAsync(Long timeout) {
        this.checkDisabledConnectionOperations();
        return this.doOpenAsync(timeout != null ? timeout.longValue() : this.getTimeout());
    }

    private Future<ChannelOpenedEvent> doOpenAsync(long timeout) {
        this.openTimeout = timeout;
        return super.openAsync(timeout);
    }

    @Override
    public synchronized <A> void openAsync(long timeout, CompletionHandler<EventObject, A> handler, A attachment) {
        this.checkDisabledConnectionOperations();
        this.openTimeout = timeout;
        super.openAsync(timeout, handler, attachment);
    }

    @Override
    public void close(boolean force) throws ProtocolException, InterruptedException, IllegalStateException {
        this.checkDisabledConnectionOperations();
        super.close(force);
    }

    @Override
    public void close(long timeout) throws ProtocolException, InterruptedException, IllegalStateException {
        this.checkDisabledConnectionOperations();
        super.close(timeout);
    }

    @Override
    public void beginClose() throws IllegalStateException {
        this.checkDisabledConnectionOperations();
        super.beginClose();
    }

    @Override
    public synchronized <A> void closeAsync(long timeout, CompletionHandler<ChannelClosedEvent, A> handler, A attachment) {
        this.checkDisabledConnectionOperations();
        super.closeAsync(timeout, handler, attachment);
    }

    @Override
    public synchronized Future<ChannelClosedEvent> closeAsync() {
        this.checkDisabledConnectionOperations();
        return this.doCloseAsync();
    }

    private Future<ChannelClosedEvent> doCloseAsync() {
        return super.closeAsync();
    }

    private void checkDisabledConnectionOperations() {
        if (this.disableConnectionOperations.get()) {
            this.throwDisabledMethodException();
        }
    }

    private void throwDisabledMethodException() {
        throw new DisabledMethodException("Connection operations has been disabled. Do not use it directly.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onOpen() throws ProtocolException {
        this.correlator = new MessageCorrelator(this.refBuilder);
        try {
            this.processRegistration();
            try {
                boolean handshaking;
                boolean bl = handshaking = this.handshakeState != null;
                if (handshaking) {
                    this.handshakeState = this.handshakeState.initState();
                }
                if (this.handshakeState == null) {
                    super.onOpen();
                    if (handshaking) {
                        this.setHandshakeFinished(null);
                    }
                }
            }
            finally {
                this.finalyzeRegistration();
            }
        }
        finally {
            if (this.registering) {
                this.finalyzeRegistration();
            }
        }
    }

    @Override
    protected void onSend(Message message) throws ProtocolException {
        this.ensureReference(message);
        super.onSend(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onReceiveMessage(Message msg) {
        ClientChannel clientChannel;
        boolean awaited = false;
        if (this.correlator != null) {
            boolean bl = awaited = this.correlator.correlate(msg) != null;
        }
        if (this.handshakeState != null) {
            clientChannel = this;
            synchronized (clientChannel) {
                if (this.registering && this.handshakeState != null) {
                    try {
                        this.handshakeState = this.handshakeState.handleMessage(msg);
                        if (this.handshakeState == null) {
                            super.onOpen();
                            this.finalyzeHandshake();
                        }
                    }
                    catch (Throwable e) {
                        if (log.isError()) {
                            log.error((Object)"Failed to complete open process", e);
                        }
                        this.processCloseAll(this.createConnectionClosedEvent(e));
                    }
                    return;
                }
            }
        }
        if (!awaited && this.registering) {
            clientChannel = this;
            synchronized (clientChannel) {
                if (this.registering) {
                    this.regUnsolicitedEventsIn.add(msg);
                }
            }
        }
        if (!(this.registering || awaited && !this.copyResponse)) {
            super.onReceiveMessage(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected void setRegistrationHandler(RegistrationHandler handler) {
        ClientChannel clientChannel = this;
        synchronized (clientChannel) {
            this.regHandler = handler;
            this.registering = this.regHandler != null;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setHandshakePhase(ClientHandshakeStep handshakeStart) {
        ClientChannel clientChannel = this;
        synchronized (clientChannel) {
            boolean doHandshake;
            if (handshakeStart != null) {
                this.hasHandshake = true;
            }
            this.handshakeState = handshakeStart;
            this.handshakeException = null;
            this.registering = doHandshake = this.handshakeState != null;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setHandshakeFinished(Throwable exception) {
        ClientChannel clientChannel = this;
        synchronized (clientChannel) {
            if (this.registering) {
                this.cancelOpenTimeout();
                this.handshakeState = null;
                this.handshakeException = exception;
                this.registering = false;
                this.notifyAll();
            }
        }
    }

    private void ensureReference(Message message) {
        if (!(message instanceof Referenceable)) {
            return;
        }
        if (this.refBuilder.retreiveReference(message) == null) {
            Object reference = this.refBuilder.updateReference(message);
            log.debugFormat("Message got new reference: {0}", reference);
        }
    }

    private void processRegistration() throws ProtocolException {
        this.regUnsolicitedEventsIn.clear();
        this.regUnsolicitedEventsOut.clear();
        if (this.regHandler != null) {
            log.debug((Object)"Starting registration...");
            try {
                Message regMessage = this.regHandler.getRegistrationMessage();
                Message response = this.submitRegMessage(regMessage);
                while (true) {
                    if (!this.regHandler.handleResponse(response)) {
                        if (response != null) {
                            boolean isRequestReferenced = false;
                            if (regMessage instanceof Referenceable && response instanceof Referenceable) {
                                Object refReq = ((Referenceable)((Object)regMessage)).retreiveReference();
                                Object refResp = ((Referenceable)((Object)response)).retreiveReference();
                                boolean bl = isRequestReferenced = refReq != null && refReq.equals(refResp);
                            }
                            if (isRequestReferenced) {
                                log.debug((Object)"Response is not accepted, registration failed, closing channel");
                                throw new RegistrationException("Client registration failed", response);
                            }
                            this.onUnexpectedHandshakeMessage(regMessage, response, this.regUnsolicitedEventsOut);
                            response = this.submitRegMessage(null);
                            continue;
                        }
                    } else if (!this.regHandler.isRegistrationComplete()) {
                        regMessage = this.regHandler.getRegistrationMessage();
                        response = this.submitRegMessage(regMessage);
                        continue;
                    }
                    break;
                }
            }
            catch (ProtocolException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ProtocolException("Exception while registering", e);
            }
        }
    }

    private void finalyzeRegistration() throws ProtocolException {
        if (this.regHandler != null && this.registering) {
            log.debug((Object)"Finalizing registration...");
            try {
                this.fireUnsolicitedEvents();
                while (!this.regUnsolicitedEventsIn.isEmpty()) {
                    Object ev = this.regUnsolicitedEventsIn.poll();
                    if (ev instanceof Message) {
                        super.onReceiveMessage((Message)ev);
                        continue;
                    }
                    if (ev instanceof ConnectionClosedEvent) {
                        throw new ProtocolException("Problems during registration", ((ConnectionClosedEvent)ev).getCause());
                    }
                    if (ev == null) continue;
                    log.warnFormat("Unexpected event during handshake procedure: {0}", ev);
                }
            }
            catch (ProtocolException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ProtocolException("Exception while registering", e);
            }
            finally {
                this.registering = false;
                this.notifyAll();
            }
        }
    }

    private void finalyzeHandshake() throws ProtocolException {
        if (this.registering) {
            log.debug((Object)"Finalizing handshake...");
            try {
                this.fireUnsolicitedEvents();
            }
            catch (Exception e) {
                RegistrationException ex = new RegistrationException(this.getEnpointPrefixInfo() + "Exception on handshake finalization", e);
                log.error((Object)"", (Throwable)((Object)ex));
                throw ex;
            }
            finally {
                this.registering = false;
                this.notifyAll();
            }
        }
    }

    public void fireUnsolicitedEvents() {
        while (!this.regUnsolicitedEventsOut.isEmpty()) {
            super.onReceiveMessage(this.regUnsolicitedEventsOut.poll());
        }
    }

    @Deprecated
    protected Message submitRegMessage(Message regMessage) throws ProtocolException, InterruptedException {
        Message response;
        long timeout = this.getTimeout();
        if (regMessage instanceof Referenceable) {
            response = this.doRequest(regMessage, timeout);
        } else {
            Object obj;
            if (regMessage != null) {
                this.doSend(regMessage);
            }
            if ((obj = timeout < 0L ? this.regUnsolicitedEventsIn.take() : this.regUnsolicitedEventsIn.poll(timeout, TimeUnit.MILLISECONDS)) == null) {
                throw this.getTimeoutException("register client", timeout);
            }
            if (obj instanceof ConnectionClosedEvent) {
                throw new ProtocolException("Problems during registration", ((ConnectionClosedEvent)obj).getCause());
            }
            response = (Message)obj;
        }
        return response;
    }

    private boolean hasHandshake() {
        return this.hasHandshake;
    }

    @Override
    protected ProtocolException getOpenTimeoutException(long timeout) {
        boolean hasHandshake = this.hasHandshake();
        String msg = this.getEnpointPrefixInfo() + (hasHandshake ? "Handshake timeout (" + timeout + " ms)" : "Timeout on channel (" + timeout + " ms). Operation: open");
        ProtocolException ex = hasHandshake ? new RegistrationTimeoutException(msg, null) : new ProtocolTimeoutException(msg, null);
        log.error((Object)"Channel open timeout", (Throwable)((Object)ex));
        return ex;
    }

    public ConnectionOperations disableConnectionOperations() {
        if (!this.disableConnectionOperations.compareAndSet(false, true)) {
            throw new DisabledMethodException("Can't get exclusive access to channels's connection operations.");
        }
        return new ConnectionOperations(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Future<ChannelOpenedEvent> openAsync(Endpoint endpoint, Long timeout) {
                ClientChannel clientChannel = ClientChannel.this;
                synchronized (clientChannel) {
                    if (endpoint != null) {
                        ClientChannel.this.doSetEndpoint(endpoint);
                    }
                    return ClientChannel.this.doOpenAsync(timeout == null ? ClientChannel.this.getTimeout() : timeout.longValue());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Future<ChannelClosedEvent> closeAsync() {
                ClientChannel clientChannel = ClientChannel.this;
                synchronized (clientChannel) {
                    return ClientChannel.this.doCloseAsync();
                }
            }
        };
    }

    @Override
    @Deprecated
    public AsyncInvoker getInvoker() {
        return super.getInvoker();
    }

    protected abstract class BasicClientHandshakeStep
    implements ClientHandshakeStep {
        protected final ILogger log = Log.getLogger(this.getClass());
        protected Message theRequest = null;
        protected Object theRequestRefId = null;

        protected BasicClientHandshakeStep() {
        }

        @Override
        public ClientHandshakeStep initState() throws ProtocolException {
            this.log.debug((Object)"BasicClientHandshakeStep.initState()");
            this.theRequest = this.getRegistrationRequest();
            ClientChannel.this.doSend(this.theRequest);
            this.theRequestRefId = this.theRequest instanceof Referenceable ? ((Referenceable)((Object)this.theRequest)).retreiveReference() : null;
            return this;
        }

        protected boolean checkReferenceId(Message event) {
            if (this.theRequestRefId != null) {
                Object refId = null;
                if (event instanceof Referenceable) {
                    refId = ((Referenceable)((Object)event)).retreiveReference();
                }
                return this.theRequestRefId.equals(refId);
            }
            return true;
        }

        protected ClientHandshakeStep passEventThrough(Message event) throws ProtocolException {
            ClientChannel.this.onUnexpectedHandshakeMessage(this.theRequest, event, ClientChannel.this.regUnsolicitedEventsOut);
            return this;
        }

        protected ClientHandshakeStep passEventDirectly(Message event) {
            ClientChannel.this.regUnsolicitedEventsOut.add(event);
            return this;
        }

        protected ClientHandshakeStep gotoNextStep() throws ProtocolException {
            ClientHandshakeStep nextStep = this.getNextStep();
            if (nextStep != null) {
                return nextStep.initState();
            }
            return null;
        }

        protected ClientHandshakeStep getNextStep() {
            return null;
        }
    }

    protected static interface ClientHandshakeStep {
        public ClientHandshakeStep initState() throws ProtocolException;

        public Message getRegistrationRequest() throws ProtocolException;

        public ClientHandshakeStep handleMessage(Message var1) throws ProtocolException;
    }

    @Deprecated
    protected abstract class SimpleRegistrationHandler
    implements RegistrationHandler {
        private boolean regComplete = false;

        protected SimpleRegistrationHandler() {
        }

        protected abstract boolean isResponseAccepted(Message var1) throws RegistrationException;

        @Override
        public abstract Message getRegistrationMessage();

        @Override
        public boolean handleResponse(Message response) throws ProtocolException {
            this.regComplete = false;
            boolean accepted = this.isResponseAccepted(response);
            if (accepted) {
                this.regComplete = true;
                return true;
            }
            if (response == null) {
                this.regComplete = true;
                throw new ProtocolException("Registration stopped (server response lost)");
            }
            return false;
        }

        @Override
        public boolean isRegistrationComplete() {
            return this.regComplete;
        }
    }

    @Deprecated
    protected static interface RegistrationHandler {
        public Message getRegistrationMessage();

        public boolean handleResponse(Message var1) throws ProtocolException;

        public boolean isRegistrationComplete();
    }
}

