/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol;

import com.genesyslab.platform.commons.PlatformException;
import com.genesyslab.platform.commons.PsdkCustomization;
import com.genesyslab.platform.commons.connection.Connection;
import com.genesyslab.platform.commons.connection.ConnectionClosedEvent;
import com.genesyslab.platform.commons.connection.ConnectionHandler;
import com.genesyslab.platform.commons.connection.ConnectionManager;
import com.genesyslab.platform.commons.connection.ConnectionState;
import com.genesyslab.platform.commons.connection.MessagePackager;
import com.genesyslab.platform.commons.connection.StartTLSSupport;
import com.genesyslab.platform.commons.connection.configuration.ConnectionConfiguration;
import com.genesyslab.platform.commons.connection.impl.BinaryStreamListening;
import com.genesyslab.platform.commons.connection.interceptor.Interceptor;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.AbstractChannel;
import com.genesyslab.platform.commons.protocol.AsyncChannelOperations;
import com.genesyslab.platform.commons.protocol.Channel;
import com.genesyslab.platform.commons.protocol.ChannelClosedEvent;
import com.genesyslab.platform.commons.protocol.ChannelClosedOnSendException;
import com.genesyslab.platform.commons.protocol.ChannelEmergencyClosedException;
import com.genesyslab.platform.commons.protocol.ChannelErrorEvent;
import com.genesyslab.platform.commons.protocol.ChannelListener;
import com.genesyslab.platform.commons.protocol.ChannelManager;
import com.genesyslab.platform.commons.protocol.ChannelNotClosedException;
import com.genesyslab.platform.commons.protocol.ChannelOpenedEvent;
import com.genesyslab.platform.commons.protocol.ChannelReceiverInitializationException;
import com.genesyslab.platform.commons.protocol.ChannelState;
import com.genesyslab.platform.commons.protocol.Endpoint;
import com.genesyslab.platform.commons.protocol.EndpointSupport;
import com.genesyslab.platform.commons.protocol.ExternalTransport;
import com.genesyslab.platform.commons.protocol.ExternalTransportFactory;
import com.genesyslab.platform.commons.protocol.ExternalTransportListener;
import com.genesyslab.platform.commons.protocol.InputChannel;
import com.genesyslab.platform.commons.protocol.InterceptorSupport;
import com.genesyslab.platform.commons.protocol.LogMessageFilterSupport;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.MessageFilter;
import com.genesyslab.platform.commons.protocol.MessageHandler;
import com.genesyslab.platform.commons.protocol.MessageReceiver;
import com.genesyslab.platform.commons.protocol.MessageReceiverManagement;
import com.genesyslab.platform.commons.protocol.MessageReceiverSupport;
import com.genesyslab.platform.commons.protocol.OutputChannel;
import com.genesyslab.platform.commons.protocol.OutputChannelListener;
import com.genesyslab.platform.commons.protocol.ProtocolDescription;
import com.genesyslab.platform.commons.protocol.ProtocolDescriptionSupport;
import com.genesyslab.platform.commons.protocol.ProtocolException;
import com.genesyslab.platform.commons.protocol.ProtocolFactory;
import com.genesyslab.platform.commons.protocol.ProtocolIOException;
import com.genesyslab.platform.commons.protocol.ProtocolSecurityException;
import com.genesyslab.platform.commons.protocol.ProtocolTimeoutException;
import com.genesyslab.platform.commons.protocol.QueueMessageReceiver;
import com.genesyslab.platform.commons.protocol.RecursiveCallException;
import com.genesyslab.platform.commons.protocol.RegistrationException;
import com.genesyslab.platform.commons.protocol.runtime.CodecSupport;
import com.genesyslab.platform.commons.protocol.runtime.ProtocolMessagePackagerImpl;
import com.genesyslab.platform.commons.protocol.runtime.ToStringHelper;
import com.genesyslab.platform.commons.protocol.runtime.UpdatableProtocolId;
import com.genesyslab.platform.commons.protocol.runtime.license.LicenseRestriction;
import com.genesyslab.platform.commons.protocol.runtime.license.LicenseRestrictionCollection;
import com.genesyslab.platform.commons.protocol.runtime.license.RestrictionManager;
import com.genesyslab.platform.commons.protocol.runtime.license.SendMessagePermission;
import com.genesyslab.platform.commons.threading.AsyncInvoker;
import com.genesyslab.platform.commons.threading.CompletionHandler;
import com.genesyslab.platform.commons.threading.Slot;
import com.genesyslab.platform.commons.timer.TimerAction;
import com.genesyslab.platform.commons.timer.TimerActionTicket;
import com.genesyslab.platform.commons.timer.TimerFactory;
import com.genesyslab.platform.commons.util.CallstackUtils;
import com.genesyslab.platform.commons.util.ThrowableUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLException;

public class DuplexChannel
extends AbstractChannel
implements InputChannel,
OutputChannel,
InterceptorSupport,
MessageReceiverManagement,
ProtocolDescriptionSupport,
LogMessageFilterSupport,
AsyncChannelOperations {
    private static final ILogger log = Log.getLogger(DuplexChannel.class);
    private final ILogger requestLogger;
    private final ILogger receiveLogger;
    private volatile OpenCloseContext openCloseContext;
    private List<OutputChannelListener> outputChannelListeners = new CopyOnWriteArrayList<OutputChannelListener>();
    private Connection connection;
    private ProtocolFactory protocolFactory;
    private MessageReceiverSupport receiver;
    private boolean externalReceiver = false;
    private MessageHandler messagesHandler = null;
    private final LicenseRestrictionCollection licenseRestriction = new LicenseRestrictionCollection();
    private Object protocolData;
    ChannelManager manager = null;
    protected volatile MessageFilter messageFilter;
    private volatile TimerActionTicket openTimeoutEventNotifierTicket;
    private volatile TimerActionTicket closeTimeoutEventNotifierTicket;
    private final ArrayList<AsyncOpHandler> asyncOpHandlers = new ArrayList();
    private volatile CloseFuture closeFuture = new CloseFuture();
    private volatile String cachedEnpointPrefixInfo;
    private boolean serverSide;
    private boolean externalTransport;
    private ExternalTransport transport;
    private ThreadLocal<Boolean> transportThreadMarker = new ThreadLocal();
    private final ArrayList<Runnable> queueTransportEvents = new ArrayList();
    private boolean processingTransportEvent;

    public DuplexChannel(Endpoint endpoint, ProtocolFactory protocolFactory) {
        this(endpoint, protocolFactory, 30000L);
    }

    public DuplexChannel(Endpoint endpoint, ProtocolFactory protocolFactory, long timeout) {
        this(endpoint, protocolFactory, timeout, true);
    }

    protected DuplexChannel(Connection conn, Endpoint endpoint, ProtocolFactory factory) {
        this(endpoint, factory, 30000L, false);
        this.serverSide = true;
        this.initConnection(conn);
    }

    @Deprecated
    protected DuplexChannel(Connection conn, ProtocolFactory factory, long timeout) {
        this(new Endpoint(conn.getUri(), conn.getHost(), conn.getPort()), factory, timeout, false);
        this.serverSide = true;
        this.initConnection(conn);
    }

    void initConnection(Connection conn) {
        if (this.getStateMods() != 0) {
            throw new IllegalStateException("A connection must be attached immediately after channel construction", null);
        }
        OpenCloseContext openCloseContext = new OpenCloseContext();
        openCloseContext.openingStateMods = this.getStateMods();
        openCloseContext.connection = conn;
        this.openCloseContext = openCloseContext;
        this.connection = conn;
        this.setupConnection(openCloseContext);
    }

    private DuplexChannel(Endpoint endpoint, ProtocolFactory protocolFactory, long timeout, boolean resetReciever) {
        super(timeout, endpoint);
        this.protocolFactory = protocolFactory;
        ProtocolDescription protocolDescr = protocolFactory.getProtocolDescription();
        String protocolName = protocolDescr.toString();
        this.requestLogger = Log.getRequestLogger((String)protocolName);
        this.receiveLogger = Log.getReceiveLogger((String)protocolName);
        this.connectionContext().setAttribute("protocol-sdk", (Object)protocolDescr.getSdkName());
        this.connectionContext().setAttribute("protocol-name", (Object)protocolDescr.getProtocolName());
        if (resetReciever) {
            this.resetReceiver();
        }
    }

    private ProtocolException wrapInProtocolException(Object cause, String message) {
        Throwable ex;
        if (cause == null) {
            return null;
        }
        ProtocolException result = cause instanceof ProtocolException ? (ProtocolException)((Object)cause) : (cause instanceof Throwable ? (null != ThrowableUtil.findTypedCause((Throwable)(ex = (Throwable)cause), SSLException.class) ? new ProtocolSecurityException(this.getEnpointPrefixInfo() + message, ex) : (null != ThrowableUtil.findTypedCause((Throwable)ex, IOException.class) ? new ProtocolIOException(this.getEnpointPrefixInfo() + message, ex) : new ProtocolException(this.getEnpointPrefixInfo() + message, ex))) : new ProtocolException(this.getEnpointPrefixInfo() + message + " : unknown event " + cause));
        return result;
    }

    public int getProtocolId() {
        return this.getChannelId();
    }

    @Override
    public synchronized void open() throws RegistrationException, ProtocolException, IllegalStateException, InterruptedException {
        this.open(this.getTimeout());
    }

    @Override
    public synchronized void open(long openTimeout) throws RegistrationException, ProtocolException, ChannelNotClosedException, InterruptedException {
        OpenCloseContext oc_ctx = this.initiateOpen(openTimeout);
        if (oc_ctx != null) {
            Throwable ex;
            this.waitForOpen(oc_ctx);
            ChannelClosedEvent closeEvent = oc_ctx.closeEvent;
            if (closeEvent != null && (ex = closeEvent.getCause()) != null) {
                CallstackUtils.upgradeCallstack((Throwable)ex);
                if (ex instanceof ProtocolException) {
                    throw (ProtocolException)((Object)ex);
                }
                if (ex instanceof ProtocolTimeoutException) {
                    throw new ProtocolTimeoutException(this.getEnpointPrefixInfo() + "channel opening failed", ex);
                }
            }
            if (oc_ctx.emergencyClosed) {
                throw this.getEmergencyClosedException();
            }
        }
    }

    @Override
    public synchronized void beginOpen() throws ProtocolException {
        this.openAsync(this.getTimeout());
    }

    @Override
    public void close() throws ProtocolException, InterruptedException, IllegalStateException {
        this.close(this.getTimeout());
    }

    public void close(boolean force) throws ProtocolException, InterruptedException, IllegalStateException {
        if (force) {
            this.doCloseForce();
        } else {
            this.doClose(this.getTimeout());
        }
    }

    @Override
    public void close(long timeout) throws ProtocolException, InterruptedException, IllegalStateException {
        this.doClose(timeout);
    }

    @Override
    public void beginClose() throws IllegalStateException {
        this.doBeginClose();
    }

    public InetSocketAddress getLocalEndPoint() {
        if (this.connection != null) {
            return this.connection.getLocalEndPoint();
        }
        return null;
    }

    public InetSocketAddress getRemoteEndPoint() {
        if (this.connection != null) {
            return this.connection.getRemoteEndPoint();
        }
        return null;
    }

    public Message receive() throws InterruptedException {
        return this.receive(this.getTimeout());
    }

    public Message receive(long timeout) throws InterruptedException {
        if (this.messagesHandler != null) {
            throw new ChannelReceiverInitializationException("receive() can't be used with MessagesHandler initialized");
        }
        return this.getInternalReceiver().receive(timeout);
    }

    @Override
    public void send(Message message) throws ProtocolException, IllegalStateException {
        this.throwNotOpenedOnSend();
        this.doSend(message);
    }

    @Override
    public void addListener(OutputChannelListener listener) {
        if (this.outputChannelListeners.contains(listener)) {
            return;
        }
        this.outputChannelListeners.add(listener);
    }

    @Override
    public void removeListener(OutputChannelListener listener) {
        this.outputChannelListeners.remove(listener);
    }

    private void notifyOnSend(Message message) {
        for (OutputChannelListener l : this.outputChannelListeners) {
            try {
                l.onSend(this, message);
            }
            catch (Exception e) {
                log.error((Object)"Unexpected exception caught from onSend listener", (Throwable)e);
            }
        }
    }

    @Override
    public int getInputSize() {
        return this.receiver.getInputSize();
    }

    @Override
    public void setInputSize(int inputSize) {
        this.getInternalReceiver().setInputSize(inputSize);
    }

    @Override
    public void releaseReceivers() {
        this.getInternalReceiver().releaseReceivers();
    }

    @Override
    public Interceptor getInterceptor() {
        if (this.getConfiguration() == null) {
            return null;
        }
        if (this.connection == null) {
            return null;
        }
        return this.connection.getInterceptor();
    }

    @Override
    public void clearInput() {
        this.receiver.clearInput();
    }

    @Override
    public void setReceiver(MessageReceiverSupport receiver) {
        if (this.messagesHandler != null) {
            throw new ChannelReceiverInitializationException("Protocol already has MessageHandler initialized");
        }
        this.throwNotClosed();
        this.externalReceiver = true;
        this.doSetReceiver(receiver);
    }

    @Override
    public void setMessageHandler(MessageHandler msgHandler) {
        if (this.externalReceiver) {
            throw new ChannelReceiverInitializationException("Protocol already has external Receiver initialized");
        }
        this.throwNotClosed();
        this.messagesHandler = msgHandler;
    }

    @Override
    public void resetReceiver() {
        this.throwNotClosed();
        this.externalReceiver = false;
        QueueMessageReceiver internalReceiver = new QueueMessageReceiver(128, true);
        this.doSetReceiver(internalReceiver);
    }

    @Override
    @Deprecated
    public void setConnectionInvoker(AsyncInvoker connectionInvoker) {
        this.throwNotClosed();
        super.setConnectionInvoker(connectionInvoker);
    }

    @Override
    public ProtocolDescription getProtocolDescription() {
        if (this.protocolFactory == null) {
            return null;
        }
        return this.protocolFactory.getProtocolDescription();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this)) + " " + this.getEndpoint();
    }

    protected void setProtocolData(Object protocolData) {
        this.protocolData = protocolData;
        this.initPackager(this.connection, protocolData);
    }

    protected void initPackager(Connection connection, Object protocolData) {
        MessagePackager packager;
        if (connection != null && (packager = connection.getMessagePackager()) instanceof CodecSupport) {
            CodecSupport codecSupport = (CodecSupport)packager;
            codecSupport.setProtocolData(protocolData);
        }
    }

    protected ProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessage(Message message) throws PlatformException {
        ExternalTransport externalTransport = this.transport;
        if (externalTransport != null) {
            this.transportThreadMarker.set(true);
            try {
                externalTransport.sendMessage(message);
            }
            finally {
                this.transportThreadMarker.remove();
            }
        } else {
            Connection conn = this.connection;
            if (conn != null && ConnectionState.OPENED.equals((Object)conn.getConnectionState())) {
                conn.getMessagePackager().sendMessage((Object)message);
            } else {
                throw new ChannelClosedOnSendException(this.getEnpointPrefixInfo() + "Channel has been closed before message delivery");
            }
        }
    }

    protected void doSend(Message message) throws ProtocolException {
        this.throwNull(message, "message");
        ProtocolDescription protocolDescription = this.getProtocolDescription();
        if (this.protocolFactory instanceof ProtocolFactory.MessageVerificationSupport) {
            if (!((ProtocolFactory.MessageVerificationSupport)((Object)this.protocolFactory)).verifyMessage(ProtocolFactory.MessageVerificationReason.BeforeSend, message)) {
                throw new IllegalArgumentException("[DuplexChannel.doSend] Message verification on send is failed. " + message);
            }
        } else if (protocolDescription != null && !protocolDescription.equals(message.getProtocolDescription())) {
            throw new IllegalArgumentException("[DuplexChannel.doSend] Message belongs to other protocol. Expected: {" + protocolDescription + "} " + "=> Actual: {" + message.getProtocolDescription() + "}");
        }
        this.onSend(message);
        if (message instanceof EndpointSupport) {
            ((EndpointSupport)((Object)message)).setEndpoint(this.getEndpoint());
        }
        if (message instanceof UpdatableProtocolId) {
            ((UpdatableProtocolId)((Object)message)).setProtocolId(this.getProtocolId());
        }
        if (this.isMessageAllowed(message)) {
            MessageFilter messageFilter = this.messageFilter;
            if (messageFilter == null || messageFilter.isMessageAccepted(message)) {
                if (this.requestLogger.isDebug()) {
                    this.requestLogger.debugFormat("Sending message to {0}/{1} message: {2}", (Object)new Object[]{protocolDescription, this.getEndpoint(), message.toString(true, false)});
                }
                if (log.isDebug()) {
                    log.debug((Object)("Sending message to '" + protocolDescription + "@" + this.getEndpoint() + "' message: " + ToStringHelper.toString(message, true, true)));
                }
            }
            try {
                this.sendMessage(message);
            }
            catch (PlatformException e) {
                throw new ProtocolException("Exception sending message", e);
            }
            if (this.manager != null) {
                this.manager.incMessagesSentNumber();
            }
        }
    }

    protected final boolean isMessageAllowed(Message message) throws ProtocolException {
        LicenseRestriction restriction = this.getRestriction();
        if (restriction == null) {
            return true;
        }
        boolean allowed = restriction.isAllowed(new SendMessagePermission(message));
        if (!allowed) {
            if (log.isDebug()) {
                log.debugFormat("Message ''{0}'' is not allowed to be sent", (Object)message.messageName());
            }
            ChannelErrorEvent errEvent = new ChannelErrorEvent(this, (Throwable)((Object)new ProtocolException("message is not allowed to be sent")));
            this.getInvoker().invoke((Runnable)(AbstractChannel)this.new AbstractChannel.AsyncErrorNotifier(errEvent));
        }
        return allowed;
    }

    protected LicenseRestriction getDefaultRestriction() {
        return this.licenseRestriction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doClose(long closeTimeout) throws ProtocolException, InterruptedException {
        DuplexChannel duplexChannel = this;
        synchronized (duplexChannel) {
            OpenCloseContext ctx = this.openCloseContext;
            ChannelState state = this.getState();
            if (state == ChannelState.Closed) {
                return;
            }
            if (state != ChannelState.Closing && !this.initiateClose(closeTimeout)) {
                return;
            }
            if (!this.waitForClose(ctx, closeTimeout)) {
                throw this.getTimeoutException("close", closeTimeout);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCloseForce() throws ProtocolException, InterruptedException {
        DuplexChannel duplexChannel = this;
        synchronized (duplexChannel) {
            Connection con;
            ChannelState state = this.getState();
            if (state == ChannelState.Closed) {
                return;
            }
            if (log.isInfo()) {
                log.infoFormat("Force close {0}", (Object)this.getEndpoint());
            }
            if ((con = this.connection) != null) {
                con.setConnectionHandler(null);
                con.forceClose();
            }
            this.processClose(new ConnectionClosedEvent((Object)this, null, this.connection));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doBeginClose() {
        DuplexChannel duplexChannel = this;
        synchronized (duplexChannel) {
            ChannelState state = this.getState();
            if (state == ChannelState.Closing || state == ChannelState.Closed) {
                return;
            }
            this.initiateClose(this.getTimeout());
        }
    }

    protected void onOpen() throws ProtocolException {
        this.setState(ChannelState.Opened);
    }

    protected void onSend(Message message) throws ProtocolException {
        this.notifyOnSend(message);
    }

    protected synchronized void onClose(ConnectionClosedEvent event) {
        this.setState(ChannelState.Closed, event);
    }

    protected void onReceiveMessage(Message msg) {
        if (this.messagesHandler != null) {
            this.getInvoker().invoke((Runnable)new AsyncMessageNotifier(msg, this.messagesHandler));
        } else {
            this.receiver.processMessage(msg);
        }
    }

    protected Connection createConnection(Endpoint endpoint) {
        Connection con = ConnectionManager.createConnection((String)endpoint.getHost(), (int)endpoint.getPort(), this.connectionContext());
        if (con instanceof BinaryStreamListening) {
            BinaryStreamListening bsl = (BinaryStreamListening)con;
            BinaryStreamListening binaryStreamListening = (BinaryStreamListening)this.internal(BinaryStreamListening.class);
            bsl.setIncomingBinaryMessageListener(binaryStreamListening.getIncomingBinaryMessageListener());
            bsl.setOutcomingBinaryMessageListener(binaryStreamListening.getOutcomingBinaryMessageListener());
        }
        return con;
    }

    @Deprecated
    protected <N> N waitForObject(Slot<N> syncObject, long timeout) throws InterruptedException {
        Object openResult = timeout < 0L ? syncObject.take() : syncObject.poll(timeout);
        return (N)openResult;
    }

    protected <N> void notifyWithObject(Slot<N> syncObject, N notification) throws InterruptedException {
        syncObject.put(notification);
    }

    protected <N> boolean triggerWithObject(Slot<N> syncObject, N notification) throws InterruptedException {
        return syncObject.offer(notification, 0L);
    }

    protected ProtocolException getTimeoutException(String operation, long timeout) {
        String msg = this.getEnpointPrefixInfo() + "Timeout on channel (" + timeout + " ms). Operation: " + operation;
        ProtocolTimeoutException ex = new ProtocolTimeoutException(msg, null);
        log.error((Object)("Channel " + operation + " timeout"), (Throwable)((Object)ex));
        return ex;
    }

    protected ProtocolException getOpenTimeoutException(long timeout) {
        String msg = this.getEnpointPrefixInfo() + "Timeout on channel (" + timeout + " ms). Operation: open";
        ProtocolTimeoutException ex = new ProtocolTimeoutException(msg, null);
        log.error((Object)"Channel open timeout", (Throwable)((Object)ex));
        return ex;
    }

    private MessageReceiver<Message> getInternalReceiver() {
        if (this.externalReceiver) {
            throw new ChannelReceiverInitializationException("External receiver is set, use its methods instead");
        }
        return this.receiver;
    }

    private LicenseRestriction getRestriction() {
        LicenseRestriction restriction = RestrictionManager.getRestriction(new ProtocolDescription("not.used.so.far", "*"));
        if (restriction == null) {
            restriction = this.getDefaultRestriction();
        }
        return restriction;
    }

    private void doSetReceiver(MessageReceiverSupport receiver) {
        this.removeChannelListener(this.receiver);
        this.receiver = receiver;
        this.addChannelListener(receiver);
    }

    @Override
    protected synchronized void setState(ChannelState state, ConnectionClosedEvent closedEvent) {
        ChannelState prevState = this.getState();
        if (prevState != state) {
            if (ChannelState.Closing.equals((Object)state) && ChannelState.Closed.equals((Object)prevState)) {
                return;
            }
            if (prevState == ChannelState.Opening) {
                this.cancelOpenTimeout();
                if (state != ChannelState.Opened) {
                    this.openCloseContext.emergencyClosed = true;
                }
            }
            if (state == ChannelState.Closed) {
                this.cachedEnpointPrefixInfo = null;
                this.cancelCloseTimeout();
            }
            super.setState(state, closedEvent);
            int stateMods = this.getStateMods();
            if (state == ChannelState.Opening) {
                this.openCloseContext.openingStateMods = stateMods;
            } else if (state == ChannelState.Closing) {
                this.openCloseContext.closingStateMods = stateMods;
            }
        }
    }

    protected void cancelOpenTimeout() {
        if (this.openTimeoutEventNotifierTicket != null) {
            this.openTimeoutEventNotifierTicket.cancel();
            this.openTimeoutEventNotifierTicket = null;
        }
    }

    protected void cancelCloseTimeout() {
        if (this.closeTimeoutEventNotifierTicket != null) {
            this.closeTimeoutEventNotifierTicket.cancel();
            this.closeTimeoutEventNotifierTicket = null;
        }
    }

    private static TimerActionTicket scheduleAction(long timeout, TimerAction action) {
        if (timeout < 0L) {
            return null;
        }
        if (System.currentTimeMillis() + timeout + 60000L < 0L) {
            return null;
        }
        return TimerFactory.getTimer().schedule(timeout, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAllTasksFromQueue() {
        while (true) {
            Runnable task;
            DuplexChannel duplexChannel = this;
            synchronized (duplexChannel) {
                if (this.queueTransportEvents.size() == 0) {
                    break;
                }
                task = this.queueTransportEvents.remove(0);
            }
            task.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTasksFromQueue(int taskCount) {
        while (taskCount > 0) {
            Runnable task;
            DuplexChannel duplexChannel = this;
            synchronized (duplexChannel) {
                task = this.queueTransportEvents.remove(0);
                --taskCount;
            }
            task.run();
        }
    }

    private OpenCloseContext initiateOpen(final long timeout) {
        Connection connection;
        ExternalTransport transport;
        OpenCloseContext oc_ctx;
        this.throwNullEndpoint();
        this.throwNotClosed();
        Endpoint endpoint = this.getEndpoint();
        if (log.isDebug()) {
            log.debug((Object)("Opening channel '" + endpoint));
        }
        this.openCloseContext = oc_ctx = new OpenCloseContext();
        this.closeFuture = new CloseFuture(oc_ctx);
        this.setState(ChannelState.Opening);
        this.cancelOpenTimeout();
        this.openTimeoutEventNotifierTicket = DuplexChannel.scheduleAction(timeout, new TimerAction(){
            final OpenCloseContext ctx;
            {
                this.ctx = oc_ctx;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onTimer() {
                DuplexChannel duplexChannel = DuplexChannel.this;
                synchronized (duplexChannel) {
                    if (DuplexChannel.this.getStateMods() != this.ctx.openingStateMods) {
                        return;
                    }
                    Connection con = DuplexChannel.this.connection;
                    if (con != null) {
                        con.setConnectionHandler(null);
                        con.forceClose();
                    }
                    DuplexChannel.this.processClose(DuplexChannel.this.createConnectionClosedEvent((Throwable)((Object)DuplexChannel.this.getOpenTimeoutException(timeout))));
                }
            }

            public String toString() {
                return "openTimeoutTask" + DuplexChannel.this.getEnpointPrefixInfo();
            }
        });
        if (this.connection != null) {
            this.connection.configure(null);
        }
        ExternalTransport externalTransport = transport = this.externalTransport ? this.transport : ExternalTransportFactoryHolder.getTransport(this.getProtocolDescription(), endpoint);
        if (transport != null) {
            this.updateTransport(transport);
            this.transportThreadMarker.set(true);
            try {
                transport.setTransportListener(new TransportListener(oc_ctx, endpoint));
                transport.connect(this.getEndpoint());
            }
            catch (Error ex) {
                this.releaseTransport();
                this.processClose(new ConnectionClosedEvent((Object)this, (Throwable)ex));
                throw ex;
            }
            catch (RuntimeException ex) {
                this.releaseTransport();
                this.processClose(new ConnectionClosedEvent((Object)this, (Throwable)ex));
                throw ex;
            }
            finally {
                this.transportThreadMarker.remove();
            }
        }
        this.connection = connection = this.createConnection(endpoint);
        oc_ctx.connection = this.connection;
        this.applyConfiguration();
        if (this.protocolData != null) {
            this.initPackager(connection, this.protocolData);
        }
        this.setupConnection(oc_ctx);
        try {
            connection.open();
        }
        catch (Error e) {
            connection.setConnectionHandler(null);
            connection.forceClose();
            this.processClose(new ConnectionClosedEvent((Object)this, (Throwable)e, connection));
            throw e;
        }
        catch (RuntimeException e) {
            connection.setConnectionHandler(null);
            connection.forceClose();
            this.processClose(new ConnectionClosedEvent((Object)this, (Throwable)e, connection));
            throw e;
        }
        return oc_ctx;
    }

    private void checkTransportNotificationThread() {
        Boolean marker = this.transportThreadMarker.get();
        if (marker != null && marker.booleanValue()) {
            throw new RecursiveCallException("External transport must notifies the listener asynchronously.");
        }
    }

    @Override
    protected String getEnpointPrefixInfo() {
        String s = this.cachedEnpointPrefixInfo;
        if (s == null) {
            s = super.getEnpointPrefixInfo();
        }
        return s;
    }

    @Override
    protected String getLocalEndpointInfo(Endpoint endpoint) {
        InetSocketAddress addr;
        Connection c;
        if (endpoint == null) {
            return "";
        }
        ConnectionConfiguration cfg = endpoint.getConfiguration();
        String localHost = null;
        localHost = cfg.getOption("transport-address");
        String localPort = null;
        localPort = cfg.getOption("transport-port");
        if ((localHost == null || localPort == null) && (c = this.connection) != null && (addr = c.getLocalEndPoint()) != null) {
            if (localHost == null) {
                localHost = "" + addr.getAddress().getHostAddress();
            }
            if (localPort == null) {
                localPort = "" + addr.getPort();
            }
        }
        if (localHost == null && localPort == null) {
            return "";
        }
        return '<' + (localHost == null ? "" : localHost) + (localPort == null ? "" : ':' + localPort);
    }

    @Override
    protected void applyConfiguration() {
        ConnectionConfiguration config = this.getConfiguration();
        if (config != null && this.connection != null) {
            this.connection.configure(config);
        }
    }

    private boolean waitForOpen(OpenCloseContext openCloseContext) throws InterruptedException {
        int stateMods = openCloseContext.openingStateMods;
        while (this.getStateMods() == stateMods) {
            this.wait();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initiateClose(final long timeout) {
        Connection connection = this.openCloseContext.connection;
        if (this.getState() == ChannelState.Opening) {
            if (log.isInfo()) {
                log.infoFormat("Emergency channel closing {0}", (Object)this.getEndpoint());
            }
            if (this.transport != null) {
                this.releaseTransport();
            } else {
                Connection con = connection;
                if (con != null) {
                    con.setConnectionHandler(null);
                    con.forceClose();
                }
            }
            if (this.openCloseContext.closeEvent == null) {
                ConnectionClosedEvent event = this.createConnectionClosedEvent(null);
                this.processClose(event);
            }
            return false;
        }
        this.setState(ChannelState.Closing);
        if (log.isDebug()) {
            log.debug((Object)("Closing channel '" + this.getEndpoint()));
        }
        this.cancelCloseTimeout();
        this.closeTimeoutEventNotifierTicket = DuplexChannel.scheduleAction(timeout, new TimerAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onTimer() {
                int stateMods = DuplexChannel.this.getStateMods();
                DuplexChannel duplexChannel = DuplexChannel.this;
                synchronized (duplexChannel) {
                    if (DuplexChannel.this.getStateMods() != stateMods) {
                        return;
                    }
                    ProtocolException ex = DuplexChannel.this.getTimeoutException("close", timeout);
                    ChannelClosedEvent event = new ChannelClosedEvent((Channel)DuplexChannel.this, (Throwable)((Object)ex), ChannelState.Closing);
                    DuplexChannel.this.fireErrorEvent(event);
                }
            }

            public String toString() {
                return "closeTimeoutTask " + DuplexChannel.this.getEnpointPrefixInfo();
            }
        });
        if (this.transport != null) {
            this.transportThreadMarker.set(true);
            try {
                this.transport.disconnect();
            }
            finally {
                this.transportThreadMarker.remove();
            }
        } else {
            connection.close();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseTransport() {
        if (this.transport == null) {
            return;
        }
        if (this.externalTransport) {
            this.updateTransport(null);
        } else {
            this.transportThreadMarker.set(true);
            try {
                this.transport.setTransportListener(null);
                this.transport.disconnect();
            }
            finally {
                this.transportThreadMarker.remove();
            }
        }
    }

    protected void processCloseAll(ConnectionClosedEvent event) {
        ConnectionState connectionState;
        Connection con = this.openCloseContext.connection;
        if (con != null && ((connectionState = con.getConnectionState()) == ConnectionState.OPENED || connectionState == ConnectionState.OPENING)) {
            con.setConnectionHandler(null);
            con.forceClose();
        }
        this.processClose(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processClose(ConnectionClosedEvent event) {
        try {
            this.onClose(event);
        }
        catch (Throwable e) {
            if (log.isDebug()) {
                log.debug((Object)"Channel close internal error", e);
            }
        }
        finally {
            this.notifyAll();
        }
    }

    private ChannelEmergencyClosedException getEmergencyClosedException() {
        return new ChannelEmergencyClosedException(this.getEnpointPrefixInfo() + "Emergency channel closing", null);
    }

    private boolean waitForClose(OpenCloseContext openCloseContext, long timeout) throws InterruptedException {
        int stateMods = openCloseContext.closingStateMods;
        long timeStart = System.currentTimeMillis();
        while (this.getStateMods() == stateMods) {
            if (timeout < 0L) {
                this.wait();
                continue;
            }
            long t = timeout - (System.currentTimeMillis() - timeStart);
            if (t <= 0L) {
                return false;
            }
            this.wait(t);
        }
        return true;
    }

    void setupConnection(OpenCloseContext openCloseContext) {
        DuplexChannelConnHandler handler = new DuplexChannelConnHandler(openCloseContext, this.getEndpoint());
        this.connection.setConnectionHandler((ConnectionHandler)handler);
        ProtocolMessagePackagerImpl packager = new ProtocolMessagePackagerImpl(this.protocolFactory, this.getConfiguration(), handler, new PackagerErrorHandler());
        packager.setReversedDirection(this.serverSide);
        this.connection.setMessagePackager((MessagePackager)packager);
        packager.setLogMessageFilter(this.messageFilter);
    }

    protected boolean upgradeConnection() {
        if (this.connection instanceof StartTLSSupport) {
            try {
                ((StartTLSSupport)this.connection).startTLS();
                return true;
            }
            catch (GeneralSecurityException e) {
                log.debug((Object)"Failed to start TLS", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    protected boolean startUpgradeConnection(Runnable notificationCallback) {
        if (this.connection instanceof StartTLSSupport) {
            try {
                ((StartTLSSupport)this.connection).startTLS(notificationCallback);
                return true;
            }
            catch (GeneralSecurityException e) {
                log.debug((Object)"Failed to start TLS", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    protected boolean downgradeConnection() {
        if (this.connection instanceof StartTLSSupport) {
            try {
                ((StartTLSSupport)this.connection).stopTLS();
                return true;
            }
            catch (Exception e) {
                log.debug((Object)"Failed to stop TLS", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    protected boolean stopReading() {
        if (this.connection instanceof StartTLSSupport) {
            try {
                return ((StartTLSSupport)this.connection).stopReading();
            }
            catch (Exception e) {
                log.debug((Object)"Failed to stop reading from channel", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    protected boolean resumeReading() {
        if (this.connection instanceof StartTLSSupport) {
            try {
                return ((StartTLSSupport)this.connection).resumeReading();
            }
            catch (Exception e) {
                log.debug((Object)"Failed to resume reading from channel", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTransport(ExternalTransport transport) {
        if (this.transport == transport) {
            return;
        }
        if (this.transport != null) {
            this.transportThreadMarker.set(true);
            try {
                this.transport.setTransportListener(null);
                this.transport.disconnect();
            }
            finally {
                this.transportThreadMarker.remove();
            }
        }
        this.transport = transport;
    }

    public synchronized void setExternalTransport(ExternalTransport transport) {
        this.throwNotClosed();
        this.externalTransport = transport != null;
        this.updateTransport(transport);
    }

    private static void updateMessageEndpoint(Message message, Endpoint endpoint) {
        if (message instanceof EndpointSupport) {
            ((EndpointSupport)((Object)message)).setEndpoint(endpoint);
        }
    }

    protected void receivedMessage(Message message, Endpoint endpoint) {
        MessageFilter messageFilter;
        if (message instanceof UpdatableProtocolId) {
            ((UpdatableProtocolId)((Object)message)).setProtocolId(this.getProtocolId());
        }
        if (endpoint != null) {
            DuplexChannel.updateMessageEndpoint(message, endpoint);
        }
        if ((messageFilter = this.messageFilter) == null || messageFilter.isMessageAccepted(message)) {
            if (this.receiveLogger.isDebug()) {
                this.receiveLogger.debugFormat("Handling message: {0}", (Object)message.toString(true, false));
            }
            if (log.isDebug()) {
                log.debugFormat("Handling message: {0}", (Object)message);
            }
        }
        if (this.manager != null) {
            this.manager.incMessagesReceivedNumber();
        }
        this.onReceiveMessage(message);
        if (log.isDebug() && (messageFilter == null || messageFilter.canTrace())) {
            log.debug((Object)("Complete message handling: " + message.messageId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onConnectionEstablished(OpenCloseContext openCloseContext) {
        DuplexChannel duplexChannel = this;
        synchronized (duplexChannel) {
            if (this.getStateMods() == openCloseContext.openingStateMods) {
                this.cachedEnpointPrefixInfo = null;
                this.cachedEnpointPrefixInfo = this.getEnpointPrefixInfo();
                if (openCloseContext.closeEvent == null) {
                    if (log.isInfo()) {
                        log.info((Object)("Channel connection is opened '" + openCloseContext.connection));
                    }
                    try {
                        this.onOpen();
                        this.notifyAll();
                    }
                    catch (Throwable e) {
                        ConnectionClosedEvent event = new ConnectionClosedEvent((Object)this, (Throwable)((Object)this.wrapInProtocolException(e, "Error opening channel")), openCloseContext.connection);
                        this.processCloseAll(event);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onConnectionClosed(OpenCloseContext openCloseContext, ConnectionClosedEvent event) {
        if (openCloseContext.connection != null) {
            openCloseContext.connection.setConnectionHandler(null);
        }
        DuplexChannel duplexChannel = this;
        synchronized (duplexChannel) {
            ChannelState state = this.getState();
            event = state == ChannelState.Opening ? new ConnectionClosedEvent(event, (Throwable)((Object)this.wrapInProtocolException(event.getCause(), "Error opening connection"))) : new ConnectionClosedEvent(event, (Throwable)((Object)this.wrapInProtocolException(event.getCause(), "Channel's connection closed")));
            int stateMods = this.getStateMods();
            if (state == ChannelState.Closing) {
                if (stateMods == openCloseContext.closingStateMods) {
                    this.processClose(null);
                }
            } else if (state == ChannelState.Opening) {
                if (stateMods == openCloseContext.openingStateMods) {
                    this.processClose(event);
                }
            } else if (state == ChannelState.Opened && stateMods == openCloseContext.openingStateMods + 1) {
                this.processClose(event);
            }
        }
    }

    @Override
    public MessageFilter getLogMessageFilter() {
        return this.messageFilter;
    }

    @Override
    public void setLogMessageFilter(MessageFilter filter) {
        MessagePackager packager;
        this.messageFilter = filter;
        Connection conn = this.connection;
        if (conn != null && (packager = conn.getMessagePackager()) instanceof ProtocolMessagePackagerImpl) {
            ((ProtocolMessagePackagerImpl)packager).setLogMessageFilter(filter);
        }
    }

    protected ConnectionClosedEvent createConnectionClosedEvent(Throwable e) {
        return new ConnectionClosedEvent((Object)this, e, this.connection);
    }

    @Override
    protected ChannelClosedEvent createChannelClosedEvent(ChannelState prevState, Throwable cause) {
        ChannelClosedEvent channelClosedEvent = super.createChannelClosedEvent(prevState, cause);
        Connection con = this.connection;
        if (con != null) {
            channelClosedEvent.setUnsentBytes(con.getUnsetBytes());
        }
        return channelClosedEvent;
    }

    @Override
    public synchronized <A> void openAsync(CompletionHandler<EventObject, A> handler, A attachment) {
        this.openAsync(this.getTimeout(), handler, attachment);
    }

    @Override
    public synchronized <A> void openAsync(long timeout, CompletionHandler<EventObject, A> handler, A attachment) {
        block4: {
            final AsyncOpenHandler<A> async = new AsyncOpenHandler<A>(timeout, handler, attachment);
            try {
                this.asyncOpHandlers.add(async);
                this.initiateOpen(timeout);
            }
            catch (Throwable ex) {
                this.asyncOpHandlers.remove(async);
                if (async.cancel()) {
                    this.getInvoker().invoke(new Runnable(){

                        @Override
                        public void run() {
                            async.handler.failed(ex, async.attachment);
                        }
                    });
                    if (ChannelState.Closed.equals((Object)this.getState())) {
                        this.releaseDefaultInvoker();
                    }
                }
                if (!(ex instanceof Error)) break block4;
                throw (Error)ex;
            }
        }
    }

    @Override
    public synchronized <A> void closeAsync(CompletionHandler<ChannelClosedEvent, A> handler, A attachment) {
        this.closeAsync(this.getTimeout(), handler, attachment);
    }

    @Override
    public synchronized <A> void closeAsync(long timeout, final CompletionHandler<ChannelClosedEvent, A> handler, final A attachment) {
        block5: {
            if (this.getState() == ChannelState.Closed) {
                this.getInvoker().invoke(new Runnable(){

                    @Override
                    public void run() {
                        ChannelClosedEvent closedEvent = null;
                        CloseFuture f = DuplexChannel.this.closeFuture;
                        if (f != null && f.context != null) {
                            closedEvent = f.context.closeEvent;
                        }
                        if (closedEvent == null) {
                            closedEvent = new ChannelClosedEvent((Channel)DuplexChannel.this, (Throwable)null, ChannelState.Closed);
                        }
                        handler.completed((Object)closedEvent, attachment);
                    }
                });
                this.releaseDefaultInvoker();
            } else {
                final AsyncCloseHandler<A> async = new AsyncCloseHandler<A>(timeout, handler, attachment);
                try {
                    this.asyncOpHandlers.add(async);
                    this.initiateClose(timeout);
                }
                catch (Throwable ex) {
                    this.asyncOpHandlers.remove(async);
                    if (((AsyncOpHandler)async).cancel()) {
                        this.getInvoker().invoke(new Runnable(){

                            @Override
                            public void run() {
                                async.handler.failed(ex, async.attachment);
                            }
                        });
                        this.releaseDefaultInvoker();
                    }
                    if (!(ex instanceof Error)) break block5;
                    throw (Error)ex;
                }
            }
        }
    }

    @Override
    protected void onFireOpened(EventObject event) {
        int count = this.asyncOpHandlers.size();
        if (count > 0) {
            AsyncOpHandler[] list;
            for (AsyncOpHandler async : list = this.asyncOpHandlers.toArray(new AsyncOpHandler[count])) {
                async.onChannelOpened(event);
            }
        }
        this.openCloseContext.openEvent = (ChannelOpenedEvent)event;
    }

    @Override
    protected void onFireClosed(ChannelClosedEvent event) {
        this.releaseTransport();
        int count = this.asyncOpHandlers.size();
        if (count > 0) {
            AsyncOpHandler[] list;
            for (AsyncOpHandler async : list = this.asyncOpHandlers.toArray(new AsyncOpHandler[count])) {
                async.onChannelClosed(event);
            }
        }
        this.openCloseContext.closeEvent = event;
    }

    @Override
    protected void onFireErrorEvent(ChannelErrorEvent event) {
        int count = this.asyncOpHandlers.size();
        if (count > 0) {
            AsyncOpHandler[] list;
            for (AsyncOpHandler async : list = this.asyncOpHandlers.toArray(new AsyncOpHandler[count])) {
                async.onChannelError(event);
            }
        }
    }

    public Future<ChannelOpenedEvent> openAsync() {
        return this.openAsync(this.getTimeout());
    }

    public synchronized Future<ChannelOpenedEvent> openAsync(Long timeout) {
        OpenCloseContext ctx = this.initiateOpen(timeout != null ? timeout.longValue() : this.getTimeout());
        return ctx.getOpenFuture();
    }

    public synchronized Future<ChannelClosedEvent> closeAsync() {
        ChannelState state = this.getState();
        if (state == ChannelState.Closing || state == ChannelState.Closed) {
            return this.closeFuture;
        }
        this.initiateClose(-1L);
        return this.closeFuture;
    }

    private static class ExternalTransportFactoryHolder {
        private static final Object sync = new Object();
        private static volatile String cachedFactoryName;
        private static volatile ExternalTransportFactory cachedFactory;

        private ExternalTransportFactoryHolder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ExternalTransport getTransport(ProtocolDescription protocolDescription, Endpoint endpoint) {
            String factoryName = PsdkCustomization.getOption((PsdkCustomization.PsdkOption)PsdkCustomization.PsdkOption.TransportFactoryImpl);
            ExternalTransportFactory factory = null;
            Object object = sync;
            synchronized (object) {
                block11: {
                    if (!(cachedFactoryName == null || factoryName != null && cachedFactoryName.equals(factoryName))) {
                        log.info((Object)("External transport factory deactivation.  " + cachedFactoryName));
                        cachedFactoryName = null;
                        cachedFactory = null;
                    }
                    if (cachedFactory == null && factoryName != null) {
                        if (log.isInfo()) {
                            log.info((Object)("External transport factory activation." + factoryName));
                        }
                        try {
                            Class<?> c = Class.forName(factoryName);
                            cachedFactory = factory = (ExternalTransportFactory)c.newInstance();
                            cachedFactoryName = factoryName;
                            if (log.isInfo()) {
                                log.info((Object)("External transport factory activated.  " + factoryName));
                            }
                            break block11;
                        }
                        catch (Exception e) {
                            cachedFactoryName = null;
                            cachedFactory = null;
                            if (log.isError()) {
                                log.error((Object)("External transport factory instantiation failed. " + factoryName), (Throwable)e);
                            }
                            break block11;
                        }
                    }
                    factory = cachedFactory;
                }
            }
            if (factory == null) {
                return null;
            }
            return factory.getTransport(protocolDescription, endpoint);
        }
    }

    class TransportListener
    implements ExternalTransportListener,
    Runnable {
        OpenCloseContext ctx;
        Endpoint endpoint;

        public TransportListener(OpenCloseContext ctx, Endpoint endpoint) {
            this.ctx = ctx;
            this.endpoint = endpoint;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConnected() {
            DuplexChannel.this.checkTransportNotificationThread();
            Runnable task = null;
            int remainedTasksBeforeThisEvent = 0;
            DuplexChannel duplexChannel = DuplexChannel.this;
            synchronized (duplexChannel) {
                if (DuplexChannel.this.processingTransportEvent) {
                    DuplexChannel.this.queueTransportEvents.add(new Runnable(){

                        @Override
                        public void run() {
                            DuplexChannel.this.onConnectionEstablished(TransportListener.this.ctx);
                        }
                    });
                    return;
                }
                remainedTasksBeforeThisEvent = DuplexChannel.this.queueTransportEvents.size();
                if (remainedTasksBeforeThisEvent > 0) {
                    task = (Runnable)DuplexChannel.this.queueTransportEvents.remove(0);
                    --remainedTasksBeforeThisEvent;
                }
                DuplexChannel.this.processingTransportEvent = true;
            }
            try {
                if (task != null) {
                    task.run();
                    DuplexChannel.this.executeTasksFromQueue(remainedTasksBeforeThisEvent);
                }
                DuplexChannel.this.onConnectionEstablished(this.ctx);
                DuplexChannel.this.executeAllTasksFromQueue();
            }
            finally {
                duplexChannel = DuplexChannel.this;
                synchronized (duplexChannel) {
                    DuplexChannel.this.processingTransportEvent = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDisconnected(final Throwable cause) {
            DuplexChannel.this.checkTransportNotificationThread();
            Runnable task = null;
            int remainedTasksBeforeThisEvent = 0;
            DuplexChannel duplexChannel = DuplexChannel.this;
            synchronized (duplexChannel) {
                if (DuplexChannel.this.processingTransportEvent) {
                    DuplexChannel.this.queueTransportEvents.add(new Runnable(){

                        @Override
                        public void run() {
                            DuplexChannel.this.onConnectionClosed(TransportListener.this.ctx, new ConnectionClosedEvent((Object)DuplexChannel.this, cause));
                        }
                    });
                    return;
                }
                remainedTasksBeforeThisEvent = DuplexChannel.this.queueTransportEvents.size();
                if (remainedTasksBeforeThisEvent > 0) {
                    task = (Runnable)DuplexChannel.this.queueTransportEvents.remove(0);
                    --remainedTasksBeforeThisEvent;
                }
                DuplexChannel.this.processingTransportEvent = true;
            }
            try {
                if (task != null) {
                    task.run();
                    DuplexChannel.this.executeTasksFromQueue(remainedTasksBeforeThisEvent);
                }
                DuplexChannel.this.onConnectionClosed(this.ctx, new ConnectionClosedEvent((Object)DuplexChannel.this, cause));
                DuplexChannel.this.executeAllTasksFromQueue();
            }
            finally {
                duplexChannel = DuplexChannel.this;
                synchronized (duplexChannel) {
                    DuplexChannel.this.processingTransportEvent = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMessageReceived(final Message message) {
            DuplexChannel.this.checkTransportNotificationThread();
            if (message == null) {
                if (log.isDebug()) {
                    log.debug((Object)(DuplexChannel.this.getEnpointPrefixInfo() + "External transport notified about receiving null message."));
                }
                return;
            }
            ProtocolDescription protocolDescr = DuplexChannel.this.getProtocolDescription();
            if (protocolDescr == null) {
                if (log.isError()) {
                    log.error((Object)(DuplexChannel.this.getEnpointPrefixInfo() + "Protocol message was received without ProtocolDescription initialized"));
                }
            } else if (!protocolDescr.equals(message.getProtocolDescription()) && log.isError()) {
                log.error((Object)(DuplexChannel.this.getEnpointPrefixInfo() + "Illegal protocol message was received by external transport"));
            }
            DuplexChannel.updateMessageEndpoint(message, this.endpoint);
            Runnable task = null;
            int remainedTasksBeforeThisEvent = 0;
            DuplexChannel duplexChannel = DuplexChannel.this;
            synchronized (duplexChannel) {
                if (DuplexChannel.this.processingTransportEvent) {
                    DuplexChannel.this.queueTransportEvents.add(new Runnable(){

                        @Override
                        public void run() {
                            DuplexChannel.this.receivedMessage(message, null);
                        }
                    });
                    return;
                }
                remainedTasksBeforeThisEvent = DuplexChannel.this.queueTransportEvents.size();
                if (remainedTasksBeforeThisEvent > 0) {
                    task = (Runnable)DuplexChannel.this.queueTransportEvents.remove(0);
                    --remainedTasksBeforeThisEvent;
                }
                DuplexChannel.this.processingTransportEvent = true;
            }
            try {
                if (task != null) {
                    task.run();
                    DuplexChannel.this.executeTasksFromQueue(remainedTasksBeforeThisEvent);
                }
                DuplexChannel.this.receivedMessage(message, null);
                DuplexChannel.this.executeAllTasksFromQueue();
            }
            finally {
                duplexChannel = DuplexChannel.this;
                synchronized (duplexChannel) {
                    DuplexChannel.this.processingTransportEvent = false;
                }
            }
        }

        @Override
        public void run() {
        }
    }

    private class CloseFuture
    implements Future<ChannelClosedEvent> {
        private final OpenCloseContext context;
        private final ChannelClosedEvent closeEvent;

        public CloseFuture() {
            this(null);
        }

        public CloseFuture(OpenCloseContext context) {
            this.context = context;
            this.closeEvent = context == null ? new ChannelClosedEvent((Channel)DuplexChannel.this, (Throwable)null, ChannelState.Closed) : null;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.context == null || this.context.closeEvent != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ChannelClosedEvent get() throws InterruptedException, ExecutionException {
            DuplexChannel duplexChannel = DuplexChannel.this;
            synchronized (duplexChannel) {
                while (!this.isDone()) {
                    DuplexChannel.this.wait();
                }
                return this.context == null ? this.closeEvent : this.context.closeEvent;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ChannelClosedEvent get(long timeout, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            if (timeUnit == null) {
                throw new IllegalArgumentException("null timeUnit", null);
            }
            if (timeout < 0L) {
                throw new IllegalArgumentException("negative timeout", null);
            }
            long t = timeUnit.toMillis(timeout);
            long timeStart = System.currentTimeMillis();
            DuplexChannel duplexChannel = DuplexChannel.this;
            synchronized (duplexChannel) {
                while (!this.isDone()) {
                    long remained = t - (System.currentTimeMillis() - timeStart);
                    if (remained <= 0L) {
                        throw new TimeoutException();
                    }
                    DuplexChannel.this.wait(remained);
                }
                if (this.context == null) {
                    return this.closeEvent;
                }
                return this.context.closeEvent;
            }
        }
    }

    private class AsyncCloseHandler<A>
    extends AsyncOpHandler<ChannelClosedEvent, A>
    implements TimerAction {
        private final TimerActionTicket ticket;

        public AsyncCloseHandler(long timeout, CompletionHandler<ChannelClosedEvent, A> handler, A attachment) {
            super(timeout, handler, attachment);
            this.ticket = DuplexChannel.scheduleAction(timeout, this);
        }

        @Override
        public void onChannelOpened(EventObject event) {
        }

        @Override
        public void onChannelClosed(final ChannelClosedEvent event) {
            DuplexChannel.this.asyncOpHandlers.remove(this);
            if (!this.isCanceled() && this.handler != null) {
                DuplexChannel.this.getInvoker().invoke(new Runnable(){

                    @Override
                    public void run() {
                        if (AsyncCloseHandler.this.cancel()) {
                            AsyncCloseHandler.this.handler.completed((Object)event, AsyncCloseHandler.this.attachment);
                        }
                    }
                });
            }
        }

        @Override
        public void onChannelError(final ChannelErrorEvent event) {
            if (event != null && event.getCause() instanceof ProtocolTimeoutException) {
                DuplexChannel.this.asyncOpHandlers.remove(this);
                if (!this.isCanceled() && this.handler != null) {
                    DuplexChannel.this.getInvoker().invoke(new Runnable(){

                        @Override
                        public void run() {
                            if (AsyncCloseHandler.this.cancel()) {
                                AsyncCloseHandler.this.handler.failed(event.getCause(), AsyncCloseHandler.this.attachment);
                            }
                        }
                    });
                }
            }
        }

        @Override
        public String getOperationName() {
            return "close";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onTimer() {
            if (this.cancel()) {
                AsyncCloseHandler asyncCloseHandler = this;
                synchronized (asyncCloseHandler) {
                    DuplexChannel.this.asyncOpHandlers.remove(this);
                    if (this.handler != null) {
                        DuplexChannel.this.getInvoker().invoke(new Runnable(){

                            @Override
                            public void run() {
                                AsyncCloseHandler.this.handler.failed((Throwable)((Object)DuplexChannel.this.getTimeoutException("close", AsyncCloseHandler.this.timeout)), AsyncCloseHandler.this.attachment);
                            }
                        });
                    }
                }
            }
        }

        @Override
        protected boolean cancel() {
            this.ticket.cancel();
            return super.cancel();
        }

        public String toString() {
            return DuplexChannel.this.getEnpointPrefixInfo() + "CloseTimeoutEventNotifier@DuplexChannel";
        }
    }

    private class AsyncOpenHandler<A>
    extends AsyncOpHandler<EventObject, A> {
        public AsyncOpenHandler(long timeout, CompletionHandler<EventObject, A> handler, A attachment) {
            super(timeout, handler, attachment);
        }

        @Override
        public void onChannelOpened(final EventObject event) {
            DuplexChannel.this.asyncOpHandlers.remove(this);
            if (!this.isCanceled() && this.handler != null) {
                DuplexChannel.this.getInvoker().invoke(new Runnable(){

                    @Override
                    public void run() {
                        if (AsyncOpenHandler.this.cancel()) {
                            AsyncOpenHandler.this.handler.completed((Object)event, AsyncOpenHandler.this.attachment);
                        }
                    }
                });
            }
        }

        @Override
        public void onChannelClosed(final ChannelClosedEvent event) {
            DuplexChannel.this.asyncOpHandlers.remove(this);
            final OpenCloseContext ctx = DuplexChannel.this.openCloseContext;
            if (!this.isCanceled() && this.handler != null) {
                DuplexChannel.this.getInvoker().invoke(new Runnable(){

                    @Override
                    public void run() {
                        if (AsyncOpenHandler.this.cancel()) {
                            Object cause = event.getCause();
                            if (cause == null && ctx.emergencyClosed) {
                                cause = DuplexChannel.this.getEmergencyClosedException();
                            }
                            AsyncOpenHandler.this.handler.failed(cause, AsyncOpenHandler.this.attachment);
                        }
                    }
                });
            }
        }

        @Override
        public void onChannelError(ChannelErrorEvent event) {
        }

        @Override
        public String getOperationName() {
            return "open";
        }

        public String toString() {
            return DuplexChannel.this.getEnpointPrefixInfo() + "AsyncOpenHandler@DuplexChannel";
        }
    }

    private abstract class AsyncOpHandler<V, A>
    implements ChannelListener {
        protected final long timeout;
        private final AtomicBoolean canceled = new AtomicBoolean();
        protected final CompletionHandler<V, A> handler;
        protected final A attachment;

        public AsyncOpHandler(long timeout, CompletionHandler<V, A> handler, A attachment) {
            this.timeout = timeout;
            this.handler = handler;
            this.attachment = attachment;
        }

        protected boolean cancel() {
            return this.canceled.compareAndSet(false, true);
        }

        protected boolean isCanceled() {
            return this.canceled.get();
        }

        public abstract String getOperationName();
    }

    private class OpenCloseContext {
        private Connection connection;
        private volatile int openingStateMods = -1;
        private volatile ChannelOpenedEvent openEvent;
        private volatile boolean emergencyClosed;
        private volatile int closingStateMods = -1;
        private volatile ChannelClosedEvent closeEvent;
        private volatile Future<ChannelOpenedEvent> openFuture;

        private OpenCloseContext() {
        }

        public Future<ChannelOpenedEvent> getOpenFuture() {
            if (this.openFuture == null) {
                this.openFuture = new Future<ChannelOpenedEvent>(){
                    private volatile boolean canceled;

                    @Override
                    public boolean isDone() {
                        return OpenCloseContext.this.openingStateMods != DuplexChannel.this.getStateMods();
                    }

                    @Override
                    public boolean isCancelled() {
                        return this.canceled;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public ChannelOpenedEvent get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                        Throwable cause;
                        if (unit == null) {
                            throw new IllegalArgumentException("unit is null", null);
                        }
                        if (timeout < 0L) {
                            throw new IllegalArgumentException("timeout is negative", null);
                        }
                        long t = unit.toMillis(timeout);
                        long timeStart = System.currentTimeMillis();
                        DuplexChannel duplexChannel = DuplexChannel.this;
                        synchronized (duplexChannel) {
                            while (!this.isDone()) {
                                DuplexChannel.this.wait();
                                if (System.currentTimeMillis() - timeStart < t) continue;
                                if (this.isDone()) break;
                                throw new TimeoutException();
                            }
                        }
                        Throwable throwable = cause = OpenCloseContext.this.closeEvent != null ? OpenCloseContext.this.closeEvent.getCause() : null;
                        if (cause != null) {
                            throw new ExecutionException(cause);
                        }
                        if (OpenCloseContext.this.emergencyClosed) {
                            throw new ExecutionException((Throwable)((Object)DuplexChannel.this.getEmergencyClosedException()));
                        }
                        if (this.isCancelled()) {
                            CancellationException ex = new CancellationException();
                            ex.initCause(null);
                            throw ex;
                        }
                        return OpenCloseContext.this.openEvent;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public ChannelOpenedEvent get() throws InterruptedException, ExecutionException {
                        Throwable cause;
                        DuplexChannel duplexChannel = DuplexChannel.this;
                        synchronized (duplexChannel) {
                            while (!this.isDone()) {
                                DuplexChannel.this.wait();
                            }
                        }
                        Throwable throwable = cause = OpenCloseContext.this.closeEvent != null ? OpenCloseContext.this.closeEvent.getCause() : null;
                        if (cause != null) {
                            throw new ExecutionException(cause);
                        }
                        if (OpenCloseContext.this.emergencyClosed) {
                            throw new ExecutionException((Throwable)((Object)DuplexChannel.this.getEmergencyClosedException()));
                        }
                        if (this.isCancelled()) {
                            CancellationException ex = new CancellationException();
                            ex.initCause(null);
                            throw ex;
                        }
                        return OpenCloseContext.this.openEvent;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public boolean cancel(boolean mayInterruptIfRunning) {
                        DuplexChannel duplexChannel = DuplexChannel.this;
                        synchronized (duplexChannel) {
                            if (this.isDone()) {
                                return false;
                            }
                            if (this.canceled) {
                                return false;
                            }
                            this.canceled = true;
                            DuplexChannel.this.doBeginClose();
                            return true;
                        }
                    }
                };
            }
            return this.openFuture;
        }
    }

    private class PackagerErrorHandler
    implements ProtocolMessagePackagerImpl.ErrorHandler {
        private PackagerErrorHandler() {
        }

        @Override
        public void handleError(ProtocolException e) {
            ChannelErrorEvent event = new ChannelErrorEvent(DuplexChannel.this, (Throwable)((Object)e));
            DuplexChannel.this.getInvoker().invoke((Runnable)(AbstractChannel)DuplexChannel.this.new AbstractChannel.AsyncErrorNotifier(event));
        }
    }

    private class AsyncMessageNotifier
    implements Runnable {
        private final Message message;
        private final MessageHandler handler;

        public AsyncMessageNotifier(Message message, MessageHandler msgHandler) {
            this.message = message;
            this.handler = msgHandler;
        }

        @Override
        public void run() {
            this.handler.onMessage(this.message);
        }
    }

    private class DuplexChannelConnHandler
    implements ConnectionHandler,
    ProtocolMessagePackagerImpl.MessageHandler {
        private final OpenCloseContext openCloseContext;
        private final Endpoint endpoint;

        public DuplexChannelConnHandler(OpenCloseContext openCloseContext, Endpoint endpoint) {
            this.openCloseContext = openCloseContext;
            this.endpoint = endpoint;
        }

        public void onConnectionEstablished() {
            DuplexChannel.this.onConnectionEstablished(this.openCloseContext);
        }

        @Override
        public void onMessage(Message message) {
            DuplexChannel.this.receivedMessage(message, this.endpoint);
        }

        public void onConnectionClosed(ConnectionClosedEvent event) {
            DuplexChannel.this.onConnectionClosed(this.openCloseContext, event);
        }
    }
}

