/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol;

import com.genesyslab.platform.commons.PsdkCustomization;
import com.genesyslab.platform.commons.connection.configuration.ConnectionConfiguration;
import com.genesyslab.platform.commons.connection.configuration.ManagedConfiguration;
import com.genesyslab.platform.commons.connection.configuration.PropertyConfiguration;
import com.genesyslab.platform.commons.connection.tls.SSLExtendedOptions;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.UriInfo;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import javax.net.ssl.SSLContext;

public class Endpoint
implements Cloneable {
    private static final ILogger log = Log.getLogger(Endpoint.class);
    protected boolean hasName;
    protected String name;
    protected String host;
    protected int port;
    protected SSLContext sslContext;
    protected SSLExtendedOptions sslOptions;
    protected volatile String spn;
    protected ManagedConfiguration connConfig;
    protected String tostringPrefix;
    protected static final String defaultPrefix = "psdkendpoint";
    private URI uri;

    public Endpoint(String host, int port) {
        this(null, host, port);
    }

    public Endpoint(String name, String host, int port) {
        this.setEndpointName(name, host, port);
        if (host == null || host.length() == 0) {
            throw new NullPointerException("host is null or empty");
        }
        this.validatePort(port);
        this.host = host;
        this.port = port;
        this.createUri(name, host, port, Endpoint.isSupportedURIWithIncorrectSyntax());
        this.initConnConfig(null);
    }

    public Endpoint(String host, int port, ConnectionConfiguration connConf) {
        this(null, host, port, connConf);
    }

    public Endpoint(String name, String host, int port, ConnectionConfiguration connConf) {
        this(name, host, port);
        this.initConnConfig(connConf);
    }

    public Endpoint(String host, int port, ConnectionConfiguration connConf, boolean tlsEnabled, SSLContext sslContext, SSLExtendedOptions sslOptions) {
        this(null, host, port, connConf, tlsEnabled, sslContext, sslOptions);
    }

    public Endpoint(String name, String host, int port, ConnectionConfiguration connConf, boolean tlsEnabled, SSLContext sslContext, SSLExtendedOptions sslOptions) {
        this(name, host, port, connConf);
        this.initConnConfig(connConf);
        this.connConfig.setBoolean("tls", tlsEnabled);
        this.sslContext = sslContext;
        this.sslOptions = sslOptions;
    }

    public Endpoint(URI uri) {
        this(null, uri);
    }

    public Endpoint(URI uri, boolean tlsEnabled, SSLContext sslContext, SSLExtendedOptions sslOptions) {
        this(null, uri, tlsEnabled, sslContext, sslOptions);
    }

    public Endpoint(String name, URI uri) {
        UriInfo info = UriInfo.get(uri);
        if (name == null) {
            this.setEndpointName(info.user, info.host, info.port);
        } else {
            this.setEndpointName(name, info.host, info.port);
        }
        this.host = info.host;
        if (this.host == null || this.host.length() == 0) {
            throw new IllegalArgumentException("can't extract valid host address");
        }
        this.port = info.port;
        this.validatePort(this.port);
        String query = info.query;
        if (null != query) {
            this.initConnConfig((ConnectionConfiguration)new PropertyConfiguration(query));
        } else {
            this.initConnConfig(null);
        }
        this.createUri(this.name, this.host, this.port, Endpoint.isSupportedURIWithIncorrectSyntax());
    }

    public Endpoint(String name, URI uri, boolean tlsEnabled, SSLContext sslContext, SSLExtendedOptions sslOptions) {
        this(name, uri);
        this.initConnConfig(null);
        this.connConfig.setBoolean("tls", tlsEnabled);
        this.sslContext = sslContext;
        this.sslOptions = sslOptions;
    }

    public Endpoint(String name, ConnectionConfiguration connConf) {
        this(name, name, 0, connConf);
    }

    protected Endpoint(String name) {
        this.name = name == null ? "" : name;
        this.initConnConfig(null);
    }

    private void initConnConfig(ConnectionConfiguration connConf) {
        this.connConfig = connConf != null ? new ManagedConfiguration(connConf) : new ManagedConfiguration((ConnectionConfiguration)new PropertyConfiguration());
    }

    protected void validatePort(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid port specified (" + port + "), allowed range is 1..65535");
        }
    }

    public boolean hasName() {
        return this.hasName;
    }

    public String getName() {
        return this.name;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public URI getUri() {
        return this.uri;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.tostringPrefix != null && this.tostringPrefix.length() > 0) {
            buf.append(this.tostringPrefix).append(" - ");
        }
        buf.append("tcp://").append(this.host).append(':').append(this.port);
        if (this.spn != null) {
            buf.append(" spn:").append(this.spn);
        }
        return buf.toString();
    }

    public ConnectionConfiguration getConfiguration() {
        return this.connConfig;
    }

    void setConfiguration(ConnectionConfiguration connConf) {
        ManagedConfiguration cfg = this.connConfig;
        if (cfg != null) {
            cfg.setConfiguration(connConf);
        } else {
            this.connConfig = new ManagedConfiguration(connConf);
        }
    }

    public SSLExtendedOptions getSSLOptions() {
        return this.sslOptions;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    private void createUri(String name, String host, int port, boolean supportURIWIthIncorrectSyntax) {
        String userInfo = name;
        try {
            if (name != null && name.length() == 0) {
                userInfo = null;
            }
            this.uri = supportURIWIthIncorrectSyntax ? (userInfo == null ? new URI("tcp://" + URLEncoder.encode(host) + ":" + port) : new URI("tcp://" + URLEncoder.encode(userInfo) + "@" + URLEncoder.encode(host) + ":" + port)) : new URI("tcp", userInfo, host, port, null, null, null);
        }
        catch (URISyntaxException e) {
            if (log.isDebug()) {
                log.debug((Object)("Can't build proper URI for host=" + host + " user=" + userInfo + " port=" + port), (Throwable)e);
            }
            throw new IllegalArgumentException("Can't build proper URI", e);
        }
    }

    protected void setEndpointName(String name, String host, int port) {
        boolean bl = this.hasName = name != null && name.length() > 0;
        if (this.hasName) {
            this.name = this.tostringPrefix = name;
        } else {
            StringBuilder buf = new StringBuilder();
            buf.append(defaultPrefix).append('@');
            if (host != null && host.length() > 0) {
                buf.append(host);
            } else {
                buf.append("[anylocal]");
            }
            buf.append(':').append(port);
            this.name = buf.toString();
            this.tostringPrefix = defaultPrefix;
        }
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        if (this.name != null) {
            hash += hash * 31 + this.name.hashCode();
        }
        if (this.host != null) {
            hash += hash * 31 + this.host.hashCode();
        }
        return hash ^= this.port;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Endpoint other = (Endpoint)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        return this.port == other.port;
    }

    public Object clone() throws CloneNotSupportedException {
        Endpoint result = (Endpoint)super.clone();
        try {
            ManagedConfiguration cfg = this.connConfig;
            result.connConfig = cfg == null ? null : (ManagedConfiguration)cfg.clone();
        }
        catch (CloneNotSupportedException e) {
            result.connConfig = this.connConfig;
        }
        return result;
    }

    public Endpoint setSPN(String SPN) {
        this.spn = SPN;
        return this;
    }

    public String getSPN() {
        return this.spn;
    }

    private static boolean isSupportedURIWithIncorrectSyntax() {
        return PsdkCustomization.getBoolOption((PsdkCustomization.PsdkOption)PsdkCustomization.PsdkOption.SupportURIWithIncorrectSyntax, (Boolean)true);
    }
}

