/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol;

import com.genesyslab.platform.commons.connection.ConnectionClosedEvent;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.ReferenceBuilder;
import com.genesyslab.platform.commons.protocol.Referenceable;
import com.genesyslab.platform.commons.protocol.RequestFuture;
import com.genesyslab.platform.commons.threading.AsyncInvoker;
import com.genesyslab.platform.commons.threading.CompletionHandler;
import com.genesyslab.platform.commons.timer.TimerAction;
import com.genesyslab.platform.commons.timer.TimerActionTicket;
import com.genesyslab.platform.commons.timer.TimerFactory;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public final class MessageCorrelator {
    private ReferenceBuilder refBuilder;
    private final Map<Object, MessageEntryRef> entries = new HashMap<Object, MessageEntryRef>();
    private final ReferenceQueue<MessageEntryImpl<?>> entriesRefQueue = new ReferenceQueue();
    private static final ILogger log = Log.getLogger((String)("PSDK.perf." + MessageCorrelator.class.getName()));
    private final boolean isWarn = log.isWarn();
    private int maxEntriesCnt = 0;

    public MessageCorrelator(ReferenceBuilder refBuilder) {
        this.refBuilder = refBuilder;
    }

    @Deprecated
    public MessageEntry registerMessage(Message message) {
        return this.registerMessage(message, null, null, null, -1L, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> MessageEntry registerMessage(Message message, T attachment, CompletionHandler<Message, T> handler, AsyncInvoker invoker, long timeout, int stateMods) {
        Object reference = this.refBuilder.retreiveReference(message);
        if (reference != null) {
            MessageEntryImpl<T> entry = new MessageEntryImpl<T>(message, attachment, handler, invoker, timeout, stateMods);
            Map<Object, MessageEntryRef> map = this.entries;
            synchronized (map) {
                int entriesCnt;
                int entriesDt;
                this.expungeStaleEntries();
                MessageEntryRef prevRec = this.entries.get(reference);
                if (prevRec != null) {
                    IllegalArgumentException ex = new IllegalArgumentException("Response correlator already contains record with given ReferenceId");
                    entry.setRequestFailure(ex);
                    throw ex;
                }
                this.entries.put(reference, new MessageEntryRef(entry));
                if (this.isWarn && (entriesDt = (entriesCnt = this.entries.size()) - this.maxEntriesCnt) >= 1000) {
                    log.warn((Object)("Entries count has reached " + entriesCnt));
                    this.maxEntriesCnt = entriesCnt;
                }
            }
            return entry;
        }
        return null;
    }

    public void unregisterEntry(MessageEntry entry) {
        this.unregisterEntry(entry, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterEntry(MessageEntry entry, Throwable cause) {
        if (entry == null) {
            throw new IllegalArgumentException("argument entry is null");
        }
        Object reference = this.refBuilder.retreiveReference(entry.getRequestMessage());
        if (reference != null) {
            Map<Object, MessageEntryRef> map = this.entries;
            synchronized (map) {
                this.entries.remove(reference);
            }
            if (entry instanceof MessageEntryImpl) {
                ((MessageEntryImpl)entry).setRequestFailure(cause);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageEntry correlate(Message message) {
        MessageEntryImpl entry = null;
        Object reference = this.refBuilder.retreiveReference(message);
        if (reference != null) {
            Map<Object, MessageEntryRef> map = this.entries;
            synchronized (map) {
                MessageEntryRef entryRef;
                if (!this.entries.isEmpty() && (entryRef = this.entries.remove(reference)) != null) {
                    entry = (MessageEntryImpl)entryRef.get();
                }
            }
            if (entry != null && !entry.setResponseMessage(message)) {
                entry = null;
            }
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message waitResponse(MessageEntry entry, long timeout) {
        Message response = null;
        try {
            response = timeout < 0L ? entry.getResponseMessage() : entry.getResponseMessage(timeout);
        }
        catch (InterruptedException e) {
            Log.getLogger(MessageCorrelator.class).debug((Object)"MessageCorrelator.waitResponse() is interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        finally {
            if (response == null) {
                Map<Object, MessageEntryRef> map = this.entries;
                synchronized (map) {
                    if (!this.entries.isEmpty()) {
                        this.entries.remove(this.refBuilder.retreiveReference(entry.getRequestMessage()));
                    }
                }
            }
        }
        return response;
    }

    @Deprecated
    public void releaseWaiters() {
        this.releaseWaiters(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseWaiters(ConnectionClosedEvent event) {
        Map<Object, MessageEntryRef> map = this.entries;
        synchronized (map) {
            for (MessageEntryRef o : this.entries.values()) {
                MessageEntryImpl entry;
                if (!(o instanceof MessageEntryRef) || (entry = (MessageEntryImpl)o.get()) == null) continue;
                Throwable reason = null;
                if (event != null) {
                    reason = event.getCause();
                }
                entry.setRequestFailure(reason);
            }
            this.entries.clear();
        }
    }

    private void expungeStaleEntries() {
        Reference<MessageEntryImpl<?>> polled;
        while ((polled = this.entriesRefQueue.poll()) != null) {
            MessageEntryRef entryRef;
            Object reference;
            if (!(polled instanceof MessageEntryRef) || (reference = (entryRef = (MessageEntryRef)polled).getReference()) == null) continue;
            this.entries.remove(reference);
        }
    }

    private class MessageEntryRef
    extends WeakReference<MessageEntryImpl<?>> {
        private final Object reference;

        public MessageEntryRef(MessageEntryImpl<?> referent) {
            super(referent, MessageCorrelator.this.entriesRefQueue);
            this.reference = MessageCorrelator.this.refBuilder.retreiveReference(((MessageEntryImpl)referent).requestMessage);
        }

        public Object getReference() {
            return this.reference;
        }
    }

    private static class MessageEntryImpl<T>
    implements MessageEntry,
    RequestFuture {
        private Message responseMessage;
        private volatile Throwable failureReason;
        private volatile Message requestMessage;
        private AsyncInvoker asyncInvoker;
        private CompletionHandler<Message, T> completionHandler;
        private T completionHandlerParam;
        private final AtomicBoolean isDoneFlag = new AtomicBoolean(false);
        private boolean timedout = false;
        private boolean canceled = false;
        private Thread thread;
        private TimerActionTicket timeoutActionTicket = null;
        private final int stateMods;

        public MessageEntryImpl(Message message, T attachment, CompletionHandler<Message, T> callback, AsyncInvoker invoker, long timeout, int stateMods) {
            this.requestMessage = message;
            this.asyncInvoker = invoker;
            this.completionHandler = callback;
            this.completionHandlerParam = attachment;
            this.stateMods = stateMods;
            if (this.completionHandler != null) {
                if (invoker == null) {
                    throw new IllegalArgumentException("AsyncInvoker is required to use completion handler");
                }
                if (timeout <= 0L) {
                    throw new IllegalArgumentException("Positive timeout is required for completion handler usage");
                }
            }
            if (timeout > 0L) {
                this.timeoutActionTicket = TimerFactory.getTimer().schedule(timeout, (TimerAction)new TimeoutAction());
            }
        }

        @Override
        public int getInitialStateMods() {
            return this.stateMods;
        }

        @Override
        public Throwable getFailureReason() {
            return this.failureReason;
        }

        @Override
        public Message getRequestMessage() {
            return this.requestMessage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Message getResponseMessage() throws InterruptedException {
            AtomicBoolean atomicBoolean = this.isDoneFlag;
            synchronized (atomicBoolean) {
                while (!this.isDoneFlag.get()) {
                    this.isDoneFlag.wait();
                }
                return this.responseMessage;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Message getResponseMessage(long timeout) throws InterruptedException {
            AtomicBoolean atomicBoolean = this.isDoneFlag;
            synchronized (atomicBoolean) {
                if (timeout > 0L) {
                    long timeoutMark = System.currentTimeMillis() + timeout;
                    long waitTime = timeout;
                    while (!this.isDoneFlag.get()) {
                        this.isDoneFlag.wait(waitTime);
                        waitTime = timeoutMark - System.currentTimeMillis();
                        if (waitTime > 0L) continue;
                        break;
                    }
                } else {
                    while (!this.isDoneFlag.get()) {
                        this.isDoneFlag.wait();
                    }
                }
                return this.responseMessage;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean setResponseMessage(Message responseMessage) {
            AtomicBoolean atomicBoolean = this.isDoneFlag;
            synchronized (atomicBoolean) {
                if (this.isDoneFlag.get()) {
                    return false;
                }
                this.responseMessage = responseMessage;
                this.cancelTimer();
                this.isDoneFlag.set(true);
                if (this.completionHandler != null) {
                    this.failureReason = null;
                    this.asyncInvoker.invoke((Runnable)new ResponseNotifier());
                }
                this.isDoneFlag.notifyAll();
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setRequestFailure(Throwable throwable) {
            AtomicBoolean atomicBoolean = this.isDoneFlag;
            synchronized (atomicBoolean) {
                if (this.isDoneFlag.get()) {
                    return;
                }
                this.failureReason = throwable;
                this.cancelTimer();
                this.isDoneFlag.set(true);
                if (this.completionHandler != null) {
                    this.asyncInvoker.invoke((Runnable)new FailureNotifier());
                }
                this.isDoneFlag.notifyAll();
            }
        }

        private void cancelTimer() {
            if (this.timeoutActionTicket != null) {
                this.timeoutActionTicket.cancel();
                this.timeoutActionTicket = null;
            }
        }

        public String toString() {
            String ret = "Correlator Entry for request " + this.requestMessage.messageName() + "/" + this.requestMessage.messageId();
            if (this.requestMessage instanceof Referenceable) {
                ret = ret + ", ref=" + ((Referenceable)((Object)this.requestMessage)).retreiveReference();
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            AtomicBoolean atomicBoolean = this.isDoneFlag;
            synchronized (atomicBoolean) {
                Thread thrd;
                if (this.isDoneFlag.get() || this.canceled || this.timedout || this.responseMessage != null) {
                    return false;
                }
                this.canceled = true;
                if (mayInterruptIfRunning && (thrd = this.thread) != null) {
                    this.thread = null;
                    thrd.interrupt();
                }
                this.setRequestFailure(new CancellationException());
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onTimeout() {
            AtomicBoolean atomicBoolean = this.isDoneFlag;
            synchronized (atomicBoolean) {
                if (this.isDoneFlag.get() || this.canceled || this.timedout || this.responseMessage != null) {
                    return;
                }
                this.timedout = true;
                this.setRequestFailure(new TimeoutException());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Message get() throws InterruptedException {
            this.thread = Thread.currentThread();
            try {
                Message message = this.getResponse();
                return message;
            }
            finally {
                this.thread = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Message get(long timeout) throws InterruptedException {
            this.thread = Thread.currentThread();
            try {
                Message message = this.getResponse(timeout);
                return message;
            }
            finally {
                this.thread = null;
            }
        }

        @Override
        public Message get(long timeout, TimeUnit unit) throws InterruptedException {
            long tmms = timeout;
            if (unit != null) {
                tmms = unit.toMillis(timeout);
            }
            return this.get(tmms);
        }

        @Override
        @Deprecated
        public boolean isCanceled() {
            return this.canceled;
        }

        @Override
        public boolean isCancelled() {
            return this.canceled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isDone() {
            AtomicBoolean atomicBoolean = this.isDoneFlag;
            synchronized (atomicBoolean) {
                return this.isDoneFlag.get();
            }
        }

        @Override
        public Message getResponse() throws InterruptedException {
            try {
                return this.getResponseMessage();
            }
            catch (InterruptedException e) {
                this.canceled = true;
                throw e;
            }
        }

        @Override
        public Message getResponse(long timeout) throws InterruptedException {
            try {
                return this.getResponseMessage(timeout);
            }
            catch (InterruptedException e) {
                this.canceled = true;
                throw e;
            }
        }

        @Override
        public Message getRequest() {
            return this.getRequestMessage();
        }

        private class FailureNotifier
        implements Runnable {
            private final Throwable reason;

            private FailureNotifier() {
                this.reason = MessageEntryImpl.this.failureReason != null ? MessageEntryImpl.this.failureReason : new CancellationException();
            }

            @Override
            public void run() {
                MessageEntryImpl.this.completionHandler.failed(this.reason, MessageEntryImpl.this.completionHandlerParam);
            }
        }

        private class ResponseNotifier
        implements Runnable {
            private ResponseNotifier() {
            }

            @Override
            public void run() {
                MessageEntryImpl.this.completionHandler.completed((Object)MessageEntryImpl.this.responseMessage, MessageEntryImpl.this.completionHandlerParam);
            }
        }

        protected class TimeoutAction
        implements TimerAction {
            protected TimeoutAction() {
            }

            public void onTimer() {
                MessageEntryImpl.this.onTimeout();
            }

            public String toString() {
                String ret = "TimeoutAction(" + MessageEntryImpl.this.requestMessage.messageName() + "/" + MessageEntryImpl.this.requestMessage.messageId();
                if (MessageEntryImpl.this.requestMessage instanceof Referenceable) {
                    ret = ret + ",ref=" + ((Referenceable)((Object)MessageEntryImpl.this.requestMessage)).retreiveReference();
                }
                ret = ret + ")";
                return ret;
            }
        }
    }

    public static interface MessageEntry {
        public int getInitialStateMods();

        public Throwable getFailureReason();

        public Message getRequestMessage();

        public Message getResponseMessage() throws InterruptedException;

        public Message getResponseMessage(long var1) throws InterruptedException;
    }
}

