/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

public final class ProtocolDescription {
    private String sdkName;
    private String protocolName;
    private String schemaURI;
    private volatile boolean hashComputed = false;
    private int hash;

    public ProtocolDescription(String sdkName, String protocolName) {
        this.sdkName = sdkName;
        this.protocolName = protocolName;
    }

    public String getSdkName() {
        return this.sdkName;
    }

    public String getProtocolName() {
        return this.protocolName;
    }

    public String getNS() {
        if (this.schemaURI == null) {
            this.createSchemaURI();
        }
        return this.schemaURI;
    }

    private void createSchemaURI() {
        if (this.sdkName == null && this.protocolName == null) {
            return;
        }
        StringBuffer buf = new StringBuffer("http://schemas.genesyslab.com/Protocols/");
        buf.append(this.sdkName).append('/').append(this.protocolName).append("/2005/");
        this.schemaURI = buf.toString();
    }

    public String toString() {
        return (this.sdkName == null ? "" : this.sdkName) + '.' + (this.protocolName == null ? "" : this.protocolName);
    }

    public int hashCode() {
        if (this.hashComputed) {
            return this.hash;
        }
        int hashCode = 17;
        if (this.sdkName != null) {
            hashCode += this.sdkName.hashCode() * 19;
        }
        if (this.protocolName != null) {
            hashCode += this.protocolName.hashCode() * 29;
        }
        this.hash = hashCode;
        this.hashComputed = true;
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProtocolDescription)) {
            return false;
        }
        ProtocolDescription other = (ProtocolDescription)obj;
        return this.hashCode() == other.hashCode();
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Tag {
        public String sdkName();

        public String protocolName();
    }
}

