/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol;

import com.genesyslab.platform.commons.protocol.AbstractChannel;
import com.genesyslab.platform.commons.protocol.ChannelManager;
import com.genesyslab.platform.commons.protocol.ProtocolDescription;
import com.genesyslab.platform.commons.protocol.ServerChannel;
import com.genesyslab.platform.commons.protocol.ServerChannelManagerMBean;
import java.util.concurrent.atomic.AtomicInteger;

final class ServerChannelManager
extends ChannelManager
implements ServerChannelManagerMBean {
    private AtomicInteger clientsAcceptedCounter = new AtomicInteger(0);

    private ServerChannelManager(ServerChannel channel) {
        super(channel, "ServerChannel", ServerChannelManager.checkAndGetChannelProtocolDescription(channel));
        this.createMBeanNameId();
    }

    private static String checkAndGetChannelProtocolDescription(ServerChannel channel) {
        ProtocolDescription protocolDescription = channel.getProtocolDescription();
        if (protocolDescription == null) {
            throw new IllegalArgumentException("argument channel doesn't contain protocol description");
        }
        return protocolDescription.toString();
    }

    public static ServerChannelManager createManager(ServerChannel channel) {
        return new ServerChannelManager(channel);
    }

    @Override
    public int getActiveClientsNumber() {
        AbstractChannel channel = (AbstractChannel)this.channelRef.get();
        if (channel != null) {
            return ((ServerChannel)channel).getChannels().size();
        }
        return 0;
    }

    @Override
    public int getClientsAcceptedNumber() {
        return this.clientsAcceptedCounter.get();
    }

    public void incClientsAcceptedNumber() {
        this.clientsAcceptedCounter.incrementAndGet();
    }
}

