/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol.auth;

import com.genesyslab.platform.commons.collections.util.Hex;
import com.genesyslab.platform.commons.protocol.auth.AuthTicket;
import com.genesyslab.platform.commons.protocol.auth.AuthTicketGSSSupport;
import java.util.Date;
import java.util.Locale;

public class AuthTicketData
implements AuthTicket,
AuthTicketGSSSupport {
    private byte[] ticketBytes;
    private String servicePrincipalName;
    private String userPrincipalName;
    private Date authTime;
    private Date startTime;
    private Date endTime;
    private Date renewTill;
    private boolean GSSTicket;

    public AuthTicketData(byte[] ticketBytes, boolean GSSTicket) {
        this.ticketBytes = this.cloneBytes(ticketBytes);
        this.GSSTicket = GSSTicket;
    }

    public AuthTicketData(byte[] ticketBytes, String servicePrincipalName, boolean GSSTicket) {
        this.ticketBytes = this.cloneBytes(ticketBytes);
        this.servicePrincipalName = servicePrincipalName;
        this.GSSTicket = GSSTicket;
    }

    public AuthTicketData(byte[] ticketBytes, String servicePrincipalName, String userPrincipalName, boolean GSSTicket) {
        this.ticketBytes = this.cloneBytes(ticketBytes);
        this.servicePrincipalName = servicePrincipalName;
        this.userPrincipalName = userPrincipalName;
        this.GSSTicket = GSSTicket;
    }

    public AuthTicketData(byte[] ticketBytes, String servicePrincipalName, String userPrincipalName, Date authTime, Date startTime, Date endTime, Date renewTill, boolean GSSTicket) {
        this.ticketBytes = this.cloneBytes(ticketBytes);
        this.servicePrincipalName = servicePrincipalName;
        this.userPrincipalName = userPrincipalName;
        this.authTime = this.cloneDate(authTime);
        this.startTime = this.cloneDate(startTime);
        this.endTime = this.cloneDate(endTime);
        this.renewTill = this.cloneDate(renewTill);
        this.GSSTicket = GSSTicket;
    }

    Date cloneDate(Date d) {
        return null == d ? null : (Date)d.clone();
    }

    byte[] cloneBytes(byte[] bytes) {
        return null == bytes ? null : (byte[])bytes.clone();
    }

    @Override
    public String getUserPrincipalName() {
        return this.userPrincipalName;
    }

    @Override
    public String getServicePrincipalName() {
        return this.servicePrincipalName;
    }

    @Override
    public byte[] getTicketBytes() {
        return this.cloneBytes(this.ticketBytes);
    }

    @Override
    public String getTicketHex() {
        return new String(Hex.encodeHex((byte[])this.ticketBytes)).toUpperCase(Locale.ENGLISH);
    }

    @Override
    public Date getAuthTime() {
        return this.cloneDate(this.authTime);
    }

    @Override
    public Date getStartTime() {
        return this.cloneDate(this.startTime);
    }

    @Override
    public Date getEndTime() {
        return this.cloneDate(this.endTime);
    }

    @Override
    public Date getRenewTill() {
        return this.cloneDate(this.renewTill);
    }

    @Override
    public boolean isGSSTicket() {
        return this.GSSTicket;
    }
}

