/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol.auth;

import com.genesyslab.platform.commons.PsdkCustomization;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.auth.AuthTicketAcquirer;
import com.genesyslab.platform.commons.protocol.auth.KerberosTicketAcquirer;

public class DefaultAuthTicketAcquirer {
    private static final ILogger log = Log.getLogger(KerberosTicketAcquirer.class);
    @Deprecated
    public static final String SYSPROP_TICKET_ACQUIRER = "com.genesys.protocol.auth.ticket.acquirer";
    private static volatile AuthTicketAcquirer INSTANCE;

    private DefaultAuthTicketAcquirer() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AuthTicketAcquirer getInstance() throws Exception {
        if (INSTANCE != null) return INSTANCE;
        Class<DefaultAuthTicketAcquirer> clazz = DefaultAuthTicketAcquirer.class;
        synchronized (DefaultAuthTicketAcquirer.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = DefaultAuthTicketAcquirer.create();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private static AuthTicketAcquirer create() throws Exception {
        String acquirerClassName = PsdkCustomization.getOption((PsdkCustomization.PsdkOption)PsdkCustomization.PsdkOption.AuthorizationTicketAcquirer);
        if (acquirerClassName != null && acquirerClassName.length() > 0) {
            try {
                log.info((Object)("Creating default auth ticket acquirer: " + acquirerClassName));
                AuthTicketAcquirer provider = (AuthTicketAcquirer)Class.forName(acquirerClassName).newInstance();
                return provider;
            }
            catch (Exception e) {
                log.error((Object)("error create default auth ticket acqurer: " + acquirerClassName), (Throwable)e);
            }
        }
        try {
            log.info((Object)"Creating default auth ticket acquirer: KerberosTicketAcquirer");
            return new KerberosTicketAcquirer();
        }
        catch (Exception e) {
            log.error((Object)"error create default auth ticket acquirer: KerberosTicketAcquirer", (Throwable)e);
            throw e;
        }
    }
}

