/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol.runtime;

import java.util.Date;

public final class MessageTypeResolver {
    private MessageTypeResolver() {
    }

    public static boolean isString(String sType) {
        return "string".equals(sType) || "String".equals(sType) || "System.String".equals(sType);
    }

    public static boolean isBinary(String sType) {
        return "binary".equals(sType) || "byte[]".equals(sType) || "System.Byte[]".equals(sType);
    }

    public static boolean isInt(String sType) {
        return "int".equals(sType) || "Integer".equals(sType) || "Genesyslab.Platform.Commons.Collections.NullableInt".equals(sType) || "System.Int32".equals(sType);
    }

    public static boolean isLong(String sType) {
        return "long".equals(sType) || "Long".equals(sType);
    }

    public static boolean isBoolean(String sType) {
        return "boolean".equals(sType) || "Boolean".equals(sType) || "Genesyslab.Platform.Commons.Collections.NullableBool".equals(sType) || "System.Boolean".equals(sType);
    }

    public static boolean isDateTime(String sType) {
        return "Date".equals(sType) || "Genesyslab.Platform.Commons.Collections.NullableDateTime".equals(sType) || "System.DateTime".equals(sType);
    }

    public static boolean isKVList(String sType) {
        return "kvlist".equals(sType) || "Genesyslab.Platform.Commons.Collections.KeyValueCollection".equals(sType);
    }

    public static Class classForName(String name, String javaPrefix, String netPrefix) throws ClassNotFoundException {
        return MessageTypeResolver.classForName(name, javaPrefix, netPrefix, null);
    }

    public static Class classForName(String name, String javaPrefix, String netPrefix, ClassLoader classLoader) throws ClassNotFoundException {
        if (MessageTypeResolver.isString(name)) {
            return String.class;
        }
        if (MessageTypeResolver.isInt(name)) {
            return Integer.class;
        }
        if (MessageTypeResolver.isLong(name)) {
            return Long.class;
        }
        if (MessageTypeResolver.isBoolean(name)) {
            return Boolean.class;
        }
        if (MessageTypeResolver.isDateTime(name)) {
            return Date.class;
        }
        if (name.startsWith(netPrefix)) {
            name = name.substring(netPrefix.length());
        }
        if (name.startsWith("Nullable")) {
            name = name.substring("Nullable".length());
        }
        if (classLoader == null) {
            return Class.forName(javaPrefix + name);
        }
        return classLoader.loadClass(javaPrefix + name);
    }
}

