/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol.runtime;

import com.genesyslab.platform.commons.PlatformException;
import com.genesyslab.platform.commons.PsdkCustomization;
import com.genesyslab.platform.commons.connection.MessagePackager;
import com.genesyslab.platform.commons.connection.MessageTransport;
import com.genesyslab.platform.commons.connection.configuration.ConnectionConfiguration;
import com.genesyslab.platform.commons.connection.impl.ConnectionImpl;
import com.genesyslab.platform.commons.connection.impl.EncodingSupport;
import com.genesyslab.platform.commons.connection.impl.xml.XmlStructureHandler;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.ConfigurationSupport;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.MessageFilter;
import com.genesyslab.platform.commons.protocol.MissingAttributeException;
import com.genesyslab.platform.commons.protocol.ProtocolException;
import com.genesyslab.platform.commons.protocol.ProtocolFactory;
import com.genesyslab.platform.commons.protocol.runtime.AbstractCodecAttributeDescription;
import com.genesyslab.platform.commons.protocol.runtime.AttributeDescription;
import com.genesyslab.platform.commons.protocol.runtime.CodecAttributeDescription;
import com.genesyslab.platform.commons.protocol.runtime.CodecSupport;
import com.genesyslab.platform.commons.protocol.runtime.DataSupport;
import com.genesyslab.platform.commons.protocol.runtime.LazyParsingPossible;
import com.genesyslab.platform.commons.protocol.runtime.MetaData;
import com.genesyslab.platform.commons.protocol.runtime.ProtocolUnknownMessage;
import com.genesyslab.platform.commons.protocol.runtime.codec.AttributeTypeCodec;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecException;
import com.genesyslab.platform.commons.protocol.runtime.codec.CustomPackager;
import com.genesyslab.platform.commons.protocol.runtime.codec.CustomTypeCodec;
import com.genesyslab.platform.commons.protocol.runtime.codec.EnumCodec;
import com.genesyslab.platform.commons.protocol.runtime.codec.PackagerSuppressible;
import com.genesyslab.platform.commons.protocol.runtime.codec.ReverseDirectionCodecSupport;
import com.genesyslab.platform.commons.util.DeepHashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class ProtocolMessagePackagerImpl
implements MessagePackager,
XmlStructureHandler,
CodecSupport {
    private static final ILogger log = Log.getLogger(ProtocolMessagePackagerImpl.class);
    private ConnectionImpl conn;
    private ProtocolFactory factory;
    private MessageHandler messageHandler;
    private ErrorHandler errorHandler;
    private Object protocolData;
    private ConnectionConfiguration config;
    private volatile MessageFilter logfilter;
    private boolean reversedDirection;

    public ProtocolMessagePackagerImpl(ProtocolFactory factory, ConnectionConfiguration config, MessageHandler messageHandler, ErrorHandler errorHandler) {
        this.factory = factory;
        this.config = config;
        this.messageHandler = messageHandler;
        this.errorHandler = errorHandler;
    }

    public boolean isReversedDirection() {
        return this.reversedDirection;
    }

    public void setReversedDirection(boolean reversedDirection) {
        this.reversedDirection = reversedDirection;
    }

    public void configure(ConnectionConfiguration config) {
        this.config = config;
    }

    public void setLogMessageFilter(MessageFilter filter) {
        this.logfilter = filter;
    }

    public boolean isLazyParsingEnabled() {
        Boolean option = PsdkCustomization.getBoolOption((PsdkCustomization.PsdkOption)PsdkCustomization.PsdkOption.DisableXmlConfData, null);
        if (option != null && option.booleanValue()) {
            return false;
        }
        if (this.config != null) {
            return this.config.getBoolean("lazy_parsing_enabled", true);
        }
        option = PsdkCustomization.getBoolOption((PsdkCustomization.PsdkOption)PsdkCustomization.PsdkOption.DisableLazyParsing, (String)this.factory.getProtocolDescription().getProtocolName(), null);
        return null == option || option == false;
    }

    public void sendMessage(Object message) throws PlatformException {
        Message msg = (Message)message;
        MessageTransport transport = this.conn.getConnection().getMessageTransport();
        try {
            Object state = transport.onNewMessage(message, msg.messageId());
            DataSupport ds = MetaData.asDataSupport(msg);
            this.transportData(transport, state, ds, msg);
            transport.onMessageEnd(state);
        }
        catch (PlatformException e) {
            log.warn((Object)"Problems sending message", (Throwable)e);
            throw e;
        }
    }

    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    private void transportData(MessageTransport transport, Object state, DataSupport data, Message message) throws PlatformException {
        Map attributes;
        Map compounds = data.getCompounds();
        if (compounds != null) {
            this.transportCompounds(transport, state, compounds, message);
        }
        if ((attributes = data.attributes()) != null) {
            this.transportFlatAttributes(transport, state, attributes, data, message);
        }
    }

    private void transportFlatAttributes(MessageTransport transport, Object state, Map attributes, DataSupport data, Message message) throws PlatformException {
        MetaData meta = data.getMetaData();
        if (attributes == null) {
            throw new IllegalArgumentException("argument attributes is null");
        }
        if (message == null) {
            throw new IllegalArgumentException("argument message is null");
        }
        for (Map.Entry o : attributes.entrySet()) {
            Map.Entry entry = o;
            Object value = entry.getValue();
            if (value == null) continue;
            String key = entry.getKey().toString();
            if (meta == null) {
                throw new IllegalArgumentException("argument meta is null");
            }
            state = this.transportAttribute(message, transport, state, meta.getAttributeDescription(key), value);
        }
    }

    private Object transportAttribute(Message message, MessageTransport transport, Object state, AttributeDescription key, Object value) throws PlatformException {
        CustomTypeCodec codec = this.getCodec(key, message);
        if (codec != null) {
            if (this.reversedDirection && message.messageName().startsWith("Request") && codec instanceof ReverseDirectionCodecSupport) {
                ((ReverseDirectionCodecSupport)((Object)codec)).reverse();
            }
            codec.setMessage(message);
            return codec.encodeForConnection(value, key.getId(), transport, state);
        }
        if (value instanceof Integer) {
            return transport.onAttribute(state, key.getId(), ((Integer)value).intValue());
        }
        if (value instanceof String) {
            return transport.onAttribute(state, key.getId(), (String)value);
        }
        if (value instanceof Long) {
            return transport.onAttribute(state, key.getId(), ((Long)value).longValue());
        }
        if (value instanceof byte[]) {
            return transport.onAttribute(state, key.getId(), (byte[])value);
        }
        String errMsg = "Unknonw type: " + value.getClass().getName() + "; attrId: " + key;
        log.debug((Object)errMsg);
        throw new RuntimeException("Codec expected, but not found");
    }

    private void transportCompounds(MessageTransport transport, Object state, Map compounds, Message message) throws PlatformException {
        if (compounds.isEmpty()) {
            return;
        }
        boolean isXml = transport instanceof XmlStructureHandler;
        for (Object compound : compounds.values()) {
            if (compound == null) continue;
            DataSupport data = MetaData.asDataSupport(compound);
            String id = data.getMetaData().getId();
            if (isXml) {
                ((XmlStructureHandler)transport).onComplexAttribute(state, id, null);
            }
            this.transportData(transport, state, data, message);
            if (!isXml) continue;
            ((XmlStructureHandler)transport).onComplexEnd(state, id);
        }
    }

    public void setConnection(ConnectionImpl connection) {
        this.conn = connection;
    }

    public Object onNewMessage(Object state, int messageId) throws ProtocolException {
        Message message;
        MessageFilter filter;
        if (log.isDebug() && ((filter = this.logfilter) == null || filter.canTrace())) {
            log.debug((Object)("New message #" + messageId));
        }
        try {
            message = this.factory.createMessage(messageId);
        }
        catch (IllegalArgumentException e) {
            ProtocolException error = new ProtocolException("Failed to create message #" + messageId, e);
            this.errorHandler.handleError(error);
            throw error;
        }
        DataSupport dataSupport = MetaData.asDataSupport(message);
        List packagers = dataSupport.getCustomPackagers();
        if (packagers != null) {
            this.initPackagers(packagers, message);
        }
        return message;
    }

    public Object onAttribute(Object state, String id, String value) throws PlatformException {
        DataSupport dataSupport = MetaData.asDataSupport(state);
        MetaData meta = dataSupport.getMetaData();
        AttributeDescription key = meta.getAttributeDescription(id);
        Class valueType = null;
        if (key != null) {
            valueType = key.getValueType();
        }
        if (valueType == null || String.class.equals((Object)valueType)) {
            this.storeAttribute(dataSupport, id, value);
        } else if (Integer.class.equals((Object)valueType)) {
            this.storeAttribute(dataSupport, id, Integer.valueOf(value));
        } else if (Long.class.equals((Object)valueType)) {
            this.storeAttribute(dataSupport, id, Long.valueOf(value));
        } else {
            this.storeAttribute(dataSupport, id, value);
        }
        return state;
    }

    public Object onAttribute(Object state, String id, int value) throws PlatformException {
        DataSupport dataSupport = MetaData.asDataSupport(state);
        MetaData meta = dataSupport.getMetaData();
        AttributeDescription key = meta.getAttributeDescription(id);
        Class valueType = null;
        if (key != null) {
            valueType = key.getValueType();
        }
        if (valueType == null || Integer.class.equals((Object)valueType)) {
            this.storeAttribute(dataSupport, id, value);
        } else if (String.class.equals((Object)valueType)) {
            this.storeAttribute(dataSupport, id, String.valueOf(value));
        } else if (Long.class.equals((Object)valueType)) {
            this.storeAttribute(dataSupport, id, value);
        } else {
            this.storeAttribute(dataSupport, id, value);
        }
        return state;
    }

    public Object onAttribute(Object state, String id, byte[] value) throws PlatformException {
        this.storeAttribute(MetaData.asDataSupport(state), id, value);
        return state;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object onAttribute(Object state, String id, long value) throws PlatformException {
        DataSupport dataSupport = MetaData.asDataSupport(state);
        MetaData meta = dataSupport.getMetaData();
        AttributeDescription key = meta.getAttributeDescription(id);
        Class valueType = null;
        if (key != null) {
            valueType = key.getValueType();
        }
        if (valueType == null || Long.class.equals((Object)valueType)) {
            this.storeAttribute(dataSupport, id, value);
            return state;
        }
        if (Integer.class.equals((Object)valueType)) {
            if (value == (long)((int)value)) {
                this.storeAttribute(dataSupport, id, (int)value);
                return state;
            }
            ProtocolException ex = new ProtocolException("Exception parsing message. Can't cast long to int. " + meta.getName() + "." + id + "=" + value);
            this.errorHandler.handleError(ex);
            throw ex;
        }
        if (String.class.equals((Object)valueType)) {
            this.storeAttribute(dataSupport, id, String.valueOf(value));
            return state;
        }
        this.storeAttribute(dataSupport, id, value);
        return state;
    }

    public Object onRawAttribute(Object state, String id, Object value) throws PlatformException {
        Map msgAttributes = MetaData.asDataSupport(state).attributes();
        msgAttributes.put(id, value);
        return state;
    }

    private void storeAttribute(DataSupport dataSupport, String id, Object value) throws PlatformException {
        Message message = this.asMessage(dataSupport);
        try {
            if (!this.doStoreAttribute(dataSupport, message, id, value)) {
                this.complainMissingAttribute(dataSupport, id, value);
            }
        }
        catch (PlatformException e) {
            this.errorHandler.handleError(new ProtocolException("Exception parsing message", e));
            throw e;
        }
        catch (Exception e) {
            ProtocolException protoException = new ProtocolException("Exception parsing message", e);
            this.errorHandler.handleError(protoException);
            throw protoException;
        }
    }

    private Message asMessage(DataSupport dataSupport) {
        Message message = null;
        if (dataSupport instanceof Message) {
            message = (Message)((Object)dataSupport);
        }
        return message;
    }

    public Object onMessageEnd(Object state) throws CodecException {
        DataSupport msg = MetaData.asDataSupport(state);
        List packagers = msg.getCustomPackagers();
        if (packagers != null) {
            boolean lazyEnabled = this.isLazyParsingEnabled();
            for (Object codecO : packagers) {
                LazyParsingPossible iLazy;
                Map.Entry det;
                if (codecO instanceof PackagerSuppressible && ((PackagerSuppressible)codecO).isPackagerSuppressed()) continue;
                CustomPackager codec = null;
                if (codecO instanceof CustomPackager) {
                    codec = this.setupCodec((CustomPackager)codecO);
                }
                if (codec == null) continue;
                if (lazyEnabled && (det = this.findAttributeInfo(msg, codec)) != null && det.getValue() instanceof CodecAttributeDescription && (iLazy = (LazyParsingPossible)det.getValue()).isLazyParsingPossible()) {
                    String key = ((CodecAttributeDescription)det.getValue()).getName();
                    msg.getLazyParser().addAction(key, codec, (AttributeDescription)((Object)iLazy));
                    Map attributes = msg.attributes();
                    if (attributes instanceof DeepHashMap) {
                        ((DeepHashMap)attributes).putNullValue((Object)key);
                        continue;
                    }
                    attributes.put(key, null);
                    continue;
                }
                try {
                    codec.onMessageEnd();
                }
                catch (CodecException e) {
                    if (log.isError()) {
                        log.error((Object)("Exception in custom packager on " + msg), (Throwable)((Object)e));
                    }
                    this.errorHandler.handleError(e);
                }
                catch (Exception e) {
                    if (log.isError()) {
                        log.error((Object)("Exception in custom packager on " + msg), (Throwable)e);
                    }
                    CodecException exc = new CodecException("Exception in custom packager on " + msg, e);
                    this.errorHandler.handleError(exc);
                }
            }
        }
        if (this.messageHandler != null) {
            this.messageHandler.onMessage((Message)state);
        } else {
            log.warn((Object)"MessageHandler is null in MessagePackager");
        }
        return state;
    }

    private CustomPackager setupCodec(CustomPackager codec) {
        if (codec instanceof EncodingSupport) {
            ((EncodingSupport)codec).setStringAttributesEncoding(this.getStringAttributesEncoding());
        }
        return codec;
    }

    protected String getStringAttributesEncoding() {
        String encoding = null;
        if (this.conn != null) {
            return this.conn.getStringAttributesEncoding();
        }
        if (this.config != null) {
            encoding = this.config.getOption("string-attributes-encoding");
        }
        return encoding != null ? encoding : EncodingSupport.DEFAULT_ENCODING;
    }

    private Map.Entry findAttributeInfo(DataSupport msg, CustomPackager packager) {
        if (msg == null || packager == null) {
            return null;
        }
        Map attrs = msg.getMetaData().getAttributesDescriptions();
        for (Map.Entry obj : attrs.entrySet()) {
            AbstractCodecAttributeDescription acai;
            Map.Entry entry = obj;
            if (!(entry.getValue() instanceof AbstractCodecAttributeDescription) || !(acai = (AbstractCodecAttributeDescription)entry.getValue()).isSameCodec(packager)) continue;
            return entry;
        }
        return null;
    }

    public boolean needsProcessing(Object state, String attributeId, Element complexElement) {
        CustomTypeCodec codec;
        DataSupport data = MetaData.asDataSupport(state);
        AttributeDescription attrDesc = data.getMetaData().getAttributeDescription(attributeId);
        if (attrDesc != null && (codec = this.getCodec(attrDesc, data)) instanceof XmlStructureHandler) {
            XmlStructureHandler handler = (XmlStructureHandler)codec;
            return handler.needsProcessing(state, attributeId, complexElement);
        }
        return true;
    }

    public Object onComplexAttribute(Object state, String attributeId, Element elem) throws PlatformException {
        Object currentState;
        DataSupport data;
        block9: {
            data = MetaData.asDataSupport(state);
            currentState = null;
            MetaData metaData = data.getMetaData();
            AttributeDescription attrDesc = metaData.getAttributeDescription(attributeId);
            if (attrDesc != null) {
                CustomTypeCodec codec = this.getCodec(attrDesc, data);
                if (codec instanceof XmlStructureHandler) {
                    currentState = this.encodeByCodec(codec, state, attributeId, elem);
                }
            } else {
                String attrId = this.useTagMappings(attributeId, metaData);
                currentState = data.getCompounds().get(attrId);
                if (currentState == null) {
                    try {
                        Class clazz = (Class)metaData.getCompoundProperties().get(attrId);
                        if (clazz != null && (currentState = MetaData.createCompound(clazz)) != null) {
                            data.getCompounds().put(attrId, currentState);
                        }
                    }
                    catch (Exception ex) {
                        if (!log.isDebug()) break block9;
                        log.debug((Object)("Exception while creating compound value for " + attributeId));
                    }
                }
            }
        }
        if (log.isDebug() && currentState == null) {
            log.debugFormat("Null state in {0} for id = {1}", (Object)new Object[]{data.getClass(), attributeId});
        }
        if (currentState == null) {
            currentState = state;
        }
        return currentState;
    }

    private String useTagMappings(String attributeId, MetaData metaData) {
        String attrId = null;
        Map mappings = metaData.getTagMappings();
        if (mappings != null) {
            attrId = (String)mappings.get(attributeId);
        }
        if (attrId == null) {
            attrId = attributeId;
        }
        return attrId;
    }

    private Object encodeByCodec(CustomTypeCodec codec, Object state, String attributeId, Element elem) throws PlatformException {
        XmlStructureHandler handler = (XmlStructureHandler)codec;
        Object currentState = handler.onComplexAttribute(state, attributeId, elem);
        if (log.isDebug() && currentState == null) {
            log.debugFormat("State is null from ''{0}''", (Object)handler);
        }
        return currentState;
    }

    public Object onComplexEnd(Object state, String attributeId) {
        return state;
    }

    @Override
    public void setProtocolData(Object protocolData) {
        this.protocolData = protocolData;
    }

    @Override
    public Object getProtocolData() {
        return this.protocolData;
    }

    private void initPackagers(List packagers, Message message) {
        String strEncoding = null;
        if (this.conn != null) {
            strEncoding = this.getStringAttributesEncoding();
        }
        for (Object packager : packagers) {
            CustomPackager codec = (CustomPackager)packager;
            if (this.protocolData != null) {
                codec.setMessage(message);
                codec.setProtocolData(this.protocolData);
                if (codec instanceof ConfigurationSupport) {
                    ((ConfigurationSupport)((Object)codec)).configure(this.config);
                }
                if (codec instanceof EncodingSupport) {
                    ((EncodingSupport)codec).setStringAttributesEncoding(strEncoding);
                }
            }
            codec.onMessageStart(message);
        }
    }

    private boolean doStoreAttribute(DataSupport dataSupport, Message message, String id, Object value) throws PlatformException {
        this.notifyCustomPackagers(dataSupport, id, value);
        AttributeDescription key = dataSupport.getMetaData().getAttributeDescription(id);
        if (key != null) {
            CustomTypeCodec codec = this.getCodec(key, message);
            if (codec != null) {
                if (codec instanceof AttributeTypeCodec) {
                    value = ((AttributeTypeCodec)codec).decodeFromConnection(value, key);
                } else {
                    return true;
                }
            }
            dataSupport.attributes().put(key.getName(), this.convertValue(key, value, dataSupport));
            return true;
        }
        Map compounds = dataSupport.getCompounds();
        if (compounds == null) {
            return false;
        }
        for (Object o : compounds.values()) {
            DataSupport ds = MetaData.asDataSupport(o);
            boolean accepted = this.doStoreAttribute(ds, message, id, value);
            if (!accepted) continue;
            return true;
        }
        Map compsMeta = dataSupport.getMetaData().getCompoundProperties();
        if (compsMeta == null) {
            return false;
        }
        for (Map.Entry o : compsMeta.entrySet()) {
            Map.Entry entry = o;
            DataSupport ds = (DataSupport)compounds.get((String)entry.getKey());
            if (ds != null || (ds = (DataSupport)MetaData.createCompound((Class)entry.getValue())) == null || !this.doStoreAttribute(ds, message, id, value)) continue;
            compounds.put(entry.getKey(), ds);
            return true;
        }
        return false;
    }

    private Object convertValue(AttributeDescription key, Object value, DataSupport dataSupport) {
        CustomTypeCodec codec;
        if (key.hasCodec() && (codec = this.getCodec(key, dataSupport)) instanceof AttributeTypeCodec && key instanceof LazyParsingPossible && ((LazyParsingPossible)((Object)key)).isLazyParsingPossible() && this.isLazyParsingEnabled()) {
            dataSupport.getLazyParser().addAction(key.getName(), (AttributeTypeCodec)codec, key, value);
            return null;
        }
        if (value instanceof Integer && key.getValueType() == Long.class) {
            return new Long(((Integer)value).longValue());
        }
        return value;
    }

    private void notifyCustomPackagers(DataSupport dataSupport, String id, Object value) throws CodecException {
        List customPackagers = dataSupport.getCustomPackagers();
        if (customPackagers != null) {
            for (Object customPackager : customPackagers) {
                CustomPackager packager = (CustomPackager)customPackager;
                packager.onAttribute(id, value);
            }
        }
    }

    private CustomTypeCodec getCodec(AttributeDescription key, Message message) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        CustomTypeCodec codec = key.createCodec(message, this.protocolData);
        if (codec == null && key.isEnumProperty()) {
            codec = new EnumCodec();
        }
        if (codec instanceof ConfigurationSupport) {
            ((ConfigurationSupport)((Object)codec)).configure(this.config);
        }
        if (codec instanceof EncodingSupport && this.conn != null) {
            ((EncodingSupport)codec).setStringAttributesEncoding(this.getStringAttributesEncoding());
        }
        return codec;
    }

    private CustomTypeCodec getCodec(AttributeDescription key, DataSupport ds) {
        Message message = this.asMessage(ds);
        return this.getCodec(key, message);
    }

    private void complainMissingAttribute(DataSupport ds, String attrId, Object value) {
        MetaData data = ds.getMetaData();
        if (this.errorHandler != null && !(ds instanceof ProtocolUnknownMessage)) {
            MissingAttributeException e = new MissingAttributeException("Attribute is not accepted by the message.", data.getId(), attrId);
            this.errorHandler.handleError(e);
        }
        if (log.isDebug()) {
            log.debug((Object)("Attribute is not accepted by the message.attrId '" + attrId + "'(" + value.getClass().getSimpleName() + ") in msg '" + data.getId() + "/" + data.getName()));
        }
    }

    public static interface ErrorHandler {
        public void handleError(ProtocolException var1);
    }

    public static interface MessageHandler {
        public void onMessage(Message var1);
    }
}

