/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol.runtime;

import com.genesyslab.platform.commons.protocol.Endpoint;
import com.genesyslab.platform.commons.protocol.EndpointSupport;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.ProtocolDescription;
import com.genesyslab.platform.commons.protocol.Referenceable;
import com.genesyslab.platform.commons.protocol.runtime.CodecLazyParser;
import com.genesyslab.platform.commons.protocol.runtime.DataSupport;
import com.genesyslab.platform.commons.protocol.runtime.MetaData;
import com.genesyslab.platform.commons.protocol.runtime.ToStringHelper;
import com.genesyslab.platform.commons.protocol.runtime.UpdatableProtocolId;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ProtocolUnknownMessage
extends Message {
    public static final String MESSAGE_NAME = "ProtocolUnknownMessage";

    protected ProtocolUnknownMessage() {
        super(0, null, null);
    }

    private ProtocolUnknownMessage(ProtocolDescription protocolDescription, int messageId) {
        super(messageId, MESSAGE_NAME, protocolDescription);
    }

    public static ProtocolUnknownMessage create(ProtocolDescription protocolDescription, int messageId, MetaData metadata, String referenceIdAttributeName) {
        if (referenceIdAttributeName != null) {
            return new ProtocolUnknownMessageDataRef(protocolDescription, messageId, metadata, referenceIdAttributeName);
        }
        return new ProtocolUnknownMessageData(protocolDescription, messageId, metadata);
    }

    protected static class ProtocolUnknownMessageData
    extends ProtocolUnknownMessage
    implements DataSupport,
    EndpointSupport,
    UpdatableProtocolId {
        private final MetaData metaData;
        private final CodecLazyParser lazyParser;
        private Map attributes = new HashMap();
        private Map compounds = new HashMap();
        private Endpoint endpoint = null;
        private int protocolId = 0;

        protected ProtocolUnknownMessageData(ProtocolDescription protocolDescription, int messageId, MetaData metadata) {
            super(protocolDescription, messageId);
            this.metaData = metadata;
            this.lazyParser = new CodecLazyParser(this);
        }

        @Override
        public Endpoint getEndpoint() {
            return this.endpoint;
        }

        @Override
        public void setEndpoint(Endpoint endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public void setProtocolId(int id) {
            this.protocolId = id;
        }

        @Override
        public int getProtocolId() {
            return this.protocolId;
        }

        @Override
        public Object getMessageAttribute(String index) {
            Object res;
            if (this.attributes.get(index) == null && this.lazyParser.hasAttribute(index)) {
                this.lazyParser.parse(index);
            }
            if ((res = this.attributes.get(index)) == null) {
                res = this.compounds.get(index);
            }
            return res;
        }

        @Override
        public MetaData getMetaData() {
            return this.metaData;
        }

        @Override
        public Map attributes() {
            return this.attributes;
        }

        @Override
        public Map getCompounds() {
            return this.compounds;
        }

        @Override
        public DataSupport createClone(DataSupport sample) {
            ProtocolUnknownMessageData clone = new ProtocolUnknownMessageData(this.getProtocolDescription(), this.messageId(), this.getMetaData());
            for (String sAttr : this.lazyParser.getNotParsed()) {
                this.lazyParser.parse(sAttr);
            }
            clone.attributes = new HashMap(this.attributes);
            clone.compounds = new HashMap(this.compounds);
            return clone;
        }

        @Override
        public List getCustomPackagers() {
            return null;
        }

        @Override
        public CodecLazyParser getLazyParser() {
            return this.lazyParser;
        }

        @Override
        public String toString() {
            return this.toString(true, true);
        }

        @Override
        public String toString(boolean hideAllowed, boolean truncateLargeData) {
            return ToStringHelper.toString(this, hideAllowed, truncateLargeData);
        }
    }

    protected static class ProtocolUnknownMessageDataRef
    extends ProtocolUnknownMessageData
    implements Referenceable {
        private final String refAttrName;
        private Object reference;

        public ProtocolUnknownMessageDataRef(ProtocolDescription protocolDescription, int messageId, MetaData metadata, String refAttributeName) {
            super(protocolDescription, messageId, metadata);
            this.refAttrName = refAttributeName;
        }

        @Override
        public void updateReference(Object ref) {
            if (this.refAttrName != null) {
                this.attributes().put(this.refAttrName, ref);
            } else {
                this.reference = ref;
            }
        }

        @Override
        public Object retreiveReference() {
            if (this.refAttrName != null) {
                return this.attributes().get(this.refAttrName);
            }
            return this.reference;
        }

        @Override
        public DataSupport createClone(DataSupport sample) {
            ProtocolUnknownMessageDataRef clone = new ProtocolUnknownMessageDataRef(this.getProtocolDescription(), this.messageId(), this.getMetaData(), this.refAttrName);
            for (String sAttr : this.getLazyParser().getNotParsed()) {
                this.getLazyParser().parse(sAttr);
            }
            ((ProtocolUnknownMessageData)clone).attributes = new HashMap(this.attributes());
            ((ProtocolUnknownMessageData)clone).compounds = new HashMap(this.getCompounds());
            return clone;
        }
    }
}

