/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol.runtime.codec;

import com.genesyslab.platform.commons.PlatformException;
import com.genesyslab.platform.commons.connection.MessageTransport;
import com.genesyslab.platform.commons.protocol.runtime.AttributeDescription;
import com.genesyslab.platform.commons.protocol.runtime.codec.AttributeTypeCodec;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecException;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecUtil;
import com.genesyslab.platform.commons.protocol.runtime.codec.NoDataCodec;
import com.genesyslab.platform.commons.protocol.runtime.codec.ValueAdjustment;
import com.genesyslab.platform.commons.protocol.runtime.codec.ValueAdjustmentSupport;
import com.genesyslab.platform.commons.util.DateTimeConverter;
import com.genesyslab.platform.commons.xml.XmlUtil;
import java.text.ParseException;
import java.util.Date;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.w3c.dom.Element;

public class DateCodec
extends NoDataCodec
implements AttributeTypeCodec,
ValueAdjustmentSupport {
    private static final DateTimeConverter converter = new DateTimeConverter();
    private static final ValueAdjustment valueAdjustment = new ValueAdjustment(){

        @Override
        public Object getAdjustedValue(Object value) {
            Date original = (Date)value;
            long millis = original.getTime() % 1000L;
            if (millis == 0L) {
                return value;
            }
            Date v = (Date)original.clone();
            v.setTime(v.getTime() - millis);
            return v;
        }

        @Override
        public int getAdjustedHashCode(Object value) {
            if (value == null) {
                return 0;
            }
            long v = ((Date)value).getTime() / 1000L * 1000L;
            return (int)(v ^ v >> 32);
        }

        @Override
        public boolean isAdjustedEquals(Object value1, Object value2) {
            long v2;
            if (value1 == null ^ value2 == null) {
                return false;
            }
            long v1 = ((Date)value1).getTime() / 1000L * 1000L;
            return v1 == (v2 = ((Date)value2).getTime() / 1000L * 1000L);
        }
    };

    @Override
    public Object encodeForConnection(Object customTypeObject, String id, MessageTransport transport, Object transportState) throws PlatformException {
        Date d = DateCodec.asDate(customTypeObject);
        return transport.onAttribute(transportState, id, this.toString(d));
    }

    @Override
    public Object decodeFromConnection(Object value, AttributeDescription attributeDescription) throws PlatformException {
        if (value instanceof String) {
            String dateStr = (String)value;
            return this.parseDate(dateStr);
        }
        throw new CodecException("Date string expected. Found: " + value.getClass());
    }

    @Override
    public void encodeToXml(Object customTypeObject, Result attributeElement) throws CodecException {
        CodecUtil.appendText(this.toString(DateCodec.asDate(customTypeObject)), attributeElement);
    }

    @Override
    public Object decodeFromXml(Source attributeElement, AttributeDescription attributeDescription) throws CodecException {
        return this.decodeFromXml(CodecUtil.asElement(attributeElement));
    }

    private Object decodeFromXml(Element attributeElement) throws CodecException {
        String dateStr = XmlUtil.getElementText((Element)attributeElement);
        return this.parseDate(dateStr);
    }

    @Override
    public String getLogType() {
        return "str";
    }

    @Override
    public void appendLogValue(StringBuffer buf, Object customTypeObject, boolean truncate, boolean hide) throws CodecException {
        Date d = DateCodec.asDate(customTypeObject);
        buf.append('\"').append(this.toString(d)).append('\"');
    }

    private static Date asDate(Object customTypeObject) throws CodecException {
        try {
            return (Date)customTypeObject;
        }
        catch (ClassCastException e) {
            throw new CodecException("Date expected", e);
        }
    }

    @Override
    public ValueAdjustment getValueAdjustment() {
        return valueAdjustment;
    }

    private Object parseDate(String dateStr) throws CodecException {
        try {
            return converter.parseWithoutMillis(dateStr);
        }
        catch (ParseException e) {
            throw new CodecException("Invalid date value: '" + dateStr + "'", e);
        }
    }

    private String toString(Date date) {
        return converter.toStringWithoutMillis(date);
    }
}

