/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol.runtime.license;

import com.genesyslab.platform.commons.PsdkCustomization;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.ProtocolDescription;
import com.genesyslab.platform.commons.protocol.runtime.license.LicenseRestriction;

public class RestrictionManager {
    private static final ILogger log = Log.getLogger(RestrictionManager.class);
    private static LicenseRestriction restriction = null;
    private static boolean loaded = false;

    private RestrictionManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized LicenseRestriction getRestriction(ProtocolDescription description) {
        if (!loaded) {
            try {
                String className = PsdkCustomization.getOption((PsdkCustomization.PsdkOption)PsdkCustomization.PsdkOption.LicenseManagerClass);
                if (className != null) {
                    Class<?> licClass = Class.forName(className);
                    restriction = (LicenseRestriction)licClass.newInstance();
                }
            }
            catch (Throwable e) {
                log.error((Object)"failed to load restrictions, default ones will be used", e);
            }
            finally {
                loaded = true;
            }
        }
        return restriction;
    }

    public static synchronized void reset() {
        loaded = false;
    }
}

