/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.contacts.protocol.contactserver;

import com.genesyslab.platform.commons.collections.util.Hex;
import com.genesyslab.platform.commons.protocol.DataObject;
import com.genesyslab.platform.commons.protocol.Endpoint;
import com.genesyslab.platform.commons.protocol.EndpointSupport;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.ProtocolDescription;
import com.genesyslab.platform.commons.protocol.ProtocolDescriptionSupport;
import com.genesyslab.platform.commons.protocol.Referenceable;
import com.genesyslab.platform.commons.protocol.runtime.AttributeDescription;
import com.genesyslab.platform.commons.protocol.runtime.CodecLazyParser;
import com.genesyslab.platform.commons.protocol.runtime.DataSupport;
import com.genesyslab.platform.commons.protocol.runtime.LogHiddenAttributes;
import com.genesyslab.platform.commons.protocol.runtime.MetaData;
import com.genesyslab.platform.commons.protocol.runtime.ToStringHelper;
import com.genesyslab.platform.commons.protocol.runtime.UpdatableProtocolId;
import com.genesyslab.platform.contacts.protocol.contactserver.AbstractPrintable;
import com.genesyslab.platform.contacts.protocol.contactserver.ContactServerMessage;
import com.genesyslab.platform.contacts.protocol.contactserver.ContactServerProtocolFactory;
import com.genesyslab.platform.contacts.protocol.contactserver.Printable;
import com.genesyslab.platform.openmedia.protocol.externalservice.RequestorInfo;
import com.genesyslab.platform.openmedia.protocol.externalservice.RequestorInfoSupport;
import java.util.List;

public abstract class AbstractMessage
extends Message
implements ProtocolDescriptionSupport,
UpdatableProtocolId,
Referenceable,
DataSupport,
EndpointSupport,
Printable,
ContactServerMessage,
RequestorInfoSupport {
    private int protId;
    private Endpoint endpoint = null;
    private final CodecLazyParser lazyParser = new CodecLazyParser((DataSupport)this);
    protected static final String REF_ID_KEY = "ReferenceId";

    protected AbstractMessage(int id, String name) {
        this(id, name, ContactServerProtocolFactory.PROTOCOL_DESCRIPTION);
    }

    protected AbstractMessage(int id, String name, ProtocolDescription description) {
        super(id, name, description);
    }

    public CodecLazyParser getLazyParser() {
        return this.lazyParser;
    }

    public Object getMessageAttribute(String index) {
        if (this.attributes().get(index) == null && this.lazyParser.hasAttribute(index)) {
            this.lazyParser.parse(index);
        }
        return this.attributes().get(index);
    }

    public int getProtocolId() {
        return this.protId;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public void setProtocolId(int protocolId) {
        this.protId = protocolId;
    }

    public Object retreiveReference() {
        return this.attributes().get(REF_ID_KEY);
    }

    public void updateReference(Object reference) {
        this.attributes().put(REF_ID_KEY, reference);
    }

    public Integer getReferenceId() {
        return (Integer)this.retreiveReference();
    }

    public void setReferenceId(Integer referenceId) {
        this.updateReference(referenceId);
    }

    public void setReferenceId(int referenceId) {
        this.setReferenceId(new Integer(referenceId));
    }

    public RequestorInfo getRequestorInfo() {
        return (RequestorInfo)this.attributes().get("RequestorInfo");
    }

    public void setRequestorInfo(RequestorInfo requestorInfo) {
        this.attributes().put("RequestorInfo", requestorInfo);
    }

    public List getCustomPackagers() {
        return null;
    }

    public String toString() {
        return this.toString(0, true, true);
    }

    public String toString(boolean hide, boolean truncate) {
        return this.toString(0, hide, truncate);
    }

    protected String toString(int indent, boolean hide, boolean truncate) {
        Object entryVal;
        ProtocolDescription description;
        StringBuilder buffer = new StringBuilder(this.getClass().getName());
        buffer.append(":\n");
        StringBuilder indentElement = AbstractPrintable.createIndent(indent);
        MetaData metadata = this.getMetaData();
        String name = null;
        String protocolName = null;
        if (metadata != null) {
            name = metadata.getName();
        }
        if ((description = this.getProtocolDescription()) != null) {
            protocolName = description.getProtocolName();
        }
        LogHiddenAttributes.AttributeSet atrSet = null;
        if (protocolName != null && name != null) {
            atrSet = ToStringHelper.getHiddenAttributes((String)protocolName, (String)name);
        }
        for (Object entryKey : this.attributes().keySet()) {
            buffer.append((CharSequence)indentElement).append(entryKey).append(" = ");
            if (atrSet != null && atrSet.contains(entryKey.toString())) {
                buffer.append("[output suppressed]");
            } else {
                entryVal = this.attributes().get(entryKey);
                if (entryVal instanceof DataObject) {
                    buffer.append(((DataObject)entryVal).toString(hide, truncate));
                } else if (entryVal instanceof Printable) {
                    buffer.append(((Printable)entryVal).toString(indent + 1));
                } else if (entryVal instanceof byte[]) {
                    Hex.appendBytesStr((StringBuilder)buffer, (byte[])((byte[])entryVal), (boolean)truncate);
                } else {
                    buffer.append(entryVal);
                }
            }
            buffer.append("\n");
        }
        for (Object entryKey : this.getCompounds().keySet()) {
            buffer.append((CharSequence)indentElement).append(entryKey).append(" = ");
            entryVal = this.getCompounds().get(entryKey);
            if (entryVal instanceof DataObject) {
                buffer.append(((DataObject)entryVal).toString(hide, truncate));
            } else if (entryVal instanceof Printable) {
                buffer.append(((Printable)entryVal).toString(indent + 1));
            } else {
                buffer.append(entryVal);
            }
            buffer.append("\n");
        }
        for (String sAttr : this.lazyParser.getNotParsed()) {
            AttributeDescription ad = this.lazyParser.getAttributeDescription(sAttr);
            buffer.append((CharSequence)indentElement).append(ad.getName()).append(" = <attribute is not parsed>\n");
        }
        return buffer.toString();
    }

    @Override
    public String toString(int ident) {
        return this.toString(ident, true, true);
    }
}

