/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.contacts.protocol.contactserver;

import com.genesyslab.platform.commons.collections.UTFValue;
import com.genesyslab.platform.commons.collections.util.Base64;
import com.genesyslab.platform.commons.protocol.runtime.MessageTypeResolver;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecException;
import com.genesyslab.platform.contacts.protocol.runtime.UCSCustomCodec;
import com.genesyslab.platform.contacts.protocol.runtime.XmlSerializable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class StringBinary
implements XmlSerializable {
    private String stringValue = null;
    private byte[] binValue = null;

    public StringBinary() {
    }

    public StringBinary(String obj) {
        this.stringValue = obj;
    }

    public StringBinary(byte[] obj) {
        this.binValue = obj;
    }

    public static Object toKVList(StringBinary sb) {
        if (sb == null) {
            return null;
        }
        if (sb.binValue != null) {
            return sb.binValue;
        }
        if (sb.stringValue != null) {
            return sb.stringValue;
        }
        return null;
    }

    public static StringBinary fromKVList(Object obj) {
        if (obj instanceof String) {
            return new StringBinary((String)obj);
        }
        if (obj instanceof UTFValue) {
            return new StringBinary(((UTFValue)obj).getValue());
        }
        if (obj instanceof byte[]) {
            return new StringBinary((byte[])obj);
        }
        if (obj != null) {
            throw new IllegalArgumentException("Incorrect value type. String or binary are possible only.");
        }
        return null;
    }

    public String toString(int ident) {
        if (this.stringValue != null) {
            return this.stringValue;
        }
        if (this.binValue != null) {
            StringBuilder buf = new StringBuilder();
            int len = this.binValue.length;
            for (int i = 0; i < len; ++i) {
                if (i % 20 == 0) {
                    buf.append("\n\t  ");
                }
                buf.append(" 0x");
                String hs = Integer.toHexString(this.binValue[i]);
                if (hs.length() < 2) {
                    buf.append("0");
                }
                buf.append(hs);
            }
            return buf.toString();
        }
        return "<null>";
    }

    public String toString() {
        return this.toString(0);
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(String value) {
        this.stringValue = value;
        this.binValue = null;
    }

    public byte[] getBinaryValue() {
        return this.binValue;
    }

    public void setBinValue(byte[] value) {
        this.binValue = value;
        this.stringValue = null;
    }

    public int hashCode() {
        int n = this.getClass().hashCode();
        if (this.stringValue != null) {
            n ^= this.stringValue.hashCode();
        } else {
            for (int i = 0; i < this.binValue.length; ++i) {
                n ^= Byte.valueOf(this.binValue[i]).hashCode();
            }
        }
        return n;
    }

    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        StringBinary sb = (StringBinary)obj;
        if (this.stringValue != null ? sb.stringValue == null || !this.stringValue.equals(sb.stringValue) : sb.stringValue != null) {
            return false;
        }
        if (this.binValue != null) {
            if (sb.binValue == null || this.binValue.length != sb.binValue.length) {
                return false;
            }
            for (int i = 0; i < this.binValue.length; ++i) {
                if (this.binValue[i] == sb.binValue[i]) continue;
                return false;
            }
        } else if (sb.binValue != null) {
            return false;
        }
        return true;
    }

    @Override
    public void saveToXml(UCSCustomCodec custCodec, Node node) throws CodecException {
        Document doc = node.getOwnerDocument();
        if (this.binValue != null) {
            Attr attr = doc.createAttribute("type");
            attr.setValue("binary");
            node.getAttributes().setNamedItem(attr);
            node.appendChild(doc.createTextNode(new String(Base64.encodeBase64((byte[])this.binValue))));
        } else if (this.stringValue != null) {
            Attr attr = doc.createAttribute("type");
            attr.setValue("string");
            node.getAttributes().setNamedItem(attr);
            node.appendChild(doc.createTextNode(this.stringValue));
        }
    }

    @Override
    public void loadFromXml(UCSCustomCodec custCodec, Node node) throws CodecException {
        this.binValue = null;
        this.stringValue = null;
        Attr type = (Attr)node.getAttributes().getNamedItem("type");
        if (type == null) {
            throw new CodecException("StringBinary property does not contain type attribute.");
        }
        String sType = type.getValue();
        if (MessageTypeResolver.isBinary((String)sType)) {
            this.binValue = Base64.decodeBase64((byte[])node.getTextContent().getBytes());
        } else if (MessageTypeResolver.isString((String)sType)) {
            this.stringValue = node.getTextContent();
        } else {
            throw new CodecException("StringBinary property has wrong value type ('" + sType + "') only 'binary' or 'string' is allowed.");
        }
    }
}

