/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.contacts.protocol.contactserver;

import com.genesyslab.platform.commons.collections.UTFValue;
import com.genesyslab.platform.commons.protocol.runtime.MessageTypeResolver;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecException;
import com.genesyslab.platform.contacts.protocol.runtime.UCSCustomCodec;
import com.genesyslab.platform.contacts.protocol.runtime.XmlSerializable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class StringInteger
implements XmlSerializable {
    private String stringValue = null;
    private Integer intValue = null;

    public StringInteger() {
    }

    public StringInteger(String obj) {
        this.stringValue = obj;
    }

    public StringInteger(Integer obj) {
        this.intValue = obj;
    }

    public static Object toKVList(StringInteger si) {
        if (si.intValue != null) {
            return si.intValue;
        }
        if (si.stringValue != null) {
            return si.stringValue;
        }
        return null;
    }

    public static StringInteger fromKVList(Object obj) {
        if (obj instanceof String) {
            return new StringInteger((String)obj);
        }
        if (obj instanceof UTFValue) {
            return new StringInteger(((UTFValue)obj).getValue());
        }
        if (obj instanceof Integer) {
            return new StringInteger((Integer)obj);
        }
        if (obj != null) {
            throw new IllegalArgumentException("Incorrect value type. String or Integer are possible only.");
        }
        return null;
    }

    public String toString(int ident) {
        if (this.stringValue != null) {
            return this.stringValue;
        }
        if (this.intValue != null) {
            return this.intValue.toString();
        }
        return "<null>";
    }

    public String toString() {
        return this.toString(0);
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(String value) {
        this.stringValue = value;
        this.intValue = null;
    }

    public Integer getIntegerValue() {
        return this.intValue;
    }

    public void setIntegerValue(Integer value) {
        this.intValue = value;
        this.stringValue = null;
    }

    public int hashCode() {
        int n = this.getClass().hashCode();
        if (this.stringValue != null) {
            n ^= this.stringValue.hashCode();
        } else if (this.intValue != null) {
            n ^= this.intValue.hashCode();
        }
        return n;
    }

    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        StringInteger si = (StringInteger)obj;
        if (this.stringValue != null ? si.stringValue == null || !this.stringValue.equals(si.stringValue) : si.stringValue != null) {
            return false;
        }
        return !(this.intValue != null ? si.intValue == null || !this.intValue.equals(si.intValue) : si.intValue != null);
    }

    @Override
    public void saveToXml(UCSCustomCodec custCodec, Node node) throws CodecException {
        Document doc = node.getOwnerDocument();
        if (this.intValue != null) {
            Attr attr = doc.createAttribute("type");
            attr.setValue("int");
            node.getAttributes().setNamedItem(attr);
            node.appendChild(doc.createTextNode(this.intValue.toString()));
        } else if (this.stringValue != null) {
            Attr attr = doc.createAttribute("type");
            attr.setValue("string");
            node.getAttributes().setNamedItem(attr);
            node.appendChild(doc.createTextNode(this.stringValue));
        } else {
            throw new CodecException("StringInteger property does not contain any value.");
        }
    }

    @Override
    public void loadFromXml(UCSCustomCodec custCodec, Node node) throws CodecException {
        this.intValue = null;
        this.stringValue = null;
        Attr type = (Attr)node.getAttributes().getNamedItem("type");
        if (type == null) {
            throw new CodecException("StringInteger property does not contain type attribute.");
        }
        String sType = type.getValue();
        if (MessageTypeResolver.isInt((String)sType)) {
            this.intValue = new Integer(node.getTextContent());
        } else if (MessageTypeResolver.isString((String)sType)) {
            this.stringValue = node.getTextContent();
        } else {
            throw new CodecException("StringInteger property has wrong value type ('" + sType + "') only 'int' or 'string' is allowed.");
        }
    }
}

