/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.contacts.protocol.contactserver.runtime;

import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.contacts.protocol.contactserver.INullableAttributes;
import java.util.Arrays;
import java.util.TreeSet;

public class NullAttributesManager {
    private TreeSet<String> nullNames = new TreeSet();

    public void setValueFor(String attr, boolean isNullValue) {
        if (isNullValue) {
            if (!this.nullNames.contains(attr)) {
                this.nullNames.add(attr);
            }
        } else if (this.nullNames.contains(attr)) {
            this.nullNames.remove(attr);
        }
    }

    public boolean isNull(String attr) {
        return this.nullNames.contains(attr);
    }

    public boolean hasNullAttributes() {
        return !this.nullNames.isEmpty();
    }

    public String[] getNullAttributes() {
        return this.nullNames.toArray(new String[this.nullNames.size()]);
    }

    public void set(String[] value) {
        this.nullNames.clear();
        if (value != null) {
            this.nullNames.addAll(Arrays.asList(value));
        }
    }

    public static String[] parseAttributes(String source) {
        if (source == null || source.length() == 0) {
            return null;
        }
        String[] result = source.split(",");
        if (result == null || result.length == 0) {
            return null;
        }
        return result;
    }

    public static String prepareCommaSeparatedString(String[] attrs) {
        if (attrs.length == 0) {
            return null;
        }
        int count = attrs.length;
        StringBuilder sb = new StringBuilder(32 * count);
        for (int i = count - 1; i >= 0; --i) {
            sb.append(attrs[i]);
            sb.append(',');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    static void prepareKVList(KeyValueCollection col, INullableAttributes attrs) {
        if (attrs == null) {
            return;
        }
        String nulls = NullAttributesManager.prepareCommaSeparatedString(attrs.getNullAttributes());
        if (nulls != null) {
            col.addString("NullAttributes", nulls);
        }
    }

    static String prepareNullAttributes(Object obj) {
        return NullAttributesManager.prepareCommaSeparatedString(((INullableAttributes)obj).getNullAttributes());
    }
}

