/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.contacts.protocol.runtime;

import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.collections.KeyValuePair;
import com.genesyslab.platform.commons.collections.Pair;
import com.genesyslab.platform.commons.protocol.ProtocolException;
import com.genesyslab.platform.contacts.protocol.runtime.CustomMarshaling;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;

public class AttributesListCustomMarshaler
implements CustomMarshaling {
    @Override
    public int marshal(KeyValueCollection outKv, String key, Object val, KeyValueCollection inKv) throws ProtocolException {
        String name;
        KeyValueCollection nameKv;
        KeyValueCollection kv = (KeyValueCollection)val;
        KeyValueCollection sc = outKv.getList(key);
        if (sc == null) {
            sc = new KeyValueCollection();
            outKv.addList(key, sc);
        }
        if ((nameKv = sc.getList(name = kv.getString("AttrName"))) != null) {
            throw new IllegalArgumentException("Attribute '" + name + "' is defined more than once.");
        }
        nameKv = new KeyValueCollection();
        sc.addList(name, nameKv);
        KeyValueCollection[] attrs = this.prepareAttrsList(kv);
        for (int index = 0; index < attrs.length; ++index) {
            KeyValueCollection info = attrs[index];
            String sIndex = "undefined";
            if (!info.containsKey((Object)"AttrIndex")) {
                throw new ProtocolException("AttributesInfoList contains one or more AttributesInfo objects with undefined AttrIndex");
            }
            sIndex = info.getInt("AttrIndex").toString();
            KeyValueCollection info1 = new KeyValueCollection();
            info1.addAll((Collection)info);
            info1.remove("AttrIndex");
            info = info1;
            KeyValueCollection indexKv = nameKv.getList(sIndex);
            if (indexKv == null) {
                indexKv = new KeyValueCollection();
                nameKv.addList(sIndex, indexKv);
            }
            indexKv.addAll((Collection)info);
        }
        return 0;
    }

    private KeyValueCollection[] prepareAttrsList(KeyValueCollection kv) throws ProtocolException {
        boolean autoIndexing = false;
        ArrayList<KeyValueCollection> ret = new ArrayList<KeyValueCollection>();
        Enumeration attrs = kv.getEnumeration("AttributesInfoList");
        int index = 0;
        while (attrs.hasMoreElements()) {
            KeyValuePair pair = (KeyValuePair)attrs.nextElement();
            KeyValueCollection info = pair.getTKVValue();
            if (index == 0) {
                if (info.containsKey((Object)"AttrIndex")) {
                    autoIndexing = false;
                } else {
                    autoIndexing = true;
                    info.addInt("AttrIndex", index);
                }
            } else if (autoIndexing) {
                if (info.containsKey((Object)"AttrIndex")) {
                    throw new ProtocolException("AttributesInfo.AttrIndex should be manually set for all elements in AttributesInfoList, or not set at all (will be set automatically). Partial indexing is not supported.");
                }
                info.addInt("AttrIndex", index);
            } else if (!info.containsKey((Object)"AttrIndex")) {
                throw new ProtocolException("AttributesInfo.AttrIndex should be manually set for all elements in AttributesInfoList, or not set at all (will be set automatically). Partial indexing is not supported.");
            }
            ret.add(info);
            ++index;
        }
        return ret.toArray(new KeyValueCollection[ret.size()]);
    }

    @Override
    public int unmarshal(KeyValueCollection outKv, String key, Object val, KeyValueCollection inKv) {
        KeyValueCollection kv = (KeyValueCollection)val;
        for (Pair pair : kv) {
            String name = pair.getStringKey();
            KeyValueCollection nameKv = (KeyValueCollection)pair.getValue();
            KeyValueCollection header = new KeyValueCollection();
            header.addString("AttrName", name);
            outKv.addList(key, header);
            for (Pair pair1 : nameKv) {
                String index = pair1.getStringKey();
                KeyValueCollection indexKv = (KeyValueCollection)pair1.getValue();
                KeyValueCollection attr = new KeyValueCollection();
                attr.addAll((Collection)indexKv);
                attr.addInt("AttrIndex", Integer.parseInt(index));
                header.addList("AttributesInfoList", attr);
            }
        }
        return 0;
    }
}

