/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.contacts.protocol.runtime;

import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.collections.KeyValuePair;
import com.genesyslab.platform.commons.protocol.ProtocolException;
import com.genesyslab.platform.contacts.protocol.contactserver.NamedGEnum;
import com.genesyslab.platform.contacts.protocol.contactserver.Operators;
import com.genesyslab.platform.contacts.protocol.contactserver.Prefixes;
import com.genesyslab.platform.contacts.protocol.runtime.CustomMarshalManager;
import com.genesyslab.platform.contacts.protocol.runtime.CustomMarshaling;
import com.genesyslab.platform.contacts.protocol.runtime.UcsCustomMarshalManager;
import java.util.Enumeration;

public class CustomMarshaler
implements CustomMarshaling {
    private final CustomMarshalManager engine;

    public CustomMarshaler(UcsCustomMarshalManager ucsCustomMarshalManager) {
        this.engine = ucsCustomMarshalManager;
    }

    @Override
    public int marshal(KeyValueCollection outKv, String key, Object val, KeyValueCollection inKv) throws ProtocolException {
        if ("SearchCriteria".equals(key)) {
            KeyValueCollection sc = (KeyValueCollection)val;
            String prefix = sc.getString("Prefix");
            String newKey = prefix != null ? prefix : sc.getString("SimpleOperator");
            if (newKey == null) {
                throw new RuntimeException("Operator property is mandatory for SimpleSearchCriteria object, Prefix is mandatory for ComplexSearchCriteria.");
            }
            KeyValueCollection newkv = outKv.getList("SearchCriteria");
            if (newkv == null) {
                newkv = new KeyValueCollection();
                outKv.addList("SearchCriteria", newkv);
            }
            newkv.addList(newKey, this.engine.marshal(sc));
            return 0;
        }
        if ("Criterias".equals(key)) {
            KeyValueCollection sc = (KeyValueCollection)val;
            String prefix = sc.getString("Prefix");
            String newKey = prefix != null ? prefix : sc.getString("SimpleOperator");
            if (newKey == null) {
                throw new RuntimeException("Operator property is mandatory for SimpleSearchCriteria object, Prefix is mandatory for ComplexSearchCriteria.");
            }
            outKv.addList(newKey, this.engine.marshal(sc));
            return 0;
        }
        if ("Prefix".equals(key)) {
            return 0;
        }
        if ("SimpleOperator".equals(key)) {
            return 0;
        }
        return 2;
    }

    @Override
    public int unmarshal(KeyValueCollection outKv, String key, Object val, KeyValueCollection inKv) throws ProtocolException {
        KeyValueCollection kv = (KeyValueCollection)val;
        if ("SearchCriteria".equals(key)) {
            Enumeration enum1 = kv.getEnumeration();
            if (enum1 != null && enum1.hasMoreElements()) {
                KeyValuePair pair = (KeyValuePair)enum1.nextElement();
                return this.unmarshal(outKv, pair.getTKVValue(), pair.getStringKey(), key);
            }
            return 2;
        }
        return this.unmarshal(outKv, kv, key, "Criterias");
    }

    private int unmarshal(KeyValueCollection outKv, KeyValueCollection fromKV, String key1, String key2) throws ProtocolException {
        NamedGEnum p = Prefixes.toEnum(key1);
        if (p != null) {
            KeyValueCollection kvu = this.engine.unmarshal(fromKV);
            kvu.addString("Prefix", key1);
            outKv.addList(key2, kvu);
            return 0;
        }
        p = Operators.toEnum(key1);
        if (p != null) {
            KeyValueCollection kvu = this.engine.unmarshal(fromKV);
            kvu.addString("SimpleOperator", key1);
            outKv.addList(key2, kvu);
            return 0;
        }
        return 2;
    }
}

