/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.contacts.protocol.runtime;

import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.collections.KeyValuePair;
import com.genesyslab.platform.contacts.protocol.runtime.CustomMarshalManager;
import com.genesyslab.platform.contacts.protocol.runtime.CustomMarshaling;
import java.util.Collection;
import java.util.Enumeration;

public class IndexListCustomMarshaler
implements CustomMarshaling {
    @Override
    public int marshal(KeyValueCollection outKv, String key, Object val, KeyValueCollection inKv) {
        if ("Indexes".equals(key)) {
            String descr;
            KeyValueCollection kv = (KeyValueCollection)val;
            KeyValueCollection sc = outKv.getList(key);
            if (sc == null) {
                sc = new KeyValueCollection();
                outKv.addList(key, sc);
            }
            String idx = kv.getString("IndexName");
            KeyValueCollection clone = new KeyValueCollection();
            if (kv.containsKey((Object)"Fields")) {
                Enumeration fields = kv.getEnumeration("Fields");
                while (fields.hasMoreElements()) {
                    KeyValuePair pair = (KeyValuePair)fields.nextElement();
                    CustomMarshalManager.defaultStringKeyMarshal(clone, "Fields", "FieldName", pair.getTKVValue());
                }
            }
            if ((descr = kv.getString("Description")) != null) {
                clone.addString("Description", descr);
            }
            sc.addList(idx, clone);
            return 0;
        }
        return 2;
    }

    @Override
    public int unmarshal(KeyValueCollection outKv, String key, Object val, KeyValueCollection inKv) {
        if ("Indexes".equals(key)) {
            KeyValueCollection kv = (KeyValueCollection)val;
            for (KeyValuePair pair : kv) {
                String k = pair.getStringKey();
                KeyValueCollection data = pair.getTKVValue();
                KeyValueCollection newKv = new KeyValueCollection();
                if (data.containsKey((Object)"Fields")) {
                    KeyValueCollection flds = new KeyValueCollection();
                    CustomMarshalManager.defaultStringKeyUnmarshal(flds, "Fields", "FieldName", data.getList("Fields"));
                    newKv.addAll((Collection)flds);
                }
                if (data.containsKey((Object)"Description")) {
                    newKv.addString("Description", data.getString("Description"));
                }
                newKv.addString("IndexName", k);
                outKv.addList("Indexes", newKv);
            }
            return 0;
        }
        return 2;
    }
}

