/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.contacts.protocol.runtime;

import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.collections.KeyValuePair;
import com.genesyslab.platform.commons.collections.Pair;
import com.genesyslab.platform.contacts.protocol.runtime.CustomMarshaling;
import java.util.Enumeration;

public class InteractionDataListCustomMarshaler
implements CustomMarshaling {
    @Override
    public int marshal(KeyValueCollection outKv, String key, Object val, KeyValueCollection inKv) {
        if ("InteractionData".equals(key)) {
            KeyValueCollection kv = (KeyValueCollection)val;
            KeyValueCollection sc = outKv.getList("InteractionData");
            if (sc == null) {
                sc = new KeyValueCollection();
                outKv.addList("InteractionData", sc);
            }
            KeyValueCollection newatrs = new KeyValueCollection();
            Enumeration atrs = kv.getEnumeration("Attribute");
            while (atrs.hasMoreElements()) {
                KeyValuePair atr = (KeyValuePair)atrs.nextElement();
                KeyValueCollection atrv = atr.getTKVValue();
                newatrs.addObject(atrv.getString("AttributeName"), atrv.getPair("AttributeValue").getValue());
            }
            KeyValueCollection tmp = new KeyValueCollection();
            tmp.addList("Attributes", newatrs);
            if (kv.containsKey((Object)"Id")) {
                tmp.addObject("Id", kv.getPair("Id").getValue());
            }
            sc.addList(kv.getPair("ContactIndex").getValue().toString(), tmp);
            return 0;
        }
        return 2;
    }

    @Override
    public int unmarshal(KeyValueCollection outKv, String key, Object val, KeyValueCollection inKv) {
        if ("InteractionData".equals(key)) {
            KeyValueCollection kv = (KeyValueCollection)val;
            for (Pair pair : kv) {
                if (pair == null) continue;
                String k = pair.getStringKey();
                KeyValueCollection data = (KeyValueCollection)pair.getValue();
                KeyValueCollection newKv = new KeyValueCollection();
                newKv.addInt("ContactIndex", Integer.parseInt(k));
                if (data.containsKey((Object)"Id")) {
                    newKv.addObject("Id", data.getPair("Id").getValue());
                }
                KeyValueCollection oldAtrs = data.getList("Attributes");
                for (Pair pair1 : oldAtrs) {
                    Object atrVal;
                    if (pair1 == null || (atrVal = pair1.getValue()) == null) continue;
                    String atrKey = pair1.getStringKey();
                    KeyValueCollection newAtrs = new KeyValueCollection();
                    newAtrs.addString("AttributeName", atrKey);
                    newAtrs.addObject("AttributeValue", atrVal);
                    newKv.addList("Attribute", newAtrs);
                }
                outKv.addList("InteractionData", newKv);
            }
            return 0;
        }
        return 2;
    }
}

