/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.contacts.protocol.server;

import com.genesyslab.platform.commons.connection.Connection;
import com.genesyslab.platform.commons.connection.configuration.ConnectionConfiguration;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.ClientChannelHandler;
import com.genesyslab.platform.commons.protocol.DuplexChannel;
import com.genesyslab.platform.commons.protocol.IntReferenceBuilder;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.ProtocolDescription;
import com.genesyslab.platform.commons.protocol.ProtocolException;
import com.genesyslab.platform.commons.protocol.ProtocolFactory;
import com.genesyslab.platform.commons.protocol.ReferenceBuilder;
import com.genesyslab.platform.contacts.protocol.UniversalContactServerProtocol;
import com.genesyslab.platform.contacts.protocol.UniversalContactServerProtocolHandshakeOptions;
import com.genesyslab.platform.openmedia.protocol.externalservice.ExternalServiceProtocolFactory;

public class UniversalContactServerClientChannelHandler
extends ClientChannelHandler
implements UniversalContactServerProtocolHandshakeOptions {
    private String clientName = "";
    private String clientApplicationType = "";
    private static final boolean DEBUG_KVBINDING = System.getProperty("com.genesyslab.platform.contacts.protocol.kvbinding.debug", "").equals("1");
    private static final ILogger log = Log.getLogger(UniversalContactServerClientChannelHandler.class);
    private boolean useUtfForResponses;
    private final ReferenceBuilder referenceBuilder = new IntReferenceBuilder();

    @Override
    public String getClientName() {
        return this.clientName;
    }

    @Override
    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    @Override
    public String getClientApplicationType() {
        return this.clientApplicationType;
    }

    @Override
    public void setClientApplicationType(String clientAppType) {
        this.clientApplicationType = clientAppType;
    }

    public ProtocolDescription getProtocolDescription() {
        return UniversalContactServerProtocol.PROTOCOL_DESCRIPTION;
    }

    protected UniversalContactServerClientChannelHandler(Connection connection, ConnectionConfiguration config) {
        super(connection, config, (ProtocolFactory)new ExternalServiceProtocolFactory());
        this.useUtfForResponses = config == null ? true : config.getBoolean("UseUtfForResponses", true);
    }

    protected void onReceiveMessage(Message incom) {
        Message msg = UCSBridge.processReceivedMsg((DuplexChannel)this, incom, UniversalContactServerClientChannelHandler.log);
        super.onReceiveMessage(msg);
    }

    protected void doSend(Message message) throws ProtocolException {
        Message messageToSend = UCSBridge.processSentMsg((DuplexChannel)this, message, this.useUtfForResponses, this.referenceBuilder);
        super.doSend(messageToSend);
    }

    protected void applyConfiguration() {
        ConnectionConfiguration config = this.getConfiguration();
        if (config != null) {
            this.useUtfForResponses = config.getBoolean("UseUtfForResponses", this.useUtfForResponses);
            String useUftForRequests = config.getOption("UTF_STRING");
            if (useUftForRequests == null) {
                config.setBoolean("UTF_STRING", true);
            }
        }
    }

    private static class UCSBridge
    extends UniversalContactServerProtocol {
        private UCSBridge() {
        }

        private static Message processReceivedMsg(DuplexChannel channel, Message incom, ILogger log) {
            return UniversalContactServerProtocol.processReceivedMessage(channel, incom, log);
        }

        private static Message processSentMsg(DuplexChannel channel, Message message, boolean useUtf, ReferenceBuilder referenceBuilder) throws ProtocolException {
            return UniversalContactServerProtocol.processSentMessage(channel, message, useUtf, referenceBuilder);
        }
    }
}

