/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class GEnum {
    private static final Map<String, Map<Object, ? extends GEnum>> registry = new HashMap<String, Map<Object, ? extends GEnum>>();
    private static final Map<String, Set<? extends GEnum>> registryValues = new HashMap<String, Set<? extends GEnum>>();
    protected static final Locale LOCALE_ENGLISH = Locale.ENGLISH;
    private Integer ordinal;
    private String name;

    protected GEnum(int ordinal, String name, Class enumClass) {
        this.ordinal = ordinal;
        this.name = name;
        GEnum.checkClass(enumClass);
        this.registerInstance(enumClass);
    }

    public int ordinal() {
        return this.ordinal;
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof GEnum && this.getClass() == obj.getClass() && this.ordinal.equals(((GEnum)obj).ordinal);
    }

    public int hashCode() {
        return this.ordinal * 27 + this.name.hashCode() * 23 + this.getClass().hashCode();
    }

    public boolean equals(GEnum e1, GEnum e2) {
        if (e1 == e2) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        if (e1.getClass() != e2.getClass()) {
            return false;
        }
        return e1.ordinal.equals(e2.ordinal);
    }

    public static Collection values(Class enumClass) {
        GEnum.checkClass(enumClass);
        Set classRegistry = GEnum.getEnumValues(enumClass);
        if (classRegistry == null) {
            return Collections.EMPTY_LIST;
        }
        return classRegistry;
    }

    public static <E extends GEnum> E valueOf(Class<E> enumClass, int ordinal) {
        Map<Object, E> classRegistry = GEnum.getEnumMap(enumClass);
        if (classRegistry != null) {
            return (E)((GEnum)classRegistry.get(ordinal));
        }
        return null;
    }

    public static <E extends GEnum> E valueOf(Class<E> enumClass, String name) {
        Map<Object, E> enumMap = GEnum.getEnumMap(enumClass);
        if (enumMap == null) {
            throw new IllegalStateException("no enum map for class :" + enumClass);
        }
        return (E)((GEnum)enumMap.get(name.toLowerCase(LOCALE_ENGLISH)));
    }

    public static <E extends GEnum> Collection<E> valuesBy(Class<E> enumClass) {
        return GEnum.getEnumValues(enumClass);
    }

    public static int enumSize(Class enumClass) {
        GEnum.checkClass(enumClass);
        Set classRegistry = GEnum.getEnumValues(enumClass);
        if (classRegistry == null) {
            return 0;
        }
        return classRegistry.size();
    }

    public static GEnum getValue(Class enumClass, Integer ordinal) {
        GEnum.checkClass(enumClass);
        return GEnum.valueOf(enumClass, ordinal);
    }

    public static GEnum getValue(Class enumClass, int ordinal) {
        GEnum.checkClass(enumClass);
        return GEnum.valueOf(enumClass, ordinal);
    }

    public static GEnum getValue(Class enumClass, String name) {
        GEnum.checkClass(enumClass);
        Map classRegistry = GEnum.getEnumMap(enumClass);
        if (classRegistry != null) {
            return (GEnum)classRegistry.get(name.toLowerCase(LOCALE_ENGLISH));
        }
        return null;
    }

    public Integer asInteger() {
        return this.ordinal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <E extends GEnum> Map<Object, E> getEnumMap(Class<E> enumClass) {
        Map<Object, ? extends GEnum> enumValues = registry.get(enumClass.getName());
        if (enumValues == null) {
            Map<String, Map<Object, ? extends GEnum>> map = registry;
            synchronized (map) {
                enumValues = registry.get(enumClass.getName());
                if (enumValues == null) {
                    try {
                        enumClass.getFields()[0].get(null);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                    enumValues = registry.get(enumClass.getName());
                }
            }
        }
        return enumValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <E extends GEnum> Set<E> getEnumValues(Class<E> enumClass) {
        Set<? extends GEnum> enumValues = registryValues.get(enumClass.getName());
        if (enumValues == null) {
            Map<String, Set<? extends GEnum>> map = registryValues;
            synchronized (map) {
                enumValues = registryValues.get(enumClass.getName());
                if (enumValues == null) {
                    try {
                        enumClass.getFields()[0].get(null);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                    enumValues = registryValues.get(enumClass.getName());
                }
            }
        }
        return enumValues;
    }

    private static void checkClass(Class enumClass) {
        if (enumClass == null) {
            throw new NullPointerException("enumClass can't be null");
        }
        if (!GEnum.class.isAssignableFrom(enumClass)) {
            throw new IllegalArgumentException("GEnum subclass expected");
        }
    }

    private void registerInstance(Class<? extends GEnum> enumClass) {
        String valueName;
        String className = enumClass.getName();
        Map<Object, ? extends GEnum> classRegistry = registry.get(className);
        if (classRegistry == null) {
            classRegistry = new HashMap<Object, GEnum>();
            registry.put(className, classRegistry);
        }
        if (classRegistry.containsKey(valueName = this.name.toLowerCase(LOCALE_ENGLISH))) {
            throw new IllegalArgumentException(enumClass.getSimpleName() + " value name duplication. The name \"" + valueName + "\" has been registered already.");
        }
        classRegistry.put(this.ordinal, this);
        classRegistry.put(valueName, this);
        Set<? extends GEnum> classRegistryVal = registryValues.get(className);
        if (classRegistryVal == null) {
            classRegistryVal = new HashSet<GEnum>();
            registryValues.put(className, classRegistryVal);
        }
        classRegistryVal.add(this);
    }
}

