/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons;

import com.genesyslab.platform.commons.util.ResourcesUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Properties;

public final class PsdkCustomization {
    private static final Properties propertiesDefaults = new Properties();

    private static void copyDefaultOption(PsdkOption option) {
        String defVal;
        String optVal = propertiesDefaults.getProperty(option.key());
        if (optVal != null && (defVal = System.getProperty(option.key())) == null) {
            System.setProperty(option.key(), optVal);
        }
    }

    public static String getOption(PsdkOption option) {
        return PsdkCustomization.getOption(option, null, null);
    }

    public static String getOption(PsdkOption option, String branch, String defaultValue) {
        String key;
        String value = null;
        String branchKey = PsdkCustomization.makeBranchKey(option, branch);
        if (branchKey != null) {
            value = System.getProperty(branchKey);
            if (value != null) {
                return value;
            }
            value = propertiesDefaults.getProperty(branchKey);
            if (value != null) {
                return value;
            }
        }
        if ((value = System.getProperty(key = option.key())) != null) {
            return value;
        }
        value = propertiesDefaults.getProperty(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static Integer getIntOption(PsdkOption option, Integer defaultValue) {
        return PsdkCustomization.getIntOption(option, null, defaultValue);
    }

    public static Integer getIntOption(PsdkOption option, String branch, Integer defaultValue) {
        String value = PsdkCustomization.getOption(option, branch, null);
        Integer iVal = defaultValue;
        if (value != null) {
            try {
                iVal = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return iVal;
    }

    public static Boolean getBoolOption(PsdkOption option, Boolean defaultValue) {
        return PsdkCustomization.getBoolOption(option, null, defaultValue);
    }

    public static Boolean getBoolOption(PsdkOption option, String branch, Boolean defaultValue) {
        String value = PsdkCustomization.getOption(option, branch, null);
        Boolean bVal = defaultValue;
        if (value != null) {
            bVal = (value = value.trim()).equals("1") || value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("on");
        }
        return bVal;
    }

    public static void setOption(PsdkOption option, String optionValue) {
        PsdkCustomization.setOption(option, null, optionValue);
    }

    public static void setOption(PsdkOption option, String branch, String optionValue) {
        String key = PsdkCustomization.makeBranchKey(option, branch);
        if (key == null) {
            key = option.key();
        }
        if (optionValue == null) {
            System.clearProperty(key);
        } else {
            System.setProperty(key, optionValue);
        }
    }

    public static String toStringDump() {
        StringBuilder sb = new StringBuilder("PsdkCustomization(\n    ");
        for (PsdkOption opt : PsdkOption.values()) {
            String val;
            String optName = opt.key();
            LinkedList<String> branches = null;
            if (opt.isBrancheable()) {
                String ikey;
                int dotPos = optName.lastIndexOf(46);
                String optPref = optName.substring(0, dotPos + 1);
                String optSuff = optName.substring(dotPos);
                branches = new LinkedList<String>();
                for (Object okey : System.getProperties().keySet()) {
                    ikey = okey.toString();
                    if (!ikey.startsWith(optPref) || !ikey.endsWith(optSuff) || ikey.length() <= optName.length()) continue;
                    branches.add(ikey.substring(optPref.length(), ikey.length() - optSuff.length()));
                }
                for (Object okey : propertiesDefaults.keySet()) {
                    String brName;
                    ikey = okey.toString();
                    if (!ikey.startsWith(optPref) || !ikey.endsWith(optSuff) || ikey.length() <= optName.length() || branches.contains(brName = ikey.substring(optPref.length(), ikey.length() - optSuff.length()))) continue;
                    branches.add(brName);
                }
            }
            if ((val = PsdkCustomization.getOption(opt)) == null && (branches == null || branches.isEmpty())) continue;
            sb.append(opt.name()).append('(').append(opt.key()).append(") ");
            if (val != null) {
                sb.append("= \"").append(val).append('\"');
            } else {
                sb.append("is not set");
            }
            sb.append("\n    ");
            if (branches == null || branches.isEmpty()) continue;
            for (String branch : branches) {
                sb.append("        + [\"").append(branch).append("\"] = ").append(PsdkCustomization.getOption(opt, branch, null)).append("\n    ");
            }
        }
        sb.setLength(sb.length() - 5);
        sb.append(')');
        return sb.toString();
    }

    private PsdkCustomization() {
    }

    private static String makeBranchKey(PsdkOption option, String branch) {
        if (branch != null && branch.length() > 0) {
            String key = option.key();
            if (!option.isBrancheable()) {
                throw new IllegalArgumentException("Option '" + key + "' does not support branching");
            }
            int pos = key.lastIndexOf(46);
            if (pos > 0) {
                return key.substring(0, pos) + '.' + branch + key.substring(pos);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream resources = null;
        try {
            resources = ResourcesUtil.getResourceAsStream("PlatformSDK.xml", PsdkCustomization.class);
            if (resources != null) {
                try {
                    propertiesDefaults.loadFromXML(resources);
                    PsdkCustomization.copyDefaultOption(PsdkOption.DOMDocumentBuilder);
                    PsdkCustomization.copyDefaultOption(PsdkOption.XMLTransformerFactory);
                    PsdkCustomization.copyDefaultOption(PsdkOption.XPathFactory);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        finally {
            if (resources != null) {
                try {
                    resources.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static enum PsdkOption {
        DefaultCharsetEncoding("com.genesyslab.platform.defaultcharset"),
        PsdkConnectionFactory("com.genesyslab.platform.commons.connection.factory.class"),
        NettyTransportType("com.genesyslab.platform.commons.connection.impl.netty.transport"),
        NettyMinServerBossThreads("com.genesyslab.platform.commons.connection.impl.netty.min-boss-threads"),
        NettyMaxServerBossThreads("com.genesyslab.platform.commons.connection.impl.netty.max-boss-threads"),
        NettyMinServerWorkerThreads("com.genesyslab.platform.commons.connection.impl.netty.min-worker-threads"),
        NettyMaxServerWorkerThreads("com.genesyslab.platform.commons.connection.impl.netty.max-worker-threads"),
        AuthorizationTicketAcquirer("com.genesys.protocol.auth.ticket.acquirer"),
        ConnExecKeepAlive("com.genesyslab.platform.commons.connection.executor.keepAliveTime"),
        ConnExecMaxPoolSize("com.genesyslab.platform.commons.connection.executor.maximumPoolSize"),
        ConnExecQueueSize("com.genesyslab.platform.commons.connection.executor.queueSize"),
        LicenseManagerClass("com.genesyslab.platform.license"),
        DOMDocumentBuilder("com.genesyslab.platform.commons.xml-doc-builder-factory"),
        XMLTransformerFactory("com.genesyslab.platform.commons.xml-transformer-factory"),
        XPathFactory("com.genesyslab.platform.commons.xml-xpath-factory"),
        WebMediaProtocolTargetXmlVersion("com.genesyslab.platform.WebMedia.target-xml-version", true),
        WebMediaProtocolReplaceIllegalUnicodeChars("com.genesyslab.platform.WebMedia.replace-illegal-unicode-chars", true),
        WebMediaProtocolIllegalUnicodeCharsReplacement("com.genesyslab.platform.WebMedia.illegal-unicode-chars-replacement", true),
        DisableUnknownProtocolMessageDelivery("com.genesyslab.platform.disable-unknown-incoming-messages", true),
        KVBindingVersion("com.genesyslab.platform.commons.collections.kvbinding.version"),
        PsdkLoggerFactory("com.genesyslab.platform.commons.log.loggerFactory"),
        PsdkLoggerDebug("com.genesyslab.platform.commons.log.debug"),
        PsdkLoggerConsoleLevel("com.genesyslab.platform.commons.log.console.level"),
        PsdkTlsDefaultVersion("com.genesyslab.platform.commons.connection.tlsDefaultVersion"),
        PsdkLoggerTraceMessages("com.genesyslab.platform.trace-messages", true),
        PsdkTimerShutdownDelay("com.genesyslab.platform.commons.timer.shutdownDelay"),
        StatServerClientCapabilities("com.genesyslab.platform.reporting.protocol.statserver.clientCapabilities"),
        ConnectionExecutorCoreThreadCount("com.genesyslab.platform.commons.connection.executor.coreThreadCount"),
        SupportURIWithIncorrectSyntax("com.genesyslab.platform.commons.protocol.supportURIWithIncorrectSyntax"),
        LogConnectionTraffic("com.genesyslab.platform.commons.connection.logTraffic"),
        DisableXmlConfData("com.genesyslab.platform.configuration.protocol.disableXmlConfData"),
        TransportFactoryImpl("com.genesys.platform.protocol.transport.factory", false),
        PsdkSocketAddressResolver("com.genesyslab.platform.commons.connection.socket-address-resolver"),
        DisableLazyParsing("com.genesyslab.platform.configuration.protocol.DisableLazyParsing", true),
        DefaultBacklog("com.genesyslab.platform.common.protocol.server.backlog", true);

        private static final long serialVersionUID = 3131902399506407072L;
        private final String key;
        private final boolean isBrancheable;

        private PsdkOption(String keyName) {
            this(keyName, false);
        }

        private PsdkOption(String keyName, boolean isBrancheable) {
            this.key = keyName;
            this.isBrancheable = isBrancheable;
        }

        public String key() {
            return this.key;
        }

        public boolean isBrancheable() {
            return this.isBrancheable;
        }
    }
}

