/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.log;

import com.genesyslab.platform.commons.log.AbstractLogger;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.spi.ExtendedLogger;

public class Log4J2LoggerImpl
extends AbstractLogger {
    public static final Marker PSDK_MESSAGE_MARKER = MarkerManager.getMarker((String)"PSDK_MESSAGE");
    public static final Marker PSDK_INT_MESSAGE_MARKER = MarkerManager.getMarker((String)"PSDK_INT_MESSAGE");
    private static final String PSDK_INT_NAMES_PREFIX = "com.genesyslab.platform";
    private static final String FQCN = Log.WrappedLogger.class.getName();
    protected final Marker marker;
    private final Logger impl;
    private final ExtendedLogger extLog;

    public Log4J2LoggerImpl(Logger impl) {
        this.impl = impl;
        this.extLog = impl instanceof ExtendedLogger ? (ExtendedLogger)impl : null;
        String name = null;
        if (impl != null) {
            name = impl.getName();
        }
        this.marker = name == null ? null : (name.startsWith(PSDK_INT_NAMES_PREFIX) ? PSDK_INT_MESSAGE_MARKER : PSDK_MESSAGE_MARKER);
    }

    @Override
    public boolean isDebug() {
        return this.impl.isDebugEnabled();
    }

    @Override
    public boolean isInfo() {
        return this.impl.isInfoEnabled();
    }

    @Override
    public boolean isError() {
        return this.impl.isErrorEnabled();
    }

    @Override
    public boolean isFatalError() {
        return this.impl.isFatalEnabled();
    }

    @Override
    public boolean isWarn() {
        return this.impl.isWarnEnabled();
    }

    @Override
    public ILogger createChildLogger(String name) {
        String newName = this.impl.getName() + "." + name;
        return new Log4J2LoggerImpl(LogManager.getLogger((String)newName));
    }

    @Override
    protected void log(Object message, Throwable thr, AbstractLogger.Level level) {
        if (this.extLog != null) {
            this.extLog.logIfEnabled(FQCN, Log4J2LoggerImpl.getPriority(level), this.marker, message, thr);
        } else {
            this.impl.log(Log4J2LoggerImpl.getPriority(level), this.marker, message, thr);
        }
    }

    @Override
    protected void logArgs(String message, Object args, AbstractLogger.Level level) {
        if (this.extLog != null) {
            this.extLog.logIfEnabled(FQCN, Log4J2LoggerImpl.getPriority(level), this.marker, Log4J2LoggerImpl.formatMessage(message, args));
        } else {
            this.impl.log(Log4J2LoggerImpl.getPriority(level), this.marker, Log4J2LoggerImpl.formatMessage(message, args));
        }
    }

    private static Level getPriority(AbstractLogger.Level level) {
        if (level == AbstractLogger.Level.DEBUG) {
            return Level.DEBUG;
        }
        if (level == AbstractLogger.Level.INFO) {
            return Level.INFO;
        }
        if (level == AbstractLogger.Level.ERROR) {
            return Level.ERROR;
        }
        if (level == AbstractLogger.Level.FATAL_ERROR) {
            return Level.FATAL;
        }
        if (level == AbstractLogger.Level.WARN) {
            return Level.WARN;
        }
        return Level.DEBUG;
    }
}

